/*
 * FILE: PolygonFunc.cpp
 *
 * DESCRIPTION: Functions for polygon
 *
 * CREATED BY: Jiang Dalong, 2005/03/14
 *
 * HISTORY: 
 *
 * Copyright (c) 2001-2008 Archosaur Studio, All Rights Reserved.
 */

/*
 * 1Ƿڶ㷨ԭ
 * ӼXһߣεĽΪڶڣ
 * Ϊżڶ⡣
 * غϣΪñûн㣻
 * ߴ㣬ͼ1ʾΪ2б߶ཻͼ2ʾֻ1бཻ
 *     \  /    \    /              __/__    __/____
 *    __\/__  __\__/__                \          \
 *          ͼ1                          ͼ2
 * Ϊ㣬㷨б߽ϵĵΪڶ⡣
 */

#include "PolygonFunc.h"


// жһǷڶ
// pt:ꣻptLines:Σõ㼯ʾnNumLine:ζ㣨ߣĸ
bool IsInPolyGon(POINT_FLOAT pt, POINT_FLOAT* ptLines, int nNumLine)
{
	if (nNumLine < 3)// Ƕ
		return false;

	int nNumCross = 0;// ν

	for (int i=0; i<nNumLine; i++)
	{
		if (IsCrossLine(pt, ptLines, i, nNumLine))// ӼҲǷñཻ
			nNumCross++;
	}

	if ((nNumCross & 1) == 0)// ż㣬ڶ
		return false;
	else// 㣬ڶ
		return true;
}

// жǷཻ
// pt:Ե㣻ptLines:ζ㼯nIndex:ߣһ㣩ţnNumLine:ܱߣ㣩
bool IsCrossLine(POINT_FLOAT pt, POINT_FLOAT* ptLines, int nIndex, int nNumLine)
{
	POINT_FLOAT ptLine1 = ptLines[nIndex];// ߶ζ1
	POINT_FLOAT ptLine2 = ptLines[(nIndex+1)%nNumLine];// ߶ζ2

	if (ptLine1.x < pt.x && ptLine2.x < pt.x)// ߶
		return false;

	if (ptLine1.y < pt.y && ptLine2.y < pt.y)// ߶ϱ
		return false;

	if (ptLine1.y > pt.y && ptLine2.y > pt.y)// ߶±
		return false;

	if (ptLine1.y == ptLine2.y)// ߶ͬһˮƽ
		return false;

	if (pt.y == ptLine1.y)// ߴ߶ζ1
	{
		// ҵ1֮ǰ߲ͬһˮƽϵĵ
		POINT_FLOAT ptLinePre;// 1֮ǰĵ
		bool bFind = false;
		for (int i=1; i<nNumLine; i++)
		{
			ptLinePre = ptLines[(nIndex + nNumLine - i) % nNumLine];
			if (ptLinePre.y != pt.y)// ɨ
			{
				bFind = true;
				break;
			}
		}
		if (!bFind)// ûҵĵ㣨еͬһˮƽϣ
			return false;

		if ((ptLinePre.y < pt.y && ptLine2.y > pt.y)
			|| (ptLinePre.y > pt.y && ptLine2.y < pt.y))// 1֮ǰ붥2
			return false;
	}

	// ߵĽ
	float fSlope = (ptLine2.x - ptLine1.x) / (ptLine2.y - ptLine1.y);
	float fCrossX = (pt.y - ptLine1.y) * fSlope + ptLine1.x;
	if (fCrossX <= pt.x)//ڲԵ
		return false;

	return true;
}