//////////////////////////////////////////////////////////////////////
//	Created by He wenfeng
//  2004-11-25
//  A class describes the face of a ConvexHullData
//  It is derived from CHalfSpace and it consists 
//  a set of vertices'ids by order
//////////////////////////////////////////////////////////////////////

#ifndef	_FACE_H_
#define _FACE_H_

#define MAX_LEN	110

#include <AArray.h>
#include "HalfSpace.h"
//#include <fstream>

namespace CHBasedCD
{

class CConvexHullData;

class CFace : public CHalfSpace  
{
	static float AngleAcuteThresh;				// ߼ǵֵ

public:

	const CFace& operator=(const CFace& face);		//һֵ
	CFace(const CFace& face);						//һ캯

	CFace();
	virtual ~CFace();
	
	static void SetAngleAcuteThresh(float AAThresh)		
	{
		AngleAcuteThresh=AAThresh;
	}

	void SetHS(const CHalfSpace& hs)
	{
		SetNormal(hs.GetNormal());
		SetD(hs.GetDist());
	}

	// صvPosm_arrEdgeHSsm_arrExtraHSs̾Halfspace
	CHalfSpace GetNearestHS(const A3DVECTOR3& vPos )  const ;

	void SetCHData(CConvexHullData* pCHData) { m_pCHData=pCHData; }

	// ı߽ռ
	void ComputeExtraHS();

	// Ƭб任任ΪmtxTrans
	virtual void Transform(const A3DMATRIX4& mtxTrans);

	//ãնͱƽ
	void Reset() { m_arrVIDs.RemoveAll(); m_arrEdgeHSs.RemoveAll(); m_arrExtraHSs.RemoveAll(); }

	int GetEdgeNum() const { return m_arrVIDs.GetSize();}
	int GetVNum() const { return m_arrVIDs.GetSize();}
	int GetExtraHSNum() const { return m_arrExtraHSs.GetSize(); }

	CHalfSpace GetExtraHalfSpace(int id) const { return m_arrExtraHSs[id];}
	CHalfSpace GetEdgeHalfSpace(int eid) const { return m_arrEdgeHSs[eid];}
	int GetVID(int i) const { return m_arrVIDs[i];}

	void AddExtraHS(const CHalfSpace& hs) { m_arrExtraHSs.Add(hs); }

	//һԪأͬʱһvid͸vidһidɵıӦHalfSpace
	void AddElement(int vid,const CHalfSpace& hs){ m_arrVIDs.Add(vid);m_arrEdgeHSs.Add(hs);}

	/************************************************************************
	// Removed by wenfeng, 05-3-28
	// гstd::fstreamĿ⣬ҪVC֧֣

	//Ӧһļ
	bool LoadFromStream(std::ifstream& InFile);
	bool SaveToStream(std::ofstream& OutFile) const;
	/************************************************************************/

	//ӦһļFILE
	bool LoadFromStream(FILE* InFile);
	bool SaveToStream(FILE* OutFile) const;	

protected:
	
	void AddExtraHS(int i);			// ԵiһƬ

private:
	CConvexHullData* m_pCHData;				// ¼͹ָ
	AArray<int, int> m_arrVIDs;						//˳¼id
	AArray<CHalfSpace,const CHalfSpace&> m_arrEdgeHSs;		//˳ͬϣ¼һߺ͸ķhalfspace
	AArray<CHalfSpace,const CHalfSpace&> m_arrExtraHSs;		//нʱӵһHs!
};

}	// end namespace

#endif // _FACE_H_
