// ConvexHullAlgorithm.h: interface for the CConvexHullAlgorithm class.
//
//////////////////////////////////////////////////////////////////////

#ifndef	_CONVEXHULL_ALGORITHM_H_
#define _CONVEXHULL_ALGORITHM_H_

#include <A3DVector.h>
#include <AArray.h>

namespace CHBasedCD
{


//öķʽṹߡ
struct Face;

struct Edge
{
	unsigned int start;
	unsigned int end;

	Edge() {}		//ȱʡ캯,do nothing
	Edge(unsigned int v1,unsigned int v2){Set(v1,v2);}
	void Set(unsigned int v1,unsigned int v2){start=v1; end=v2;}
	bool InFace(const Face& f) const;
};

struct Face
{
	unsigned int v1;
	unsigned int v2;
	unsigned int v3;
	
	//2004-9-20
	//жϸǷΪͨιģ͹ǵ㷨
	//ЩεĲΪĻƣʵһĶεһ֣
	//ڱΪtrueΣǲڽCConvexPolytopepatch
	//ֱӽpolygonһμ
	bool InPolygon;			

	Face() {}		//ȱʡ캯,do nothing
	Face(unsigned int p1,unsigned int p2,unsigned int p3,bool InP=false) {v1=p1;v2=p2;v3=p3;InPolygon=InP;}
	bool operator == (const Face& f) const;
};

/////////////////////////////////////////////////
//	created by He wenfeng
//  2004-8-17
//  A base class to compute the convex hull of 3D point set
/////////////////////////////////////////////////
class CConvexHullAlgorithm  
{
public:
	bool IsEdgeInCH(const Edge& e) const;
	void Reset();
	bool IsVInVSets(int vID, const AArray<int,int>* pVSets) const;
	bool IsFaceInCH(const Face& f) const;
	CConvexHullAlgorithm();
	virtual ~CConvexHullAlgorithm();

	A3DVECTOR3 GetCentroid() { return m_vCentroid;}

//operations
	virtual void SetVertexes(A3DVECTOR3* pVertexes,int vNum,bool bTranslate=false);	//޸ĳ麯и
	AArray<Face, const Face&>& GetCHFaces() { return m_Faces;}	//Ͷ÷ʽ

//virtual operations
	virtual void ComputeConvexHull()=0;		//飬	

//Attributes
protected:
	A3DVECTOR3				m_vCentroid;	//㼯
	
	A3DVECTOR3 *			m_pVertexes;	//㼯ϣ鷽ʽ֯
											//עñΪͽӿڵߵһãnewdelete!

public:
	int						m_nVNum;		//
	
	AArray<Face, const Face&>		m_Faces;		//ݶ͹ǣƬʾ
	
	bool*					m_pbVInvalid;	//Ӧÿһ㣬־õǷڹ湲ߵΪЧ
	
	bool*					m_pbExtremeVertex;		//Ӧÿһ㣬־õǷΪExtreme Vertex!͹ϵĵ
	
	//޸ĺٶȻԭȻm_planes
	//ˣһЩm_planesвfaceedgeĲʱ临Ӷȣ
	//ʴ޸ķ


	//޸2004-9-20
	//Ϊ˱ڹӦ͹壬޸m_Planesʹеƽ
	//ΣǰĶ岻Σ

	//Ӧж(>3)Щƽ漯б
	AArray<AArray<int,int>*,AArray<int,int>*>		m_Planes;
};


}	// end namespace

#endif // _CONVEXHULL_ALGORITHM_H_