/*
* FILE: IAFileDialog.h
*
* DESCRIPTION: 
*
* CREATED BY: Zhangyachuan, 2010/03/18
*
* HISTORY: 
*
* Copyright (c) 2009 Archosaur Studio, All Rights Reserved.
*/

#ifndef _IAFileDialog_H_
#define _IAFileDialog_H_


///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Types and Global variables
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Declare of Global functions
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Class IAFileDialog
//	
///////////////////////////////////////////////////////////////////////////

class IAFileDialog
{

public:		//	Types

public:		//	Constructor and Destructor

	virtual ~IAFileDialog(void) = 0 {}

public:		//	Attributes

public:		//	Operations

	//	Create a file dialog
	virtual INT_PTR DoModal() = 0;
	//	Get relative file path with out basedir and restrict_dir.
	virtual const TCHAR* GetRelativeFileName() = 0;
	//	Get full file path name
	virtual const TCHAR* GetFullFileName() const = 0;
	//	Get selected files
	virtual const AFVector<CString> GetSelFiles() const = 0;
	//	Set init path relative to restrict_dir
	virtual void SetInitSubDir(const TCHAR* szSubDir){};

protected:	//	Attributes

protected:	//	Operations

};

///////////////////////////////////////////////////////////////////////////
//	
//	Inline functions
//	
///////////////////////////////////////////////////////////////////////////


#endif	//	_IAFileDialog_H_


