/*
 * FILE: AMSurfaceRenderer.h
 *
 * DESCRIPTION: The class standing for the directshow filter which render video 
 *				into an A3DSurface object of Angelica Media Engine
 *
 * CREATED BY: Hedi, 2002/5/22
 *
 * HISTORY:
 *
 * Copyright (c) 2001~2003 Archosaur Studio, All Rights Reserved.	
 */

#ifndef _AMSURFACERENDERER_H_
#define _AMSURFACERENDERER_H_

#include "AMPlatform.h"
#include "AMTypes.h"

#include <A2DSprite.h>
#include <streams.h>

//-----------------------------------------------------------------------------
// Define GUID for Surface Renderer
// {75277FF8-6E80-4850-BD0A-E9D1CCECDFB9} generated by GUIDGEN.exe shipped with MSDEV
//-----------------------------------------------------------------------------
struct __declspec(uuid("{75277FF8-6E80-4850-BD0A-E9D1CCECDFB9}")) CLSID_SurfaceRenderer;

class AMSurfaceRenderer : public CBaseVideoRenderer
{
private:
	A3DFORMAT			m_fmtVideo;
	A2DSprite *			m_pDestSprite;
	
	CRITICAL_SECTION *	m_pSurfaceAccess;

public:
    AMSurfaceRenderer(LPUNKNOWN pUnk,HRESULT *phr);
    virtual ~AMSurfaceRenderer();

public:
    HRESULT CheckMediaType(const CMediaType *pmt );     // Format acceptable?
    HRESULT SetMediaType(const CMediaType *pmt );       // Video format notification
    HRESULT DoRenderSample(IMediaSample *pMediaSample); // New video sample
    
	LONG m_lVidWidth;	// Video width
	LONG m_lVidHeight;	// Video Height
	LONG m_lVidPitch;	// Video Pitch

	inline LONG GetVidWidth() { return m_lVidWidth; }
	inline LONG GetVidHeight() { return m_lVidHeight; }
	inline LONG GetVidPitch() { return m_lVidPitch; }
	inline A3DFORMAT GetVidFormat() { return m_fmtVideo; }

	inline A2DSprite * GetDestSprite() { return m_pDestSprite; }
	inline void SetDestParameter(A2DSprite * pDestSprite, CRITICAL_SECTION * pSurfaceAccess) 
	{ 
		m_pDestSprite = pDestSprite; 
		m_pSurfaceAccess = pSurfaceAccess;
	}
};

#endif
