// Filename	: WikiPage.h
// Creator	: Xu Wenbin
// Date		: 2010/04/08

#pragma once

#include <vector.h>

//
//	WikiPage:	ҳ
//				Ҫṩǰҳ
//				ṩÿҳıǼ¼
//
template <typename P>
class WikiPage
{
public:
	typedef P PAGE_POSITION;

	WikiPage()
		: m_bLastPage(false)
		, m_bEmpty(true)
	{}

	void FirstPage(const PAGE_POSITION & p0){
		// ¿ʼ¼ҳp0ΪҳĿʼ
		m_pagesBegin.clear();
		m_pagesBegin.push_back(p0);		//	һδҳΪһҳ
		m_bLastPage = false;
		m_bEmpty = true;
	}
	void AddPageItem(){
		// ӱҳһĿ
		m_bEmpty = false;
	}
	void AddPage(const PAGE_POSITION &p){
		// ҳ
		m_pagesBegin.push_back(p);
	}
	void FinishPage(){
		// ҳλü¼ָʾһҳΪһҳ		
		m_bLastPage = true;
	}

	int  GetPagesCount()const{
		return (int)m_pagesBegin.size();
	}
	const PAGE_POSITION & GetPageBack()const{
		return m_pagesBegin.back();
	}
	bool IsPageInvalid()const{
		return m_pagesBegin.empty();
	}
	bool IsPageEmpty()const{
		return m_bEmpty;
	}
	bool HaveNextPage()const{

		// жǷһҳ

		return !m_bLastPage && m_pagesBegin.size()>1;
	}
	bool HavePrevPage()const{
		
		// жǷԷǰҳǰһҳ

		if (m_pagesBegin.size() == 0)
		{
			return false;
		}		
		if (m_pagesBegin.size() == 1)
		{
			//  m_pagesBegin size Ϊ 1ʾֻһҳδչ
			return false;
		}		
		if (m_pagesBegin.size() == 2)
		{
			if (!m_bLastPage)
			{
				//  m_pagesBegin size Ϊ 2ʾǰֻ˵һҳһҳд
				return false;
			}
		}
		return true;
	}

	void PrevPage(){

		// ǰҳǰһҳ

		if (!HavePrevPage())
			return;

		// ʼλ
		if (!m_bLastPage){
			m_pagesBegin.pop_back();//	һҳǰҳһҳĿʼλ
		}
		m_pagesBegin.pop_back();	//	ǰҳĿʼλ
		m_bLastPage = false;		//	Ѿһҳ
	}
	
	void Clear()
	{
		m_pagesBegin.clear();
		m_bLastPage = false;
		m_bEmpty = true;
	}

private:

	abase::vector<PAGE_POSITION> m_pagesBegin;	//	¼ÿҳĿʼλ
	bool m_bLastPage;	//	ǰҳǷһҳ
	bool m_bEmpty;		//	ϴǷûκҳ
};
