/*
 * FILE: EC_Resource.h
 *
 * DESCRIPTION: 
 *
 * CREATED BY: Duyuxin, 2004/12/18
 *
 * HISTORY: 
 *
 * Copyright (c) 2004 Archosaur Studio, All Rights Reserved.
 */

#pragma once

///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////

//	Cursor resource
enum
{
	RES_CUR_NORMAL = 0,
	RES_CUR_ATTACK,
	RES_CUR_TALK,
	RES_CUR_PICKUP,
	RES_CUR_REPAIR,
	RES_CUR_HAND,
	RES_CUR_FLAG,
	RES_CUR_DIG,
	RES_CUR_SWALLOW,
	NUM_RES_CURSOR,
};

//	GFX resource
enum
{
	RES_GFX_LEVELUP = 0,
	RES_GFX_PLAYERAPPEAR,
	RES_GFX_HIT,
	RES_GFX_MOVETARGET,
	RES_GFX_ITEMFLASH,
	RES_GFX_CURSORHOVER,
	RES_GFX_SELECTED,
	RES_GFX_FLOATING_DUST,
	RES_GFX_WATER_WAVE_STILL,
	RES_GFX_WATER_WAVE_MOVE,
	RES_GFX_AIR_BUBBLE,
	RES_GFX_SWIM_BUBBLE,
	RES_GFX_TRANSFORM_TIGER,
	RES_GFX_TRANSFORM_FOX,
	RES_GFX_RED_MEDICINE,
	RES_GFX_BLUE_MEDICINE,
	RES_GFX_PURPLE_MEDICINE,
	RES_GFX_JIEDU_MEDICINE,
	RES_GFX_PHYSIC_ARMORRUNE,
	RES_GFX_MAGIC_ARMORRUNE,
	RES_GFX_INDUEL,
	RES_GFX_TANKLEADER_RED,
	RES_GFX_TANKLEADER_BLUE,
	RES_GFX_GOBLIN_LEVELUP,
	RES_GFX_INVISIBLE_DETECTED,
	RES_GFX_MONSTER_SPIRIT_LINE,
	RES_GFX_MONSTER_SPIRIT_BALL,
	RES_GFX_REALM_LEVELUP,
	RES_GFX_BATTLEFURY,
	RES_GFX_MONSTER_LOCAL,
	NUM_RES_GFX,
};

//	Sound resource

//	Texture resource

//	Shader resource
enum
{
	RES_SHD_HAIR = 0,
	RES_SHD_GOATEE,
	RES_SHD_FACE,
	RES_SHD_EYE,
	RES_SHD_BROW,

	RES_SHD_MOUTH,	//	5
	RES_SHD_NOSE,		
	RES_SHD_EYEBALL,
	RES_SHD_MOUSTACHE,
	RES_SHD_BODY,

	NUM_RES_SHADER,	// 10
};

//	Icon resource
enum
{
	RES_ICON_CMD_SITDOWN = 0,
	RES_ICON_CMD_WALKRUN,
	RES_ICON_CMD_NORMALATTACK,
	RES_ICON_CMD_FINDTARGET,
	RES_ICON_CMD_ASSISTATTACK,

	RES_ICON_CMD_INVITETOTEAM,		//	5
	RES_ICON_CMD_LEAVETEAM,	
	RES_ICON_CMD_KICKTEAMMEM,
	RES_ICON_CMD_FINDTEAM,
	RES_ICON_CMD_STARTTRADE,

	RES_ICON_CMD_SELLBOOTH,			//	10
	RES_ICON_CMD_BUYBOOTH,
	RES_ICON_CMD_INVITETOFACTION,
	RES_ICON_CMD_FLY,
	RES_ICON_CMD_EXP_WAVE,

	RES_ICON_CMD_EXP_NOD,			//	15
	RES_ICON_CMD_EXP_SHAKEHEAD,
	RES_ICON_CMD_EXP_SHRUG,	
	RES_ICON_CMD_EXP_LAUGH,	
	RES_ICON_CMD_EXP_ANGRY,	

	RES_ICON_CMD_EXP_STUN,			//	20
	RES_ICON_CMD_EXP_DEPRESSED,
	RES_ICON_CMD_EXP_KISSHAND,
	RES_ICON_CMD_EXP_SHY,	
	RES_ICON_CMD_EXP_SALUTE,	

	RES_ICON_CMD_EXP_SITDOWN,		//	25
	RES_ICON_CMD_EXP_ASSAULT,
	RES_ICON_CMD_EXP_THINK,	
	RES_ICON_CMD_EXP_DEFIANCE,
	RES_ICON_CMD_EXP_VICTORY,

	RES_ICON_CMD_EXP_GAPE,			//	30
	RES_ICON_CMD_EXP_KISS,	
	RES_ICON_CMD_EXP_FIGHT,	
	RES_ICON_CMD_EXP_ATTACK1,
	RES_ICON_CMD_EXP_ATTACK2,

	RES_ICON_CMD_EXP_ATTACK3,		//	35
	RES_ICON_CMD_EXP_ATTACK4,
	RES_ICON_CMD_EXP_DEFENCE,
	RES_ICON_CMD_EXP_FALL,	
	RES_ICON_CMD_EXP_FALLONGROUND,

	RES_ICON_CMD_EXP_LOOKAROUND,	//	40
	RES_ICON_CMD_EXP_DANCE,
	RES_ICON_CMD_EXP_FASHIONWEAPON,
	RES_ICON_CMD_PICKUP,
	RES_ICON_CMD_GATHER,
	RES_ICON_CMD_RUSHFLY,
	
	RES_ICON_CMD_BINDBUDDY,
	RES_ICON_CMD_TWOKISS,  // 
	RES_ICON_CMD_JUMPTRICK,
	RES_ICON_CMD_RUNTRICK,

	RES_ICON_CMD_PICKUP_ALL,
	
	NUM_RES_ICON,
};

//	Model resource
enum
{
	RES_MOD_GOLD = 0,
	RES_MOD_TEMP,
	RES_MOD_WARRIOR_M,
	RES_MOD_WARRIOR_F,
	RES_MOD_MAGE_M,
	RES_MOD_MAGE_F,
	RES_MOD_MONK_M,
	RES_MOD_MONK_F,
	RES_MOD_HAG_M,
	RES_MOD_HAG_F,
	RES_MOD_ORC_M,
	RES_MOD_ORC_F,
	RES_MOD_GHOST_M,
	RES_MOD_GHOST_F,
	RES_MOD_ARCHOR_M,
	RES_MOD_ARCHOR_F,
	RES_MOD_ANGEL_M,
	RES_MOD_ANGEL_F,
	RES_MOD_JIANLING_M,
	RES_MOD_JIANLING_F,
	RES_MOD_MEILING_M,
	RES_MOD_MEILING_F,
	RES_MOD_ORC_TIGER,
	RES_MOD_ORC_FOX,
	RES_MOD_SHADOW_FISH_M,
	RES_MOD_SHADOW_FISH_F,
	RES_MOD_MONEYFROG,
	RES_MOD_WEDDING_KID_M,
	RES_MOD_WEDDING_KID_F,
	RES_MOD_SOLDIER,
	RES_MOD_TREEBIRD,
	RES_MOD_EVIL_TIGER,
	RES_MOD_RED_SQUIRREL,
	RES_MOD_LAND_TURTLE,
	RES_MOD_BRIDE_COUSIN,
	RES_MOD_SENTRY_PUPPET,
	RES_MOD_PENGUIN_KING,
	RES_MOD_PENGUIN_QUEEN,
	RES_MOD_SNOW_RABBIT,
	RES_MOD_TEDDY_BEAR,
	RES_MOD_RED_SQUIRREL_BIG,
	RES_MOD_TREEBIRD_BIG,
	RES_MOD_SENTRY_ANGRY,
	RES_MOD_SENTRY_DEPRESSED,
	RES_MOD_SENTRY_LOST,
	RES_MOD_SNOW_RABBIT_BLAZE,
	RES_MOD_DRAGON,
	RES_MOD_ORC_PANDER,
	RES_MOD_ORC_FOX2,
	RES_MOD_DEFAULT_BOOTH_M,
	RES_MOD_DEFAULT_BOOTH_F,
	RES_MOD_YEYING_M,
	RES_MOD_YEYING_F,
	RES_MOD_YUEXIAN_M,
	RES_MOD_YUEXIAN_F,
	RES_MOD_YEYING_RESHAPE_M,
	RES_MOD_YEYING_RESHAPE_F,
	RES_MOD_YUEXIAN_RESHAPE_M,
	RES_MOD_YUEXIAN_RESHAPE_F,
	NUM_RES_MODEL,
};

// model file for change shape 2 
enum 
{
	RES_MOD_CHANGESAHPE_NULL,	// 0
	RES_MOD_CHARIOT_1, 
	RES_MOD_CHARIOT_2,
	RES_MOD_CHARIOT_3,
	RES_MOD_CHARIOT_4,
	RES_MOD_CHARIOT_5,			//5
	RES_MOD_CHARIOT_6,  
	RES_MOD_CHARIOT_7,
	RES_MOD_CHARIOT_8,
	RES_MOD_CHARIOT_9,
	RES_MOD_DEPRESSEC_AGED_PERSION,	//10
	RES_MOD_RED_BEAR,
	RES_MOD_PONYCAR,
	RES_MOD_SNOWMAN,

	RES_MOD_CHANGESAHPE_MONEY_FROG = 26, 
	RES_MOD_CHANGESAHPE_USED = 52, // 26-52 ѱʹ

	RES_MOD_FORCHANGESAHPE_NUM,
};
//	Some unicode string resources
enum
{
	RES_FONT_TITLE = 0,
	RES_FONT_DAMAGE,
	NUM_RES_FONT,
};

///////////////////////////////////////////////////////////////////////////
//	
//	Types and Global variables
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Declare of Global functions
//	
///////////////////////////////////////////////////////////////////////////

const char* res_CursorFile(int n);
const char* res_GFXFile(int n);
const char* res_SoundFile(int n);
const char* res_TextureFile(int n);
const char* res_ShaderFile(int n);
const char* res_IconFile(int n);
const char* res_ModelFile(int n);
const char* res_SysModuleIconFile(int n);
const char* res_ModelFileForChangeShape2(int n);
///////////////////////////////////////////////////////////////////////////
//	
//	Inline functions
//	
///////////////////////////////////////////////////////////////////////////

