// File		: EC_ProfDisplay.h
// Creator	: Xu Wenbin
// Date		: 2013/9/27

#pragma once

#include "EC_RoleTypes.h"

#include <A3DVector.h>
#include <ABaseDef.h>

//	RotateAnimator : ȡתչʾиλ
class RotateAnimator
{
	A3DVECTOR3	m_center;		//	תλ
	float		m_radius;		//	Ŀ m_center 
	int			m_count;		//	ΧĵĿ
	float		m_deltaDist;	//	ͬһλòְͬҵλü
	float		m_selectMove;	//	ѡְҵƶ루δѡʱλã
	A3DVECTOR3	m_dir;			//	תǶΪ0ʱӦ
	A3DVECTOR3	m_dirTangent;	//	m_dir ڼλƫƣﵽһλøȡλõ
	double		m_angleStart;	//	תĿĿʼλ
	double		m_angle;		//	ǰǶ
	double		m_angleTarget;		//	ĿǶ
	DWORD		m_timeCost;			//	תĿ껨ʱ
	DWORD		m_timeElapsed;		//	תĿλѻѵʱ䣨m_angleStartλøʱ
	bool		m_rotating;			//	Ƿת
	int			m_firstIndicator;	//	δתʱת̼ͷָλ±
	int			m_targetIndicator;	//	ת̼ͷսָλ±

	enum RotateDirection
	{
		ROTATE_CLOCKWISE,		//	˳ʱת
		ROTATE_ANTICLOCKWISE,	//	ʱת
	};
	RotateDirection	m_rotateDir;
	
	RotateAnimator(int count);
	RotateAnimator(const RotateAnimator &);
	RotateAnimator & operator=(const RotateAnimator &);

public:
	static const float RA_DEFAULT_RADIUS;
	static const float RA_DEFAULT_DELTA_DIST;
	static const float RA_DEFAULT_SELECT_MOVE;

	static RotateAnimator & Instance();

	double GetAngleBetween()const;
	void SetCenter(const A3DVECTOR3 &center);
	void SetDir(const A3DVECTOR3 &dir);
	const A3DVECTOR3 & GetDir()const;
	void SetRadius(float radius);
	void SetDeltaDist(float dist);
	void SetSelectMove(float dist);
	float GetSelectMove()const;
	void SetFirstIndicator(int indicator);
	double GetBestAngleRepresentation(double angle);
	void RotateToIndicator(int indicator);
	bool Tick(DWORD dwDeltaTime);
	void RotateFinished();
	bool IsRotating()const{ return m_rotating; }
	A3DVECTOR3 GetCenteredIndicatorPos(int indicator);
	A3DVECTOR3 GetIndicatorPos(int indicator);
	A3DVECTOR3 GetIndicatorDeltaPos(int deltaIndex, float fMoveFrontRatio);
};

//	ʱһ Trigger
class ActionTrigger
{
	bool	m_bTriggered;
	DWORD	m_triggerTime;
	DWORD	m_triggerLength;
public:
	ActionTrigger();
	void Reset();
	void StartCounting(DWORD dwTime);
	void ReverseCounting(DWORD dwTime);
	void Tick(DWORD dwDeltaTime);
	bool GetTriggered();
	float GetLeftPercent()const;
};

class ProfessionTrigger;
//	ְҵΪõ״̬
class ProfessionTriggerState
{
	ProfessionTrigger*	m_parent;
public:
	virtual ~ProfessionTriggerState(){}
	ProfessionTriggerState() : m_parent(NULL){
	}
	void Init(ProfessionTrigger *parent){
		m_parent = parent;
	}
	ProfessionTrigger * GetParent(){
		return m_parent;
	}
	virtual void TriggerMoveFront(){}
	virtual void TriggerGoback(){}
	virtual void Enter(ProfessionTriggerState *prev){}
	virtual void Tick(DWORD dwDeltaTime){}
	virtual void Rest(){}
	virtual float GetBackToFrontRatio(){ return 0.0f; }
};
class PTStateBack : public ProfessionTriggerState
{
	//	Ĭ״̬վĬλþĬ
public:
	virtual void TriggerMoveFront();
	virtual void Enter(ProfessionTriggerState *prev);
};
class PTStateWaitRotator : public ProfessionTriggerState
{
	//	ĬλáѡУȴתɿ״̬
public:
	virtual void TriggerGoback();
	virtual void Enter(ProfessionTriggerState *prev);
	virtual void Tick(DWORD dwDeltaTime);
	virtual void Rest();
};
class PTStateWaitMoveFront : public ProfessionTriggerState
{
	//	ȴʼƶ
public:
	virtual void TriggerGoback();
	virtual void Enter(ProfessionTriggerState *prev);
	virtual void Tick(DWORD dwDeltaTime);
	virtual void Rest();
};
class PTStateMoveFront : public ProfessionTriggerState
{
	//	߽ƶ
public:
	virtual void TriggerGoback();
	virtual void Enter(ProfessionTriggerState *prev);
	virtual void Tick(DWORD dwDeltaTime);
	virtual void Rest();
	virtual float GetBackToFrontRatio();
};
class PTStateWaitDisplay : public ProfessionTriggerState
{
	//	ȴչʾ
public:
	virtual void TriggerGoback();
	virtual void Enter(ProfessionTriggerState *prev);
	virtual void Tick(DWORD dwDeltaTime);
	virtual float GetBackToFrontRatio(){ return 1.0f; }
};
class PTStateDisplay : public ProfessionTriggerState
{
	//	չʾ...
public:
	virtual void TriggerGoback();
	virtual void Enter(ProfessionTriggerState *prev);
	virtual void Rest();
	virtual float GetBackToFrontRatio(){ return 1.0f; }
};
class PTStateGoback : public ProfessionTriggerState
{
	//	߻Ĭλƶ...
public:
	virtual void TriggerMoveFront();
	virtual void Enter(ProfessionTriggerState *prev);
	virtual void Tick(DWORD dwDeltaTime);
	virtual void Rest();
	virtual float GetBackToFrontRatio();
};

//	ְҵΪ
class ProfessionTrigger
{	
	ProfessionTriggerState*	m_curState;

	PTStateBack				m_stateBack;
	PTStateWaitRotator		m_stateWaitRotator;
	PTStateWaitMoveFront	m_stateWaitMoveFront;
	PTStateMoveFront		m_stateMoveFront;
	PTStateWaitDisplay		m_stateWaitDisplay;
	PTStateDisplay			m_stateDisplay;
	PTStateGoback			m_stateGoback;
	
	//	״̬õĶ
	ActionTrigger			m_counter;
	bool					m_moveFrontActionTriggered;
	bool					m_gobackActionTriggered;
	bool					m_displayActionTriggered;
	bool					m_standActionTriggered;

public:
	ProfessionTrigger();
	void Reset();

	//	ת State ķ
	void TriggerMoveFront();
	void TriggerGoback();
	void Tick(DWORD dwDeltaTime);
	void Rest();
	float GetBackToFrontRatio();
	
	//	 State ʹõķ
	void ChangeState(ProfessionTriggerState *state);
	ProfessionTriggerState * GetStateBack(){ return &m_stateBack; }
	ProfessionTriggerState * GetStateWaitRotator(){ return &m_stateWaitRotator; }
	ProfessionTriggerState * GetStateWaitMoveFront(){ return &m_stateWaitMoveFront; }
	ProfessionTriggerState * GetStateMoveFront(){ return &m_stateMoveFront; }
	ProfessionTriggerState * GetStateWaitDisplay(){ return &m_stateWaitDisplay; }
	ProfessionTriggerState * GetStateDisplay(){ return &m_stateDisplay; }
	ProfessionTriggerState * GetStateGoback(){ return &m_stateGoback; }
	ActionTrigger & GetTrigger(){ return m_counter; }
	void TriggerMoveFrontAction();
	void TriggerGobackAction();
	void TriggerDisplayAction();
	void TriggerStandAction();
	void ClearTriggerAction();

	//	ѯ
	bool MoveFrontActionTriggered();
	bool GobackActionTriggered();
	bool DisplayActionTriggered();
	bool StandActionTriggered();
	bool IsGoingback();
};

//	ְҵչʾſ
class DisplayActionTrigger
{
	ProfessionTrigger	m_trigger[NUM_PROFESSION];

	DisplayActionTrigger();
	DisplayActionTrigger(const DisplayActionTrigger &);
	DisplayActionTrigger & operator=(const DisplayActionTrigger &);

	bool Validate(int prof);

public:
	static DisplayActionTrigger & Instance();

	void Reset();
	void Rest();
	void Trigger(int prof);
	void Tick(DWORD dwDeltaTime);
	bool MoveFrontActionTriggered(int prof);
	bool GoBackActionTriggered(int prof);
	bool DisplayActionTriggered(int prof);
	bool StandActionTriggered(int prof);
	void GetPosDir(int prof, A3DVECTOR3& vPos, A3DVECTOR3& dir);
};
