// Filename	: EC_PolicyAction.h
// Creator	: Xu Wenbin
// Date		: 2011/04/02

#pragma once

#include <AString.h>
#include <ABaseDef.h>

namespace S2C
{
	struct cmd_object_start_play_action;
}

//	Զ
class CECPolicyAction 
{
private:
	//	Э
	int			m_timeLength;			//	Զʱ䣨룩=play_times*actionTime+(play_times-1)*interval_time
	int			m_actionTime;			//	˴Ķʱ䣨룩
	int			m_intervalTime;		//	Ŷʱ䣨룩
	int			m_playTimes;			//	ܲŴ
	AString		m_actionName;	//	ecm ģж
	
	//	״̬
	bool		m_validPolicy;		//	ЭǷϷ
	bool		m_inPolicy;			//	ԶǷλ״̬
	bool		m_inPlay;			//	Ϊ true ʱʾڲŶΪ false ڶ interval
	DWORD	m_policyTimer;	//	Զ嶨ʱ
	int				m_playedTimes;	//	ѲŴ
	DWORD	m_playTimer;			//	play ʱ
	DWORD	m_internalTimer;		//	 interval ʱ
	
public:
	CECPolicyAction();
	
	//	ʼ
	void	Init(const S2C::cmd_object_start_play_action *pCmd);
	void	Reset();
	
	//	ȡִ״̬
	bool	IsValid()const { return m_validPolicy; }
	bool	IsInPolicy()const { return m_inPolicy; }
	bool	IsInPlay()const { return IsInPolicy() && m_inPlay; }
	bool	IsInInterval()const { return IsInPolicy() && !m_inPlay; }
	
	//	ȡЭ
	const AString &GetActionName()const { return m_actionName; }
	int			GetIntervalTime()const { return m_intervalTime; }

	//	ѯ

	bool	HasAction()const
	{
		//	Чʱ䡢ŴΪ0
		return m_actionTime > 0 && m_playTimes > 0;
	}
	bool	HasInterval()const
	{
		//	ʱЧΪ0
		return GetIntervalTime() > 0;
	}
	bool	HasNone()const
	{
		//	šʱЧ
		return !HasAction() && !HasInterval();
	}
	bool	IsNormal()const
	{
		//	šʱЧ
		return HasAction() && HasInterval();
	}
	
	//	
	void	Tick(DWORD dwDeltaTime);
};
