/*
* FILE: EC_PlayerWrapper.h
*
* DESCRIPTION: 
*
* CREATED BY: Shizhenhua, 2013/8/21
*
* HISTORY: 
*
* Copyright (c) 2011 ACE Studio, All Rights Reserved.
*/


#pragma once

#include <ABaseDef.h>
#include <A3DVector.h>
#include <vector.h>
#include <hashmap.h>

#include <set>
#include <list>


///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////

#define MAX_PLAYER_ACTION 10


///////////////////////////////////////////////////////////////////////////
//	
//	Types and Global variables
//	
///////////////////////////////////////////////////////////////////////////

class CECPlayer;
class CECHostPlayer;
class CECGameSession;


///////////////////////////////////////////////////////////////////////////
//	
//	Declare of Global functions
//	
///////////////////////////////////////////////////////////////////////////

// ԶµһЩ¼
enum
{
	AP_EVENT_CANNOTMOVE,		// ƶ
	AP_EVENT_MOVEFINISHED,		// ƶ
	AP_EVENT_TRACEOK,			// ׷ٳɹ
	AP_EVENT_STARTSKILL,		// ܿʼ
	AP_EVENT_STOPSKILL,			// ֹͣ
	AP_EVENT_STARTUSEITEM,		// ʹƷʼ
	AP_EVENT_STOPUSEITEM,		// ʹƷ
	AP_EVENT_PICKUPOK,			// ɹȡƷ
	AP_EVENT_CANNOTPICKUP,		// Ʒܼȡ
	AP_EVENT_STARTMELEE,		// ʼչ
	AP_EVENT_STOPMELEE,			// չ
	AP_EVENT_COMBOCONTINUE,		// ϼƽ
	AP_EVENT_COMBOFINISH,		// ϼֹӦһûзų
	AP_EVENT_MELEEOUTOFRANGE,	// չ
};

void AP_ActionEvent(int iEvent, int iParam = 0);

const char* AP_GetActionName(int iAction);
const char* AP_GetEventName(int iEvent);


///////////////////////////////////////////////////////////////////////////
//	
//	Class CECPlayerWrapper
//	
///////////////////////////////////////////////////////////////////////////

class CECPlayerWrapper
{
public:

	enum
	{
		ACTION_IDLE,			// 
		ACTION_MOVE,			// ƶ
		ACTION_CASTSKILL,		// 
		ACTION_USEITEM,			// ʹƷ
		ACTION_PICKUP,			// ʰ
		ACTION_COMBOSKILL,		// ϼ
		ACTION_MELEE,			// չ
	};

	struct DelayTask
	{
		int iType;
		int iParam1;
		int iParam2;

		DelayTask() : iType(ACTION_IDLE), iParam1(0), iParam2(0) {}
	};

	// ҵǰִеΪ
	// ȴΪΪɺִAI߼
	class Action
	{
	protected:
		int type;
		CECPlayerWrapper* host;

	public:
		Action(CECPlayerWrapper* pHost, int t) : host(pHost), type(t) {}

		virtual bool StartAction() { return true; }
		virtual void EndAction() {}

		// true, ˵Ϊִ
		virtual bool Tick(DWORD dwDeltaTime) { return false; }

		// Ӧ¼
		virtual void OnEvent(int iEvent, int iParam) {}

		// Ƿж
		virtual bool CanBreak() const { return true; }

		// ǷкΪ
		bool HaveNextAction() const { return host->m_Actions.size() > 0; }

		// Ϊ
		int GetType() const { return type; }
	};

	typedef std::list<Action*> ActionQueue;

	friend class Action;
	friend class CECAutoPolicy;

public:
	CECPlayerWrapper(CECHostPlayer* pHost);
	virtual ~CECPlayerWrapper();

	// ߼
	void Tick(DWORD dwDeltaTime);

	// ֹͣ
	void StopPolicy();

	// Ϊ
	void ClearAction();
	// ӦΪ¼
	void OnActionEvent(int iEvent, int iParam);

	// ΪǷѾ
	bool HaveAction() const;
	// һΪ
	bool AddIdleAction(int iTime);

	// ȡƷ
	int GetItemIndex(int iPack, int tid);
	// ȡָƷĸ
	int GetItemCount(int iPack, int tid);

	// ȡǰλ
	A3DVECTOR3 GetPos() const;
	// ƶָλ
	void MoveTo(float x, float z);
	// ȡǰΪ
	void CancelAction();
	// ȡҳʼλ
	A3DVECTOR3 GetOrigPos() const { return m_vOrigPos; }

	// ѰһĿ
	bool SearchTarget(int& id, int& tid);

	// ȡǰѡеĿ
	int GetSelectedTarget() const;
	// ѡȡָĿ
	void SelectTarget(int iTarget);
	// ȡѡ
	void Unselect();
	// жѡȡܷ񱻹
	bool NpcCanAttack(int nid);
	// չ
	bool NormalAttack();
	// ʩϼ
	bool CastComboSkill(int group_id, bool bIgnoreAtkLoop, bool bQueue = false);
	// ʩż
	bool CastSkill(int skill_id, bool bQueue = false);
	// ʹƷ
	void UseItem(int iSlot);

	// жƷǷԼȡ
	bool MatterCanPickup(int mid, int tid);
	// ȡƷ
	void Pickup(int mid);

	// жǷ뿪Ұ
	bool IsPlayerInSlice(int idPlayer);
	// ȡ־
	int GetWeaponEndurance() const;
	// Ƿ
	bool IsDead() const;
	// Ƿʩ
	bool IsRevivedByOther() const;
	// ˸
	void AcceptRevive();
	// ʹøḴ
	bool ReviveByItem();
	// سǸ
	void ReviveInTown();
	// ǿй
	void SetForceAttack(bool bFlag) { m_bForceAttack = bFlag; }
	// Ƿڰȫ
	bool IsInSanctuary() const;
	// ڹԼĹ
	bool IsMonsterAttackMe() const;

	// ȡλ
	A3DVECTOR3 GetObjectPos(int object_id) const;

	// ҵĳʼλ
	void SetOrigPos(const A3DVECTOR3& vPos) { m_vOrigPos = vPos; }

	// ָĿЧ
	void SetInvalidObject(int object_id);

	///////////////////////////////////////////////////////////////////////////

	// ӦNPCMatterʧ
	void OnObjectDisappear(int object_id);
	// Ӧ﹥Լ
	void OnMonsterAttackMe(int monster_id);

	void AddAttackError();
	void ResetAttackError() { m_iAttackErrCnt = 0; }
	void ResetPickupError() { m_iPickupErrCnt = 0; }
	int GetAttackError() const { return m_iAttackErrCnt; }
	int GetPickupError() const { return m_iPickupErrCnt; }

	void OnStopPolicy();

	CECHostPlayer* GetHostPlayer() { return m_pHost; }
	CECGameSession* GetGameSession() { return m_pSession; }

protected:
	CECHostPlayer* m_pHost;
	CECGameSession* m_pSession;
	ActionQueue m_Actions;
	Action* m_pCurAction;
	A3DVECTOR3 m_vOrigPos;				// ҽλ

	bool m_bForceAttack;				// ǿйı
	int m_iAttackErrCnt;
	int m_iPickupErrCnt;
	abase::hash_map<int, int> m_InvalidObj;	// ɹĹ֡򲻿ɼȡƷ
	std::set<int> m_MonsterAttackMe;	// ҵĹ

	DelayTask m_DelayTask;				// ӳڴܵʩ

private:
	bool AddAction(Action* pAction);
	bool StartAction();
	bool EndCurAction();
	bool AddOneAction(int iActionType, int iParam = 0);

	// ӳ
	void DoDelayTask(int iType, int iParam1 = 0, int iParam2 = 0);
	void ProcessDelayTask();
};

///////////////////////////////////////////////////////////////////////////
//	
//	Inline functions
//	
///////////////////////////////////////////////////////////////////////////
