// File		: EC_LoginSwitch.h
// Creator	: Xu Wenbin
// Date		: 2012/5/17

#pragma once

#include <AAssist.h>

class CECLoginSwitch
{
	CECLoginSwitch();

	CECLoginSwitch(const CECLoginSwitch &);
	CECLoginSwitch & operator=(const CECLoginSwitch&);

public:
	static CECLoginSwitch & Instance();

	enum LoginType {
		LT_DEFAULT,			//	ͨ¼ʽ CDlgLogin ȡ˺룩
		LT_PWD,				//	password ¼жȡ˺špwd
		LT_TOKEN,			//	token ¼лȡ˺štoken
		LT_TOKEN2,			//	token2 ¼лȡ˺štoken2
		LT_SSO,				//	sso ¼л˺ҳȡ˺špwdagent
		LT_CROSSSERVER,		//	ת¼
		LT_ARC,				//	arcƽ̨Զ½
	};

	//	õ¼
	void CheckAutoLogin();
	void DefaultLogin();
	void PasswordLogin(const ACString &user, const ACString &pwd);
	void TokenLogin(const ACString &user, const ACString &token);
	void Token2Login(const ACString &user, const ACString &token2);
	void SSOLogin(const ACString &user, const ACString &pwd, const ACString &agent);
	void CrossServerLogin(const ACString &user);
#ifdef ARC
	void ArcAsiaLogin();

	void ArcAsiaGetToken();
#endif
	void ParseCommandLine();

	//	ȡ¼
	ACString GetUser()const;
	ACString GetPassword()const;
	ACString GetToken()const;
	ACString GetAgent()const;

	LoginType	GetLoginType()const{ return m_loginType; }
	bool		GetKickoutUser()const;

	bool IsUsePassword()const{ return GetLoginType() == LT_PWD; }
	bool IsUseToken()const { return GetLoginType() == LT_TOKEN || GetLoginType() == LT_TOKEN2; }
	bool IsUseSSO()const { return GetLoginType() == LT_SSO; }
	bool IsUseCrossServer()const { return GetLoginType() == LT_CROSSSERVER; }
	bool IsUseArc() const { return GetLoginType() == LT_ARC; }
	bool CanAutoLogin()const { return GetLoginType() != LT_DEFAULT; }
	char GetTokenType()const;

	//	ʹò¼
	bool Login();
	bool Validate()const;

private:
	void UpdateReconnectPolicy();

private:

	LoginType	m_loginType;
	bool		m_bKickoutUser;

	ACString	m_strUser;
	ACString	m_strPassword;
	ACString	m_strToken;
	ACString	m_strAgent;
};