// Filename	: EC_HostSkillModel.h
// Creator	: zhangyitian
// Date		: 2014/06/20

#ifndef _ELEMENTCLIENT_EC_HOSTSKILLMODEL_H_
#define _ELEMENTCLIENT_EC_HOSTSKILLMODEL_H_

#include "EC_Observer.h"
#include "vector.h"
#include "hashmap.h"
#include "AAssist.h"
#include "gnoctets.h"

#include <vector>
#include <set>

namespace GNET {
	class ElementSkill;
}

namespace S2C {
	struct cmd_scene_service_npc_list;
}


class CECSkill;
struct NPC_ESSENCE;

/* ״ı֪࣬ͨ仯 */
class CECSkillPanelChange : public CECObservableChange {
public:
	enum enumChangeMask {
		CHANGE_SKILL_LEVEL_UP,		// 
		CHANGE_SKILL_OVERRIDDEN,	// ܱ
		CHANGE_SKILL_NPC,			// лṩܷNPC仯
	};
	CECSkillPanelChange(enumChangeMask mask, int id, int level) {
		m_changeMask = mask;
		m_skillID = id;
		m_skillLevel = level;
	}
public:
	enumChangeMask m_changeMask;
	int m_skillID;
	int m_skillLevel;
};


/* Model */
class CECHostSkillModel : public CECObservable<CECHostSkillModel> {
public:
	enum enumSkillFitLevelState {
		SKILL_FIT_LEVEL,		// ȼ桢
		SKILL_NOT_FIT_LEVEL,	// ܲȼ桢
	};
	enum enumSkillLearnedState {
		SKILL_NOT_LEARNED,	// δѧϰ
		SKILL_LEARNED,		// ѧϰ
		SKILL_FULL,			// 
		SKILL_OVERRIDDEN,	// ѱ
	};
	enum enumEvilGod {
		SKILL_BASE,		// ͨ
		SKILL_EVIL,		// ɼ
		SKILL_GOD,		// ħ
	};

public:
	ACString GetSkillName(int skillID);							// ȡ
	AString GetSkillIcon(int skillID);							// ȡͼ
	ACString GetSkillDescription(int skillID, int level);		// ȡ

	int GetSkillSp(int skillID, int level);			// ȡsp
	int GetSkillMoney(int skillID, int level);		// ȡĽǮ
	int GetSkillCurrentLevel(int skillID);			// ȡܵǰȼ
	int GetSkillMaxLevel(int skillID);				// ȡȼ
	bool IsPassiveSkill(int skillID);				// Ƿ񱻶
	enumEvilGod GetSkillEvilGod(int skillID);		// ɼܡħܻͨ

	int GetRequiredBook(int skillID, int level);	// ѧϰҪƷ

	typedef std::vector<std::pair<unsigned int, int> > JuniorSkillVector;
	std::vector<std::pair<unsigned int, int> > GetRequiredSkill(int skillID, int level);	// ѧϰҪǰü

	enumSkillFitLevelState GetSkillFitLevel(int skillID);		// ѧϰüǷȼ澳
	enumSkillFitLevelState GetSkillFitLevel(int skillID, int maxLevel, int rank, int realmLevel);
	bool CheckHasNewSkillCanLearn(int oldMaxLevel, int oldRank, int oldRealmLevel);
	enumSkillLearnedState GetSkillLearnedState(int skillID);	// ǰѧϰ״̬

	void Initialize();			// ȡǰְҵмܣ
	
	void Release();

	int GetTotalSkillCount();	// ȡǰְҵмܵĸ

	bool CheckPreSkillLevel(int skillID, int level);	// ǰüܺͼ
	bool CheckPreItem(int itemID);				// ǰƷ

	AString GetPreItemIcon(int itemID);			// ȡǰƷͼ
	ACString GetPreItemDescription(int itemID);	// ȡǰƷ

	int CheckLearnCondition(int skillID);		// 鼼Ƿѧ

	int GetCurrentRank();						// ȡﵱǰȼ

	

	static CECHostSkillModel& Instance();
	
	~CECHostSkillModel();

	const abase::hash_map<int, abase::vector<int> >& GetAllRankProfSkills() { return m_allRankProfSkills;}

	void OnLearnSkill(int skillID, int skillLevel);		// յѧϰ¼ܺ󱻵á֪ͨи


	// ܸ
	int GetRootSkill(int skillID, bool isEvil);						// һܵĿɵռܡޣԼ
																	// Ϊǰ״̬ǷħǷͨħ
	int GetTreeHeight(int rootSkillID);								// ȡһĸ߶
	std::vector<std::pair<unsigned int, int> > GetJunior(int skillID);			// ȡǰü

	// NPC
	bool IsSkillServedByNPC(int skillID);		// ǰ£Ƿѧϰĳܵķ
	void RecvNPCServiceList(const GNET::Octets& Data);	// յǰѧϰNPCб
	void ProcessServiceList();
	bool IsSkillLearnNPC(int nid);				// NPC IDǷصѧϰNPCյNPC Greetingʱ
	bool IsSkillLearnNPCExsit();				// ǰǷѧϰܵNPC
	void SendHelloToSkillLearnNPC();			// һSEVNPC_HELLOЭǰNPCѧϰܷ

private:
	abase::hash_map<int, abase::vector<int> > m_allRankProfSkills;	// ÿ漶Ӧĸְҵмܵб
	abase::hash_map<int, GNET::ElementSkill*> m_allProfSkills;		// ְҵмܣڲѯ
	
	// ܺռܵӳ䣬ռΪɡħͨΪ
	typedef abase::hash_map<int, int> SkillRootMap;
	abase::hash_map<int, int> m_baseRootMap;
	abase::hash_map<int, int> m_godRootMap;
	abase::hash_map<int, int> m_evilRootMap;

	abase::hash_map<int, int> m_treeHeightMap;	// ÿܶӦĸǼĸ߶ӳ

	std::set<int> m_curServiceSkills;	// ǰNPCṩмܡͬѧļܿܲͬ
	int m_skillLearnNPCNID;				// ǰNPC
	std::set<int> m_allProfNPCs;		// еĵǰְҵڼܵNPC

	bool m_bInitialized;				// Ƿʼ

	// յcmd_scene_service_npc_listڳʼǰʽ䱣棬ʼʱٽд
	GNET::Octets m_npcListData;

private:
	CECHostSkillModel();

	// һܵгܣ㼼߶ȡtpyeΪ012ֱڵΪͨɡħ
	int GetSkillTreeHeight(int rootSkillID);	
	void InitializeRootOfSkillTree(int rootSkillID);

	// ʼǰְҵм
	void InitAllSkillsOfCurProf();

	// ҵǰְҵ޾ƵĽڼNPC
	void FindAllNPCsOfCurProf();

	// ʼӳ
	void InitSkillTreeRootMap(const std::set<int>& rootSkills);

	// ʼ߶ӳ
	void InitSkillTreeHeightMap(const std::set<int>& rootSkills);

	// õΪļܼ
	std::set<int> GetRootSkillSet();

	SkillRootMap& GetSkillRootMap(int rootSkillID);
	

	// 
	CECHostSkillModel(const CECHostSkillModel &);
	CECHostSkillModel & operator = (const CECHostSkillModel &);

	void SetCurServiceSkills(int tid);	// õǰеĿѧܡΪnpctid
};

#endif