// Filename	: DlgWedding.h
// Creator	: Xu Wenbin
// Date		: 2010/07/06

#include "AFI.h"
#include "DlgWedding.h"
#include "DlgActivity.h"
#include "EC_ShortcutMgr.h"
#include "EC_GameUIMan.h"
#include "EC_Game.h"
#include "EC_GameRun.h"
#include "EC_Resource.h"
#include "EC_IvtrConsume.h"
#include "EC_GameSession.h"
#include "EC_HostPlayer.h"
#include "EC_Inventory.h"
#include "EC_Team.h"
#include "EC_World.h"
#include "EC_ManPlayer.h"
#include "EC_Time.h"
#include "elementdataman.h"
#include "AUIRadioButton.h"
#include "CSplit.h"
#include <A2DSprite.h>
#include <time.h>

#define new A_DEBUG_NEW

AUI_BEGIN_COMMAND_MAP(CDlgWedding, CDlgBase)
AUI_ON_COMMAND("prevmonth",	OnCommand_PrevMonth)
AUI_ON_COMMAND("nextmonth",	OnCommand_NextMonth)
AUI_ON_COMMAND("Btn_Book",	OnCommand_Book)
AUI_ON_COMMAND("Btn_CancelBook",	OnCommand_CancelBook)
AUI_ON_COMMAND("IDCANCEL",	OnCommand_Cancel)
AUI_ON_COMMAND("Rdo_*",		OnCommand_Rdo)
AUI_END_COMMAND_MAP()

AUI_BEGIN_EVENT_MAP(CDlgWedding, CDlgBase)
AUI_ON_EVENT("Img_*", WM_LBUTTONDOWN, OnEventLButtonDown_Img)
AUI_ON_EVENT("Img_Special", WM_RBUTTONUP, OnEventRButtonUP_Img)
AUI_ON_EVENT("Txt_Sun*", WM_LBUTTONDOWN, OnEventLButtonDown_Txt)
AUI_ON_EVENT("Txt_Mon*", WM_LBUTTONDOWN, OnEventLButtonDown_Txt)
AUI_ON_EVENT("Txt_Tue*", WM_LBUTTONDOWN, OnEventLButtonDown_Txt)
AUI_ON_EVENT("Txt_Wed*", WM_LBUTTONDOWN, OnEventLButtonDown_Txt)
AUI_ON_EVENT("Txt_Thu*", WM_LBUTTONDOWN, OnEventLButtonDown_Txt)
AUI_ON_EVENT("Txt_Fri*", WM_LBUTTONDOWN, OnEventLButtonDown_Txt)
AUI_ON_EVENT("Txt_Sat*", WM_LBUTTONDOWN, OnEventLButtonDown_Txt)
AUI_ON_EVENT("Txt_List1", WM_LBUTTONDOWN, OnEventLButtonDown_List1)
AUI_END_EVENT_MAP()

//------------------------------------------------------------------------
// Right-Click Shortcut for CDlgWedding
//------------------------------------------------------------------------
typedef CECShortcutMgr::SimpleClickShortcut<CDlgWedding> WeddingClickShortcut;
//------------------------------------------------------------------------

CDlgWedding::CDlgWedding()
{
	::ZeroMemory(m_pImg_Week, sizeof(m_pImg_Week));
	::ZeroMemory(m_pLab_Week, sizeof(m_pLab_Week));
	m_pTxt_List1 = NULL;
	m_pTxt_Title = NULL;
	m_pImg_Special = NULL;
	m_pBtn_PrevMonth = NULL;
	m_pBtn_NextMonth = NULL;
	m_pBtn_Book = NULL;
	m_pBtn_CancelBook = NULL;
	m_curYear = m_curMonth = m_curDay = 0;
	m_selYear = m_selMonth = m_selDay = 0;
	m_selScene = -1;
	m_iSlot = -1;
	m_pSprite_Icon1 = NULL;
	m_pSprite_Icon2 = NULL;
	m_bSpriteInited = false;
}

bool CDlgWedding::Release()
{
	A3DRELEASE(m_pSprite_Icon1);
	A3DRELEASE(m_pSprite_Icon2);
	m_bSpriteInited = false;
	return CDlgBase::Release();
}

bool CDlgWedding::OnInitDialog()
{
	GetGameUIMan()->GetShortcutMgr()->RegisterShortCut(new WeddingClickShortcut(this));

	DDX_Control("Txt_title", m_pTxt_Title);
	DDX_Control("Txt_List1", m_pTxt_List1);
	DDX_Control("Img_Special", m_pImg_Special);
	DDX_Control("Btn_PrevMonth", m_pBtn_PrevMonth);
	DDX_Control("Btn_NextMonth", m_pBtn_NextMonth);
	DDX_Control("Btn_Book", m_pBtn_Book);
	DDX_Control("Btn_CancelBook", m_pBtn_CancelBook);

	m_pTxt_Title->SetText(_AL(""));

	AString imgFormat[7] = {"Img_Sunday%d",
		"Img_Monday%d",
		"Img_Tuesday%d",
		"Img_Wednesday%d",
		"Img_Thursday%d",
		"Img_Friday%d",
		"Img_Saturday%d"};

	AString labFormat[7] = {"Txt_Sunday%d",
		"Txt_Monday%d",
		"Txt_Tuesday%d",
		"Txt_Wednesday%d",
		"Txt_Thursday%d",
		"Txt_Friday%d",
		"Txt_Saturday%d"};

	AString strName;
	PAUIIMAGEPICTURE pImage(NULL);
	PAUILABEL pLabel(NULL);
	for (int i = 0; i < 6; ++ i)
	{
		for (int j = 0; j < 7; ++ j)
		{
			strName.Format(imgFormat[j], i);
			pImage = static_cast<PAUIIMAGEPICTURE>(GetDlgItem(strName));
			m_pImg_Week[i][j] = pImage;
			
			strName.Format(labFormat[j], i);
			pLabel = static_cast<PAUILABEL>(GetDlgItem(strName));
			pLabel->SetFontAndColor(_AL("ϸһ"), 12, 0xFFFFFFFF, 0, 1, true);
			m_pLab_Week[i][j] = pLabel;
		}
	}
	
	elementdataman* pDB = GetGame()->GetElementDataMan();
	DATA_TYPE DataType;
	WEDDING_CONFIG *pWeddingConfig = (WEDDING_CONFIG*)pDB->get_data_ptr(CECIvtrWeddingInviteCard::WEDDING_CONFIG_ID, ID_SPACE_CONFIG, DataType);
	if (DataType!=DT_WEDDING_CONFIG)
		pWeddingConfig = NULL;
	int nMaxScene = 0;
	if (pWeddingConfig)
	{
		nMaxScene = sizeof(pWeddingConfig->wedding_scene)/sizeof(pWeddingConfig->wedding_scene[0]);
	}

	// 鳡ؼ
	PAUIOBJECT pRdo(NULL), pTxt(NULL);
	int k(0);
	while (true)
	{
		strName.Format("Rdo_%02d", ++k);
		pRdo = GetDlgItem(strName);
		if (!pRdo)
		{
			// ûиĿؼ
			break;
		}

		strName.Format("Txt_%02d", k);
		pTxt = GetDlgItem(strName);
		if (pWeddingConfig && k<=nMaxScene &&
			pWeddingConfig->wedding_scene[k-1].name[0] &&
			pTxt != NULL)
		{
			// ıЧʱʾ
			pTxt->SetText(pWeddingConfig->wedding_scene[k-1].name);
		}
		else
		{
			// ıЧʱ
			pRdo->Show(false);
			if (pTxt)
				pTxt->Show(false);
		}
	}

	return true;
}

void CDlgWedding::OnShowDialog()
{
	//	ãԱ¿ʼ
	Reset();

	//	ӷѯԤб
	GetWeddingBookListFromServer();
}

void CDlgWedding::OnTick()
{
	// ȡϵͳǰʱ䲢ʾ
	char hour, minute, second;
	GetCurServerTime(m_curYear, m_curMonth, m_curDay, hour, minute, second);

	ACString strText;
	strText.Format(GetStringFromTable(8010), m_curYear, m_curMonth, m_curDay, hour, minute);
	m_pTxt_Title->SetText(strText);

	//	беʾ
	UpdatePlayerNames();
}

void CDlgWedding::OnMonthSelectChange()
{
	// µǰ·ݵʾ
	PAUIOBJECT pTxt_Month = GetDlgItem("Txt_Month");
	if (m_selMonth > 0)
	{
		ACString strText;
		strText.Format(_AL("%d"), m_selMonth);
		pTxt_Month->SetText(strText);
	}
	else
	{
		pTxt_Month->SetText(_AL(""));
	}
	m_pBtn_PrevMonth->Enable(CanGoPrevMonth());
	m_pBtn_NextMonth->Enable(CanGoNextMonth());

	// ʾ
	UpdateCalendar();

	// ѡµĵһЧڣûЧڣ
	m_selDay = GetFirstSelectDay();
	OnDaySelectChange();
}

void CDlgWedding::UpdateCalendar()
{
	// µǰѡ·ݵʾ

	// 㵱ǰ·ݵͼƬеֹΧΧɷʼ
	int start(-1), end(-1);
	if (m_selMonth != 0)
	{
		// ǰѡ·Ѿʼ

		// start 0 Ӧ Sunday
		start = CECTime::GetWeek(m_selYear, m_selMonth, 1);
		start = (start + 1)%7;

		int count = CECTime::GetMonthDayCount(m_selYear, m_selMonth);
		end = start+count;
	}

	// ʾΧδʼʱʾգ
	ACString strDay;
	int p(0);
	for (int row = 0; row < 6; ++ row)
	{
		for (int col = 0; col < 7; ++ col, ++ p)
		{
			PAUIIMAGEPICTURE pImage = m_pImg_Week[row][col];
			PAUILABEL pLabel = m_pLab_Week[row][col];

			if (p<start || p>=end)
			{
				pImage->SetCover(NULL, -1);
				pImage->SetData(0);
				pLabel->SetText(_AL(""));
			}
			else
			{
				int day = p-start+1;
				strDay.Format(_AL("%d"), day);
				pLabel->SetText(strDay);
				pLabel->SetData(day);

				pImage->SetData(day);
				SetIcon(pImage, HaveSessionDay(m_selYear, m_selMonth, day));
			}
		}
	}
}

void CDlgWedding::SetIcon(PAUIIMAGEPICTURE pImage, bool bWithSessionList)
{
	if (!m_bSpriteInited)
	{
		m_pSprite_Icon1 = LoadSprite("window\\a.dds");
		m_pSprite_Icon2 = LoadSprite("window\\b.dds");
		m_bSpriteInited = true;
	}
	if (pImage)
	{
		A2DSprite * &pSprite = bWithSessionList ? m_pSprite_Icon1 : m_pSprite_Icon2;
		if (pSprite)
			pImage->SetCover(pSprite, 0);
		else
			pImage->SetCover(NULL, -1);
	}
}

A2DSprite * CDlgWedding::LoadSprite(AString strFile)
{
	A2DSprite *pSprite = NULL;
	if (!strFile.IsEmpty())
	{
		pSprite = new A2DSprite;
		if (!pSprite->Init(GetGame()->GetA3DDevice(), strFile, 0))
			A3DRELEASE(pSprite);
	}
	return pSprite;
}

void CDlgWedding::UpdateCalendarColor()
{
	//	ʾѡӡԤ
	//
	for (int row = 0; row < 6; ++ row)
	{
		for (int col = 0; col < 7; ++ col)
		{
			PAUIIMAGEPICTURE p = m_pImg_Week[row][col];
			int nDay = p->GetData();
			if(nDay == m_selDay)
			{
				//	ѡڣɫʾ
				p->SetColor(A3DCOLORRGB(255, 0, 0));
			}
			else
			{
				//	
				p->SetColor(A3DCOLORRGB(255, 255, 255));
			}
		}
	}
}

void CDlgWedding::OnDaySelectChange()
{
	//	±ѡʱͼ״̬
	UpdateCalendarColor();

	//	ѡȡǰһ
	m_selScene = GetFirstScene();
	OnWeddingSceneSelectChange();
}

void CDlgWedding::OnWeddingSceneSelectChange()
{
	//	³ѡʾ
	CheckRadioButton(0, m_selScene>=0 ? m_selScene : -1);

	//	ճб
	m_pTxt_List1->ResetContent();

	//	ѯб
	RebuildSessionList();

	// ѡȡһΪĬ
	if (m_pTxt_List1->GetCount() > 0)
		m_pTxt_List1->SetCurSel(0);
	OnWeddingSessionSelectChange();
}

void CDlgWedding::OnWeddingSessionSelectChange()
{
	//	°ť
	m_pBtn_Book->Enable(CanBook());
	m_pBtn_CancelBook->Enable(CanCancelBook());
}

void CDlgWedding::OnEventLButtonDown_Img(WPARAM wParam, LPARAM lParam, AUIObject *pObj)
{
	PAUIIMAGEPICTURE pImage = dynamic_cast<PAUIIMAGEPICTURE>(pObj);
	if (pImage)
	{
		if (stricmp(pImage->GetName(), "Img_Special"))
		{
			//	ƷĴ
			return;
		}

		//	Ĵ
		int nDay = pImage->GetData();
		if (nDay > 0 && m_selDay != nDay && CanShowDay(m_selYear, m_selMonth, nDay))
		{
			m_selDay = nDay;
			OnDaySelectChange();
		}
	}	
}

void CDlgWedding::OnEventRButtonUP_Img(WPARAM wParam, LPARAM lParam, AUIObject *pObj)
{
	//	Ʒ
	SetItem(-1);
}

void CDlgWedding::OnEventLButtonDown_Txt(WPARAM wParam, LPARAM lParam, AUIObject *pObj)
{
	PAUILABEL pLabel = static_cast<PAUILABEL>(pObj);
	if (pLabel)
	{
		int nDay = pLabel->GetData();
		if (nDay > 0 && m_selDay != nDay && CanShowDay(m_selYear, m_selMonth, nDay))
		{
			m_selDay = nDay;
			OnDaySelectChange();
		}
	}
}

void CDlgWedding::OnEventLButtonDown_List1(WPARAM wParam, LPARAM lParam, AUIObject *pObj)
{
	OnWeddingSessionSelectChange();
}

void CDlgWedding::OnCommand_PrevMonth(const char *szCommand)
{
	if (!CanGoPrevMonth())
		return;

	int year(m_selYear), month(m_selMonth);
	GetPrevMonth(year, month, m_selYear, m_selMonth);

	if (year == m_selYear && month == m_selMonth)
		return;

	OnMonthSelectChange();
}

void CDlgWedding::OnCommand_NextMonth(const char *szCommand)
{
	if (!CanGoNextMonth())
		return;

	int year(m_selYear), month(m_selMonth);
	GetNextMonth(year, month, m_selYear, m_selMonth);

	if (year == m_selYear && month == m_selMonth)
		return;

	OnMonthSelectChange();
}

void CDlgWedding::OnCommand_Rdo(const char *szCommand)
{
	//	л
	if (szCommand && szCommand[0] && strstr(szCommand, "Rdo_"))
	{
		int nSel = atoi(szCommand + strlen("Rdo_"));
		if (nSel >= 1)
		{
			m_selScene = nSel-1;
			OnWeddingSceneSelectChange();
		}
	}
}

void CDlgWedding::OnCommand_Book(const char *szCommand)
{
	if (!CanBook())
		return;

	//	ԤЭ
	int nSession = GetSelectedSession();
	const wedding_book &temp = m_bookList[nSession];
	GetGameSession()->c2s_CmdNPCSevWeddingBook(1, temp.start_time, temp.end_time, temp.scene, m_iSlot);

	//	ԤԼƷ
	SetItem(-1);
}

void CDlgWedding::OnCommand_CancelBook(const char *szCommand)
{
	if (!CanCancelBook())
		return;

	//	ȷ϶Ի	
	PAUIDIALOG pMsgBox;
	GetGameUIMan()->MessageBox("Game_CancelBook", GetStringFromTable(8775),
		MB_YESNO, A3DCOLORRGBA(255, 255, 255, 160), &pMsgBox);
}

void CDlgWedding::CancelBook(bool bConfirm)
{
	if (bConfirm)
	{
		//	ȷȡ
		
		if (!CanCancelBook())
			return;
		
		//	ȡԤЭ
		int nSession = GetSelectedSession();
		const wedding_book &temp = m_bookList[nSession];
		GetGameSession()->c2s_CmdNPCSevWeddingBook(2, temp.start_time, temp.end_time, temp.scene, -1);
	}
}

void CDlgWedding::OnCommand_Cancel(const char *szCommand)
{
	GetGameUIMan()->EndNPCService();
	SetItem(-1);
	Show(false);
}

int CDlgWedding::GetFirstSelectDay()
{
	//	յǰʱ䣬㵱ǰѡ·һѡе
	//
	int nFirst(-1);

	if (m_curMonth > 0 && m_selMonth > 0)
	{
		int count = CECTime::GetMonthDayCount(m_selYear, m_selMonth);

		if (m_selYear == m_curYear && m_selMonth == m_curMonth)
		{
			//	ǰ·ݣӵǰտʼѯ
			for (int nDay = m_curDay; nDay <= count; ++ nDay)
			{
				if (CanShowDay(m_selYear, m_selMonth, nDay))
				{
					nFirst = nDay;
					break;
				}
			}
			if (nFirst <= 0)
			{
				//	ûҵ³ʼ
				for (int nDay = 1; nDay<m_curDay; ++ nDay)
				{
					if (CanShowDay(m_selYear, m_selMonth, nDay))
					{
						nFirst = nDay;
						break;
					}
				}
			}
		}
		else
		{
			//	·ݣӦǺ·ݣ³ʼѯ
			for (int nDay = 1; nDay <= count; ++ nDay)
			{
				if (CanShowDay(m_selYear, m_selMonth, nDay))
				{
					nFirst = nDay;
					break;
				}
			}
		}
	}

	return nFirst;
}

int CDlgWedding::GetFirstScene()
{
	//	ñ˳򼰿ؼҵһ

	int nFirst(-1);
	
	AString strName;
	PAUIOBJECT pRdo(NULL);
	int k(0);
	while (true)
	{
		strName.Format("Rdo_%02d", ++k);
		pRdo = GetDlgItem(strName);
		if (!pRdo)
		{
			// ûиĿؼ
			break;
		}
		PAUIRADIOBUTTON pRadio = dynamic_cast<PAUIRADIOBUTTON>(pRdo);
		if (pRadio && pRadio->IsShow())
		{
			nFirst = k-1;
			break;
		}
	}

	return nFirst;
}

bool CDlgWedding::CanShowMonth(int year, int month)
{
	//	յǰڣжܷʾ
	//	ֻҪǰĳʾҪʾ
	//
	bool bShow(false);

	if (year > 0 && month > 0)
	{
		int count = CECTime::GetMonthDayCount(year, month);
		for (int nDay = 1; nDay <= count; ++ nDay)
		{
			if (CanShowDay(year, month, nDay))
			{
				bShow = true;
				break;
			}
		}
	}

	return bShow;
}

bool CDlgWedding::CanShowDay(int year, int month, int day)
{
	//	οǰڣǷʾ

	bool bShow(false);

	while (true)
	{
		//	鴫Ƿȷ
		if (year <= 0 || month <= 0 || month >= 13 || day <= 0)
			break;		
		int count = CECTime::GetMonthDayCount(year, month);
		if (day > count)
			break;

		//	鵱ǰԤб
		//
		int temp_year(0), temp_month(0), temp_day(0);
		for (size_t i(0); i < m_bookList.size(); ++ i)
		{
			const wedding_book & cur = m_bookList[i];
			GetServerLocalTime(cur.start_time, temp_year, temp_month, temp_day);
			if (temp_year == year && temp_month == month)
			{
				//	·ĳ캬Ԥбտʾ
				bShow = true;
				break;
			}
		}
		break;
	}

	return bShow;
}

bool CDlgWedding::HaveSessionDay(int year, int month, int day)
{
	//	жϵǰǷпʾԤб
	//
	
	bool bHave(false);

	while (true)
	{		
		//	鴫Ƿȷ
		if (year <= 0 || month <= 0 || month >= 13 || day <= 0)
			break;		
		int count = CECTime::GetMonthDayCount(year, month);
		if (day > count)
			break;

		//	ѯԤб
		int temp_year(0), temp_month(0), temp_day(0);
		for (size_t i(0); i < m_bookList.size(); ++ i)
		{
			const wedding_book & cur = m_bookList[i];
			GetServerLocalTime(cur.start_time, temp_year, temp_month, temp_day);
			if (temp_year == year && temp_month == month && temp_day == day)
			{
				//	Ԥб
				bHave = true;
				break;
			}
		}
		
		break;
	}

	return bHave;
}

bool CDlgWedding::IsSpecialDay(int year, int month, int day)
{
	//	жϸǷ
	bool bSpecial(false);

	while (true)
	{
		//	ȡñ
		//
		elementdataman* pDB = GetGame()->GetElementDataMan();
		DATA_TYPE DataType;
		WEDDING_CONFIG *pWeddingConfig = (WEDDING_CONFIG*)pDB->get_data_ptr(CECIvtrWeddingInviteCard::WEDDING_CONFIG_ID, ID_SPACE_CONFIG, DataType);
		if (!pWeddingConfig || DataType!=DT_WEDDING_CONFIG)
			break;

		int nMaxReserved = sizeof(pWeddingConfig->reserved_day)/sizeof(pWeddingConfig->reserved_day[0]);
		for (int i = 0; i < nMaxReserved; ++ i)
		{
			if (pWeddingConfig->reserved_day[i].year <= 0 ||
				pWeddingConfig->reserved_day[i].month <= 0 ||
				pWeddingConfig->reserved_day[i].day <= 0 )
			{
				//	Ч
				continue;
			}
			if (year != pWeddingConfig->reserved_day[i].year ||
				month != pWeddingConfig->reserved_day[i].month ||
				day != pWeddingConfig->reserved_day[i].day)
			{
				//	Ǵ
				continue;
			}

			//	ҵһӦ
			bSpecial = true;
			break;
		}

		break;
	}

	return bSpecial;
}

bool CDlgWedding::HaveSpecialDayItem(int year, int month, int day)
{
	bool bHave(false);

	while (true)
	{
		if (!m_pImg_Special)
			break;

		if (!IsImageItemValid(m_iSlot))
			break;

		CECHostPlayer *pHost = GetHostPlayer();
		CECInventory *pPack = pHost->GetPack();
		CECIvtrItem *pItem = pPack->GetItem(m_iSlot);
		CECIvtrWeddingBookCard *pBookCard = dynamic_cast<CECIvtrWeddingBookCard*>(pItem);
		const IVTR_ESSENCE_WEDDING_BOOKCARD &essence = pBookCard->GetEssence();
		if (year != essence.year ||
			month != essence.month ||
			day != essence.day)
		{
			break;
		}

		bHave = true;
		break;
	}

	return bHave;
}

bool CDlgWedding::HaveInviteCard(const wedding_book &session)
{
	//	ҰǷӦרΪУ
	//
	bool bHave(false);	
	
	CECHostPlayer *pHost = GetHostPlayer();
	int id = pHost->GetCharacterID();
	CECInventory *pPack = pHost->GetPack();
	for (int i(0); i<pPack->GetSize(); ++ i)
	{
		CECIvtrItem *pItem = pPack->GetItem(i);
		if (pItem && pItem->GetClassID() == CECIvtrItem::ICID_WEDDINGINVITECARD)
		{
			CECIvtrWeddingInviteCard *pInviteCard = dynamic_cast<CECIvtrWeddingInviteCard*>(pItem);
			if (pInviteCard)
			{
				const IVTR_ESSENCE_WEDDING_INVITECARD &essence = pInviteCard->GetEssence();
				if (essence.start_time == session.start_time &&
					essence.end_time == session.end_time &&
					essence.scene == session.scene &&
					essence.groom == session.groom &&
					essence.bride == session.bride &&
					essence.invitee == id)
				{
					bHave = true;
					break;
				}
			}
		}
	}

	return bHave;
}

bool CDlgWedding::CanGoPrevMonth()
{
	bool bCan(false);

	if (m_selMonth > 0)
	{
		int year(0), month(0);
		GetPrevMonth(m_selYear, m_selMonth, year, month);
		if (CanShowMonth(year, month))
			bCan = true;
	}

	return bCan;
}

bool CDlgWedding::CanGoNextMonth()
{
	bool bCan(false);

	if (m_selMonth > 0)
	{
		int year(0), month(0);
		GetNextMonth(m_selYear, m_selMonth, year, month);
		if (CanShowMonth(year, month))
			bCan = true;
	}

	return bCan;
}

CECPlayer * CDlgWedding::GetTeamOtherPlayer()
{
	//	ҷҪĶеһ
	//

	CECPlayer *pPlayerRet = NULL;

	while (true)
	{
		CECHostPlayer *pHost = GetHostPlayer();

		CECTeam * pTeam = pHost->GetTeam();
		if (!pTeam ||
			pTeam->GetMemberNum() != 2 ||
			pTeam->GetLeaderID() != pHost->GetCharacterID())
		{
			//	2ӣ߲Ƕӳ
			break;
		}

		int iHostTeamIndex(0);
		CECTeamMember *pOtherMember = NULL;
		CECPlayer *pOtherPlayer = NULL;
		if (!pTeam->GetMemberByID(pHost->GetCharacterID(), &iHostTeamIndex) ||
			!(pOtherMember = pTeam->GetMemberByIndex(1 - iHostTeamIndex)) ||
			!(pOtherPlayer = GetGameRun()->GetWorld()->GetPlayerMan()->GetPlayer(pOtherMember->GetCharacterID())) ||
			pOtherPlayer->GetGender() == pHost->GetGender())
		{
			//	ӵĶԱ𲻷
			break;
		}

		pPlayerRet = pOtherPlayer;
		break;
	}

	return pPlayerRet;
}

bool CDlgWedding::CheckTeamCondition(bool bBook)
{
	//	 Ԥ/ȡԤ 
	//
	return GetTeamOtherPlayer() != NULL;
}

bool CDlgWedding::CanBook()
{
	//	ܷԤǰѡеڡ
	//
	bool bCan(false);

	while (true)
	{
		if (!CheckTeamCondition(true))
		{
			//	Ԥ
			break;
		}

		if (m_selMonth <= 0)
		{
			//	δʼ
			break;
		}

		if (m_selScene < 0)
		{
			//	δѡ
			break;
		}

		int nSession = GetSelectedSession();
		if (nSession < 0)
		{
			//	δѡ
			break;
		}

		if (!CanBookSession(nSession))
		{
			//	Ԥ
			break;
		}

		bCan = true;
		break;
	}
	return bCan;
}

bool CDlgWedding::CanCancelBook()
{
	//	ܷԤǰѡеڡ
	//
	bool bCan(false);

	while (true)
	{
		if (!CheckTeamCondition(false))
		{
			//	ȡԤ
			break;
		}

		if (m_selMonth <= 0)
		{
			//	δʼ
			break;
		}

		if (m_selScene < 0)
		{
			//	δѡ
			break;
		}

		int nSession = GetSelectedSession();
		if (nSession < 0)
		{
			//	δѡ
			break;
		}

		if (!CanCancelBookSession(nSession))
		{
			//	ȡԤ
			break;
		}

		bCan = true;
		break;
	}
	return bCan;
}

void CDlgWedding::GetPrevMonth(int year, int month, int &prevMonthYear, int &prevMonth)
{
	if (month == 1)
	{
		prevMonthYear = year-1;
		prevMonth = 12;
	}
	else
	{
		prevMonthYear = year;
		prevMonth = month-1;
	}
}

void CDlgWedding::GetNextMonth(int year, int month, int &nextMonthYear, int &nextMonth)
{
	if (month == 12)
	{
		nextMonthYear = year+1;
		nextMonth = 1;
	}
	else
	{
		nextMonthYear = year;
		nextMonth = month+1;
	}
}

bool CDlgWedding::IsContinuousMonth(int year1, int month1, int year2, int month2)
{
	int tempYear, tempMonth;
	GetNextMonth(year1, month1, tempYear, tempMonth);
	return (tempYear == year2) && (tempMonth == month2);
}

void CDlgWedding::SetItem(int iSlot /* = -1 */)
{
	bool bItemChanged(false);

	while (true)
	{
		CECIvtrItem *pItem = NULL;
		CECHostPlayer *pHost = GetHostPlayer();
		CECInventory *pPack = pHost->GetPack();
		if (IsImageItemValid(iSlot))
			pItem = pPack->GetItem(iSlot);
		
		//	Ϸ
		CECIvtrItem *pItemOld = NULL;
		if (IsImageItemValid(m_iSlot))
			pItemOld = pPack->GetItem(m_iSlot);

		//	жظ
		if (pItemOld != NULL &&
			pItem == pItemOld)
		{
			//	ڷǿʱִ
			break;
		}

		bItemChanged = true;
		
		//	ͼ
		m_pImg_Special->SetCover(NULL, -1);
		
		if (pItemOld)
			pItemOld->Freeze(false);
		
		//	ʾ½
		m_iSlot = iSlot;
		
		if (!pItem)
			break;
		
		pItem->Freeze(true);
		
		AString strFile;
		af_GetFileTitle(pItem->GetIconFile(), strFile);
		strFile.MakeLower();
		m_pImg_Special->SetCover(
			GetGameUIMan()->m_pA2DSpriteIcons[CECGameUIMan::ICONS_INVENTORY],
			GetGameUIMan()->m_IconMap[CECGameUIMan::ICONS_INVENTORY][strFile]);

		break;
	}

	if (bItemChanged)
	{
		//	Ʒı䣬ӰԤԼȡԤԼ
		OnWeddingSessionSelectChange();
	}
}

bool CDlgWedding::IsImageItemValid(int iSlot)
{
	bool bValid(false);
	while (true)
	{
		CECHostPlayer *pHost = GetHostPlayer();
		CECInventory *pPack = pHost->GetPack();
		if (iSlot < 0 && iSlot >= pPack->GetSize())
			break;
		
		CECIvtrItem *pItem = pPack->GetItem(iSlot);
		if (!pItem)
			break;
				
		if (pItem->GetClassID() != CECIvtrItem::ICID_WEDDINGBOOKCARD)
			break;
		
		CECIvtrWeddingBookCard *pBookCard = dynamic_cast<CECIvtrWeddingBookCard*>(pItem);
		if (!pBookCard)
			break;
		
		const IVTR_ESSENCE_WEDDING_BOOKCARD &essence = pBookCard->GetEssence();
		if (essence.year <= 0 ||
			essence.month <= 0 ||
			essence.day <= 0)
		{
			break;
		}
		
		bValid = true;
		break;
	}
	return bValid;
}

void CDlgWedding::OnWeddingBookList(void *pData)
{
	//	б
	m_bookList.clear();

	//	б
	if (pData != NULL)
	{
		wedding_book temp;
		S2C::cmd_wedding_book_list *pWeddingBookList = (S2C::cmd_wedding_book_list *)pData;
		for (int i = 0; i < pWeddingBookList->count; ++ i)
		{
			temp.start_time = pWeddingBookList->list[i].start_time;
			temp.end_time = pWeddingBookList->list[i].end_time;
			temp.groom = pWeddingBookList->list[i].groom;
			temp.bride = pWeddingBookList->list[i].bride;
			temp.scene = pWeddingBookList->list[i].scene;
			temp.status = pWeddingBookList->list[i].status;
			temp.special = pWeddingBookList->list[i].special;
			
			m_bookList.push_back(temp);
		}
	}

	//	֪ͨ
	OnBookListChange();
}

void CDlgWedding::OnBookListChange()
{
	//	ԤԼбѾ仯
	//

	//	ʾ·

	if (m_selMonth > 0 && CanShowMonth(m_selYear, m_selMonth))
	{
		//	ϴбӦ·ݻܹʾ򲻸ı·

		//	·ݷҳΪб仯		
		m_pBtn_PrevMonth->Enable(CanGoPrevMonth());
		m_pBtn_NextMonth->Enable(CanGoNextMonth());

		//	еͼܷ仯
		UpdateCalendar();

		if (CanShowDay(m_selYear, m_selMonth, m_selDay))
		{
			//	ϴʾӻܹʾ򲻸ı

			//	ѡʾΪ£
			UpdateCalendarColor();

			//	½бΪб仯
			RebuildSessionList();
			
			// ѡȡһΪĬ
			if (m_pTxt_List1->GetCount() > 0)
				m_pTxt_List1->SetCurSel(0);
			OnWeddingSessionSelectChange();

			return;
		}

		//	һʾ
		m_selDay = GetFirstSelectDay();
		OnDaySelectChange();
		return;
	}

	//	ӵǰ³ҵһʾ·
	m_selYear = m_selMonth = m_selDay = 0;
	if (CanShowMonth(m_curYear, m_curMonth))
	{
		//	ǰ·ʾ
		m_selYear = m_curYear;
		m_selMonth = m_curMonth;
	}
	else
	{
		//	бвҵһ
		if (!m_bookList.empty())
		{
			const wedding_book & cur = m_bookList[0];
			GetServerLocalTime(cur.start_time, m_selYear, m_selMonth, m_selDay);
		}
	}
	
	OnMonthSelectChange();
}

int CDlgWedding::GetSelectedSession()
{
	//	ҵǰѡԤʱ
	int nSession(-1);

	while (true)
	{
		int nSel = m_pTxt_List1->GetCurSel();
		int nCount = m_pTxt_List1->GetCount();
		if (nSel < 0 || nSel >= nCount)
		{
			//	ûѡг
			break;
		}

		int candidate = m_pTxt_List1->GetItemData(nSel);
		if (candidate < 0 || candidate >= (int)m_bookList.size())
		{
			//	ѡݲϷ
			break;
		}

		nSession = candidate;
		break;
	}

	return nSession;
}

bool CDlgWedding::CanBookSession(int nSession)
{
	//	жָǷԤ
	//
	bool bCan(false);

	while (true)
	{		
		if (nSession < 0 || nSession >= (int)m_bookList.size())
		{
			//	ѡݲϷ
			break;
		}
		
		const wedding_book & session = m_bookList[nSession];
		
		if (session.status != S2C::WBS_UNBOOKED)
		{
			//	ѾԤ
			break;
		}
		
		int curServerTime = GetGame()->GetServerGMTTime();
		if (curServerTime >= session.start_time)
		{
			//	ѾԤԼʱ
			break;
		}

		if (GetHostPlayer()->GetPack()->GetItemTotalNum(GENERAL_BOOKCARD_ID) <= 0)
		{
			//	ûͨƾ֤
			break;
		}
		
		if (session.special)
		{
			//	
			int year(0), month(0), day(0);
			GetServerLocalTime(session.start_time, year, month, day);
			if (!HaveSpecialDayItem(year, month, day))
			{
				//	ûƷ
				break;
			}
		}
		bCan = true;
		break;
	}

	return bCan;
}

bool CDlgWedding::CanCancelBookSession(int nSession)
{
	//	жָǷԤ
	//
	bool bCan(false);

	while (true)
	{		
		if (nSession < 0 || nSession >= (int)m_bookList.size())
		{
			//	ѡݲϷ
			break;
		}
		
		const wedding_book & session = m_bookList[nSession];
		
		if (session.status != S2C::WBS_BOOKED)
		{
			//	Ԥ״̬
			break;
		}

		int id = GetHostPlayer()->GetCharacterID();
		if (id != session.groom && id != session.bride)
		{
			//	֮һ
			break;
		}

		if (session.special)
		{
			if (!HaveInviteCard(session))
			{
				//	ûгԤԼƾ֤
				break;
			}
		}
		bCan = true;
		break;
	}

	return bCan;
}

void CDlgWedding::GetCurServerTime(int &year, int &month, int &day, char &hour, char &minute, char &second)
{
	//	ȡǰʱ䣨ͻ˹Ƶó
	tm t1 = GetGame()->GetServerLocalTime();
	GetYearMonthDay(t1, year, month, day);
	hour = t1.tm_hour;
	minute = t1.tm_min;
	second = t1.tm_sec;
}

tm   CDlgWedding::GetServerLocalTime(int t)
{
	//	תΪصʱ䣨ʾжϣ
	//
	int timeBias = GetGame()->GetTimeZoneBias() * 60;
	int serverLocalTime = t - timeBias;
	return *gmtime((time_t*)&serverLocalTime);
}

void CDlgWedding::GetServerLocalTime(int t, int &year, int &month, int &day)
{
	tm t1 = GetServerLocalTime(t);
	GetYearMonthDay(t1, year, month, day);
}

void CDlgWedding::GetYearMonthDay(const tm &t1, int &year, int &month, int &day)
{
	year = 1900 + t1.tm_year;
	month = 1 + t1.tm_mon;
	day = t1.tm_mday;
}

void CDlgWedding::RebuildSessionList()
{
	//	ݵǰõڡ build б
	m_pTxt_List1->ResetContent();

	if (m_selMonth > 0 && m_selScene >= 0)
	{
		//	ǰѡеʱ䡢ѳʼ

		int idHost = GetHostPlayer()->GetCharacterID();
		ACString strQuery = GetStringFromTable(8754);	//	Ʋѯ
		ACString strNone = GetStringFromTable(8756);	//	δԤʱ
		ACString strStatus[5] = {						//	Ԥ״̬
			GetStringFromTable(8757),
			GetStringFromTable(8758),
			GetStringFromTable(8759),
			GetStringFromTable(8760),
			GetStringFromTable(8761)};
		ACString strLineFormat = _AL("%s-%s\t%s\t%s");	//	Ԥбĸʽʱ Ԥ״̬ Ԥ
		ACString strLineText, strPlayerName;
		ACString strStartTime, strEndTime;
		abase::vector<int> UnknownIDs;
		for (size_t i = 0; i < m_bookList.size(); ++ i)
		{
			const wedding_book &cur = m_bookList[i];

			//	жϳ
			if (cur.scene != m_selScene)
			{
				continue;
			}

			//	ж
			int year(0), month(0), day(0);
			GetServerLocalTime(cur.start_time, year, month, day);
			if (year != m_selYear ||
				month != m_selMonth ||
				day != m_selDay)
			{
				continue;
			}

			//	һ
			strStartTime = GetSessionTimeString(cur.start_time);
			strEndTime = GetSessionTimeString(cur.end_time);
			strLineText.Format(strLineFormat, strStartTime, strEndTime,
				(cur.status>=0&&cur.status<sizeof(strStatus)/sizeof(strStatus[0]))?strStatus[cur.status]:strNone,
				(cur.groom>0 && cur.bride>0)?strQuery:strNone);
			m_pTxt_List1->AddString(strLineText);
			UpdateSessionListHint(m_pTxt_List1->GetCount()-1);

			//	ʾԼԤĳ
			if (cur.groom == idHost || cur.bride == idHost)
				m_pTxt_List1->SetItemTextColor(m_pTxt_List1->GetCount()-1, A3DCOLORRGB(255, 0, 0), 2);

			//	洢ӦбԱѯ
			m_pTxt_List1->SetItemData(m_pTxt_List1->GetCount()-1, i, 0);

			//	ͨ ID ѯԤ
			if (cur.groom > 0)
			{
				strPlayerName = GetGameRun()->GetPlayerName(cur.groom, false);
				if (strPlayerName.IsEmpty())
					UnknownIDs.push_back(cur.groom);
			}
			if (cur.bride > 0)
			{
				strPlayerName = GetGameRun()->GetPlayerName(cur.bride, false);
				if (strPlayerName.IsEmpty())
					UnknownIDs.push_back(cur.bride);
			}

			//	ԤƵĸ£Ǻ Tick 
			if (cur.groom > 0 && cur.bride > 0)
				m_pTxt_List1->SetItemDataPtr(m_pTxt_List1->GetCount()-1, (void *)1, 0);

			//	洢ڵ2
			m_pTxt_List1->SetItemData(m_pTxt_List1->GetCount()-1, cur.start_time, 1);
		}

		//	ѯ
		if (!UnknownIDs.empty())
			GetGameSession()->CacheGetPlayerBriefInfo(UnknownIDs.size(), &UnknownIDs[0], 2);

		//	ʱ򣨸ݵ2дݣ
		if (m_pTxt_List1->GetCount() > 0)
			m_pTxt_List1->SortItemsByData(AUILISTBOX_SORT_ASCENT, AUILISTBOX_SORTTYPE_INT, 1);
	}
}

void CDlgWedding::UpdateSessionListHint(int nItem)
{
	//	бݣԶɳбʾ
	//
	int nCount = m_pTxt_List1->GetCount();
	if (nItem >= 0 && nItem < nCount)
	{
		ACString strLineText = m_pTxt_List1->GetText(nItem);
		CSplit s(strLineText);
		CSPLIT_STRING_VECTOR vec = s.Split(_AL("\t"));
		ACString strHint;
		for (size_t i = 0; i < vec.size(); ++ i)
		{
			if (i>0)
				strHint += _AL("\r");
			strHint += vec[i];
		}
		m_pTxt_List1->SetItemHint(nItem, strHint);
	}
}

void CDlgWedding::UpdatePlayerNames()
{
	//	ҵƣԤб
	//
	int nSessionSize = (int)m_bookList.size();
	ACString strLineText, strName1, strName2;
	ACString strFormat = GetStringFromTable(8752);
	CSPLIT_STRING_VECTOR vec;
	for (int i(0); i < m_pTxt_List1->GetCount(); ++ i)
	{
		if (m_pTxt_List1->GetItemDataPtr(i, 0) == NULL)
			continue;

		//	ָδ0Ԥδ

		int nSession = m_pTxt_List1->GetItemData(i, 0);
		if (nSession < 0 || nSession >= nSessionSize)
		{
			//	һԴ󣬲ٲѯ
			m_pTxt_List1->SetItemDataPtr(i, NULL, 0);
			continue;
		}

		const wedding_book &cur = m_bookList[nSession];

		//	ѯ
		strName1 = GetGameRun()->GetPlayerName(cur.groom, false);
		if (strName1.IsEmpty())
			continue;

		//	ѯ
		strName2 = GetGameRun()->GetPlayerName(cur.bride, false);
		if (strName2.IsEmpty())
			continue;

		//	ƶ鵽ʾ
		strLineText = m_pTxt_List1->GetText(i);
		CSplit s(strLineText);
		vec = s.Split(_AL("\t"));
		strLineText.Format(strFormat,
			vec[0],		//	ֹʱ
			vec[1],		//	Ԥ״̬
			strName1, strName2);	//	Ԥˣ²ѯģ

		m_pTxt_List1->SetText(i, strLineText);
		UpdateSessionListHint(i);

		//	±ʶҪٲ
		m_pTxt_List1->SetItemDataPtr(i, NULL, 0);
	}
}

ACString CDlgWedding::GetSessionTimeString(int t)
{
	//	ȡʱʾʽʼʱ䡢ʱ䣩
	//	Ϊʱ
	//

	tm t1 = GetServerLocalTime(t);
	
	ACString strText;
	strText.Format(GetStringFromTable(8753),
		t1.tm_hour,
		t1.tm_min);

	return strText;
}

void CDlgWedding::OnWeddingBookSuccess(void *pData)
{
	if (pData)
	{
		S2C::cmd_wedding_book_success *pWeddingBookSuccess = (S2C::cmd_wedding_book_success *)pData;
		
		//	ʾ
		int idMsg = pWeddingBookSuccess->type == 1 ? 8755 : 8770;
		GetGameUIMan()->MessageBox("", GetStringFromTable(idMsg), MB_OK, A3DCOLORRGBA(255, 255, 255, 160));
		
		//	б
		GetWeddingBookListFromServer();
	}
}

void CDlgWedding::GetWeddingBookListFromServer()
{
	//	ӷȡǰԤб
	//	 NPC ʱ
	//
	GetGameSession()->c2s_CmdNPCSevGetContent(GP_NPCSEV_WEDDING_BOOK);
}

void CDlgWedding::Reset()
{
	//	ݣԱһͷ
	//

	//	ǰʱ OnTick и
	m_curYear = m_curMonth = m_curDay = 0;
	m_pTxt_Title->SetText(_AL(""));

	//	бΪб
	OnWeddingBookList(NULL);
}

void CDlgWedding::OnItemDragDrop(CECIvtrItem* pIvtrSrc, int iSrc, PAUIOBJECT pObjSrc, PAUIOBJECT pObjOver)
{
	// no need to check name "Img_Special", only one available drag-drop target
	this->SetItem(iSrc);
}