// Filename	: DlgTarget.h
// Creator	: Tom Zhou
// Date		: October 12, 2005

#pragma once

#include "DlgBase.h"
#include "AUIImagePicture.h"

class AUILabel;
class AUIProgress;
class A2DSprite;

class CECPlayer;
class CECNPC;

class CDlgTargetShowPlayerPolicy;

class CDlgTarget : public CDlgBase  
{
	AUI_DECLARE_EVENT_MAP();
	AUI_DECLARE_COMMAND_MAP()
	friend class CDlgHost; // Alien - adicionado

public:
	CDlgTarget();
	virtual ~CDlgTarget();

	void OnCommand_change(const char * szCommand);
	void OnCommand_size(const char * szCommand);
	void OnCommand_CANCEL(const char * szCommand);
	void OnCommand_traceplayer(const char * szCommand);
	void OnCommand_tracepet(const char * szCommand);
	void OnCommand_showhp(const char *szCommand);
	
	void OnEventMouseMove(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonDown_Size(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonUp_Size(WPARAM wParam, LPARAM lParam, AUIObject *pObj);	
	void OnEventLButtonDBlclk_Size(WPARAM wParam, LPARAM lParam, AUIObject *pObj);	
	void OnEventRButtonUp_size(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventRButtonDown_size(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventRButtonDBlclk_Size(WPARAM wParam, LPARAM lParam, AUIObject *pObj);	
	void OnEventMouseHover(WPARAM wParam, LPARAM lParam, AUIObject *pObj); // Alien - adicionado
	void RefreshTargetStat();

protected:
	bool OnInitDialog();

	void SetShowLevel(PAUIDIALOG pShow, int nShowLevel);

	void RefreshForceStatus(CDlgTargetShowPlayerPolicy *pShowPolicy);
	void RefreshAsPlayer(int idSelObj);
	void RefreshASNPC(int idSelObj);
	void RefreshTargetOfTarget(int idTarget);

	abase::vector<PAUIIMAGEPICTURE> m_vecImgState;

	static bool m_bShowFaction;
	static bool m_bShowPercent;
	static bool m_bShowMonsterHP;

	static int m_nMouseLastX;
	static int m_nMouseOffset;
	static int m_nMouseOffsetThis;
	static A2DSprite* m_pA2DSpritePetLevel;

	bool m_bAggressive;		// ǷֻԹЧ
	void SetAggressive(bool bAggressive);

	AUIOBJECT_SETPROPERTY m_aggressiveHPImg;	// ֵѪװ
	AUIOBJECT_SETPROPERTY m_unaggressiveHPImg;	// ֵѪװ

	AUIOBJECT_SETPROPERTY m_aggressiveSymbolImg;	// ֵıǩ
	AUIOBJECT_SETPROPERTY m_unaggressiveSymbolImg;	// ֵıǩ

	virtual void OnTick(); // Alien - adicionado
};

class CDlgTargetOfTarget : public CDlgBase {
	
	AUI_DECLARE_COMMAND_MAP();
	AUI_DECLARE_EVENT_MAP();
	
public:
	CDlgTargetOfTarget();
	static void ShowTargetOfTarget(int iTargetID);					// ⲿΨһ
	void OnEventLButtonDown(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonUp(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventMouseMove(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnCommand_SelectMaster(const char* szCommand);
protected:
	bool OnInitDialog();
private:
	void ShowPlayer(int id);
	void ShowNPC(CECNPC* pNPC);
	void ShowPet(CECNPC* pNPC);
	void SetTargetID(int iTargetID);
private:
	int m_iTargetID;
	int m_iMasterOfTargetID;
	
	AUIProgress* m_pPrgHP;
	AUILabel* m_pLblName;

	int m_iLButtonDownX;
	int m_iLButtonDownY;

	bool m_bClick;
};

