// Filename	: DlgShopCartSubList.h
// Creator	: Xu Wenbin
// Date		: 2014/5/20

#ifndef _ELEMENTCLIENT_DLGSHOPCARTSUBLIST_H_
#define _ELEMENTCLIENT_DLGSHOPCARTSUBLIST_H_

#include "DlgBase.h"

#include <AUISubDialog.h>

class CECShoppingCart;
class CECObservableChange;
typedef int	ItemShoppingCartID;
class CDlgShopCartSub;

class CDlgShopCartSubList : public CDlgBase
{
	AUI_DECLARE_EVENT_MAP();
	AUI_DECLARE_COMMAND_MAP()
	
public:
	CDlgShopCartSubList();
	
	void OnCommand_CANCEL(const char *szCommand);

	void OnEventMouseWheel(WPARAM wParam, LPARAM lParam, PAUIOBJECT pObj);

	void SetShopCart(CECShoppingCart *pShoppingCart);

	//	ɸԻת CECShoppingCartObserver
	virtual void OnModelChange(const CECShoppingCart *p, const CECObservableChange *q);

protected:
	virtual bool OnInitDialog();
	virtual bool Release();
	
	void ClearItems();
	void UpdateItems();
	void Append(ItemShoppingCartID itemCartID);

	CECShoppingCart * m_pShoppingCart;

	PAUISUBDIALOG	m_pSub;					//	SUBDIALOG ؼģ
	AString			m_strDialogName;		//	ӶԻ
	AString			m_strDialogFile;		//	ӶԻļ

	typedef abase::vector<PAUISUBDIALOG> SubDialogArray;
	SubDialogArray	m_subs;					//	ΰƷĿؼб
	int				m_nNextSubDialogID;		//	´ӿؼʱʹõ±

	bool			m_inRelease;			//	ǰͷ

	int				AllocSubDialogID();				//	һµӶԻIDƷ
	int				SubDialogCount()const;			//	ǰӶԻĸӦƷ
	AString			MakeSubDialogName(int index);	//	ѯ±ӶԻ
	PAUISUBDIALOG	GetSubDialog(int index);		//	ѯ±ӶԻ
	PAUISUBDIALOG	AppendSubDialog();				//	һSubDialog
	void			RemoveSubDialog(PAUISUBDIALOG pSub);
	SIZE			CurrentDialogDefaultSize();
	SIZE			SubDialogOrgSize();
	void			FitSize();						//	ʹǰԻСSUBDIALOG
	void			SubDialogResetScroll();			//	ָĬλãҪλõ

	CDlgShopCartSub * FindSubDialogFor(ItemShoppingCartID itemCartID, SubDialogArray::iterator &it);
	void			RemoveSubDialogAndAdjust(SubDialogArray::iterator it);
};

#endif	//	_ELEMENTCLIENT_DLGSHOPCARTSUBLIST_H_