// Filename	: DlgFortressInfo.h
// Creator	: Xu Wenbin
// Date		: 2010/09/29

#pragma once

#include "DlgBase.h"
#include "AUIProgress.h"
#include "AUIListbox.h"
#include "AUIImagePicture.h"

class CDlgFortressInfo : public CDlgBase
{
	friend class CDlgGuildMan; // Alien - adicionado
	AUI_DECLARE_EVENT_MAP();
	AUI_DECLARE_COMMAND_MAP()

public:
	enum {RESETTECH_ITEM = 39202};		//  ÿƼĵ

public:
	CDlgFortressInfo();
	
	void OnCommand_CANCEL(const char *szCommand);
	void OnCommand_Levelup(const char *szCommand);
	void OnCommand_Upgrade(const char *szCommand);

	void OnEvent_RButtonDown(WPARAM wParam, LPARAM lParam, AUIObject* pObj);
	void OnEvent_RButtonUp(WPARAM wParam, LPARAM lParam, AUIObject* pObj);

	void UpdateInfo();
	
protected:
	virtual bool OnInitDialog();
	virtual void OnShowDialog();

	void UpdateResetItem();
	
private:

	enum {BUILDING_MATERIAL_COUNT = 5};	//	ԴĲ
	enum {TECHNOLOGY_COUNT = 5};		//	Ƽ츳

	PAUIOBJECT		m_pBtn_Levelup;		//	ť
	PAUIOBJECT		m_pLab_GuildName;	//	
	PAUIOBJECT		m_pTxt_Level;		//	صȼ
	PAUIPROGRESS	m_pPro_Exp;			//	ؾ
	PAUIOBJECT		m_pLab_Exp;			//	ؾı
	PAUIOBJECT		m_Lab_Technology;	//	Ƽʣֵ
	PAUIOBJECT		m_pLab_Tech[TECHNOLOGY_COUNT];		//	Ƽ츳ʾ
	PAUIIMAGEPICTURE		m_pImg_Tech[TECHNOLOGY_COUNT];		//	Ƽ츳ͼƬʾ
	PAUIOBJECT		m_pLab_M[BUILDING_MATERIAL_COUNT];		//	ʣ
	PAUIIMAGEPICTURE m_pImg_Reset;		//  õ
};