// Filename	: DlgFortressBuildSubList.h
// Creator	: Xu Wenbin
// Date		: 2010/10/09

#pragma once

#include "DlgBase.h"
#include "AUISubDialog.h"
#include "EC_HostPlayer.h"

struct FACTION_BUILDING_ESSENCE;
class CDlgFortressBuildSub;

class CDlgFortressBuildSubList : public CDlgBase
{
	AUI_DECLARE_EVENT_MAP();
	AUI_DECLARE_COMMAND_MAP()
	
public:
	CDlgFortressBuildSubList();
	
	void OnCommand_CANCEL(const char *szCommand);

	void UpdateInfo();
	void ClearBuilding();
	
	void SelectBuilding(CDlgFortressBuildSub *pDlgBuilding);
	
protected:

	virtual bool OnInitDialog();
	virtual void OnShowDialog();

	void InitBuildingTemplates();
	
	typedef abase::vector<int> CandidateList;
	void AppendBuilding(const CECHostPlayer::FACTION_FORTRESS_INFO::building_data &, const CandidateList &);
	void AppendBuildingCandidate(const CandidateList &);
	CandidateList FindCandidates(unsigned int idSubType, unsigned int idExcept);
	bool IsCanBuild(int id);

	PAUISUBDIALOG AppendSubDialog();
	void FitBuildingSize();

	//	ؼб
	PAUISUBDIALOG	m_pSub_Build;			//	ʩ SUBDIALOG ؼģ

	//	б
	typedef abase::vector<const FACTION_BUILDING_ESSENCE *>	BuildingTemplate;		//	ͬһʩмģ壨ã
	typedef abase::hash_map<unsigned int, BuildingTemplate>	BuildingTemplateArray;	//	ʩб
	BuildingTemplateArray	m_templates;

	enum {BUILDING_MATERIAL_COUNT = 5};		//	ԴĲжϽ

	int		m_nSubDialog;					//	ǰеʩѽδӦ SUBDIALOG 
	AString MakeSubDialogName(int index);	//	ѯ±ʩӶԻ
	PAUISUBDIALOG GetSubDialog(int index);	//	ѯ±ʩӶԻ

	AString		m_strDialogName;			//	ӶԻ
	AString		m_strDialogFile;			//	ӶԻļ
};