// Patch.cpp: implementation of the CPatch class.
//
//////////////////////////////////////////////////////////////////////

#include "Patch.h"
#include "LEquations.h"			//Էͷ
#include "CombGenerator.h"		//ͷ
#include "ConvexPolytope.h"


#ifdef WF_DEBUG					//״̬
	#define ASSERT_IN_REMOVE_PATCH(x) assert(x)
	#define ASSERT_IN_UPDATE_ERROR(x) assert(x)
#else							//ǵ״̬쳣Ĵ
	#define ASSERT_IN_REMOVE_PATCH(x) if(!(x)) goto ExceptionOccur
	#define ASSERT_IN_UPDATE_ERROR(x) if(!(x)) goto Exit
#endif

namespace CHBasedCD
{


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPatch::CPatch(CConvexPolytope* pCP)
{
	m_pConvexPolytope=pCP;
	m_fRemovedError=-1.0f;			//ʼΪһֵ
}

CPatch::~CPatch()
{

}

void CPatch::Neighbor(CPatch *pPatch)
{
	int start,end;
	for(int i=0;i<m_arrNeighbors.GetSize();i++)
	{
		start=m_arrNeighbors[i].vid;
		end=(i==m_arrNeighbors.GetSize()-1)?m_arrNeighbors[0].vid:m_arrNeighbors[i+1].vid;
		if(pPatch->VInPatch(start) && pPatch->VInPatch(end))
		{
			m_arrNeighbors[i].pNeighborPatch=pPatch;
			// DEBUGGING
			//char buff[100];
			//sprintf(buff, "\tNeighbor: %d\n", m_arrNeighbors[i].vid);
			//OutputDebugString(&buff[0]);
			//DEBUGGING END
		}
	}

}

bool CPatch::VInPatch(int vid)
{
	for(int i=0;i<m_arrNeighbors.GetSize();i++)
	{
		if(vid==m_arrNeighbors[i].vid)
			return true;
	}

	return false;
}

//////////////////////////////////////////////////////////////////////
// ע⣺
// ɾȻѾ²Ч㣬
// Щ¶ӡƬɾƬĸµȲ
// ڼУҲûпǹ
//////////////////////////////////////////////////////////////////////
void CPatch::UpdateRemovedError()
{
	// Revised at 10-14 
	m_fRemovedError=-1.0f;			//ÿθʱȳʼΪһֵ
	
	//Ŀܽ㣬ҳоƽԶĵ
	//뼴Ϊƽɾ
	int npCount=m_arrNeighbors.GetSize();
	
	if(npCount<3) return;			//ƬС3쳣


	// Added at 10-15 afternoon
	// ֹЧ㵫˴
	char* NPValid= new char[npCount];		//¼ÿһƬǷЧǷ񾭹һЧ㣡
	memset(NPValid,0,npCount);

	int n[3];		//洢ѡƬid
	A3DVECTOR3 v;
	bool bValid;	

	CCombGenerator cg(3,npCount);

	ASSERT_IN_UPDATE_ERROR(cg.IsSolvable());			//ȷnpCount>=3

	while(!cg.IsOver())
	{
		//һ
		cg.GetNextComb(n);

		//
		if(Solve3NPIntersection(n,v))
		{
			bValid=true;
			
			//н⣬ȴ뵽ǰƽķ
			//ע⣺쵱ǰƬʱӦǲڵǰƬڲ
			if(this->Inside(v)) 
				continue;			//ֱӽһwhileѭ
			
			//Ƭ̼
			for(int i=0;i<npCount;i++)
			{
				if(i!=n[0] && i!=n[1] && i!=n[2])
				{
					//ЩƬⲿ

					if(m_arrNeighbors[i].pNeighborPatch->Outside(v))
					{
						bValid=false;
						break;		//ĳƽⲿforѭ
					}
				}
			} // end of for-loop

			if(bValid)
			{
				//˵õȷʵһЧĽ㣬Լ
				// for debug

				float error=OnPlane(v)?0.0f:DistV2Plane(v);			//OnPlane()þΪ0.0f

				if(error>m_fRemovedError) 
					m_fRemovedError=error;

				//ýƬΪЧ
				NPValid[n[0]]=1;
				NPValid[n[1]]=1;
				NPValid[n[2]]=1;
			}
		}//޽ݲ
		else
		{
		}
	} // end of while-loop

	//ǷеƬЧ
	if(memchr(NPValid,0,npCount))
	{
		m_fRemovedError=-1.0f;		//ҵЧƬ
	}

Exit:
	delete[] NPValid;
}

//////////////////////////////////////////////////////////////////////
// n[0,1,2]ƬĽ㣬vIntersection
// ޽⼰false!
//////////////////////////////////////////////////////////////////////
bool CPatch::Solve3NPIntersection(int n[3], A3DVECTOR3 &vIntersection)
{
	int npCount=m_arrNeighbors.GetSize();
	
	//Ч
	if(n[0]<0 || n[0]>=npCount ||
	   n[1]<0 || n[1]>=npCount ||
	   n[2]<0 || n[2]>=npCount )
	   return false;
	
	//Է
	CMatrix	mtxCoef(3,3);		// ϵ
	CMatrix mtxConst(3,1);		// 
	CMatrix	mtxResult(3,1);		// 

	for(int i=0;i<3;i++)
	{
		CPatch* pPatch=m_arrNeighbors[n[i]].pNeighborPatch;

		A3DVECTOR3 v(pPatch->GetNormal());
		mtxCoef.SetElement(i,0,v.x);
		mtxCoef.SetElement(i,1,v.y);
		mtxCoef.SetElement(i,2,v.z);
		mtxConst.SetElement(i,0,pPatch->GetDist());
	}
	
	//ø˹ȫѡԪ
	CLEquations le(mtxCoef,mtxConst);
	if(!le.GetRootsetGauss(mtxResult))
		return false;
	
	vIntersection.x=(float)mtxResult.GetElement(0,0);
	vIntersection.y=(float)mtxResult.GetElement(1,0);
	vIntersection.z=(float)mtxResult.GetElement(2,0);

	return true;

}

//////////////////////////////////////////////////////////////////////
// ĵķ Ƭ͹ɾ
// 漰˺ܶصĲ
// µĶ㡢¶ӡƬɾƬĸµȲ
//////////////////////////////////////////////////////////////////////
bool CPatch::Removed() 
{
	int npCount=m_arrNeighbors.GetSize();
	if(npCount<3) return false;

	//һЩҪݽṹ
	AArray<A3DVECTOR3,A3DVECTOR3> VerteciesAdded;			//ɾ󽫲µĶ㼯
	AArray<char,char> VDegree;								//²Ķڽƽ϶̬һһӦ

	//ЩƽཻͬĶ
	//ӦҪӵĶ
	//ӵĶv,VerteciesAddedеidΪ2
	//PatchesIntersectV[2]Ӧһ̬飬Ԫ
	//ΪཻڵvpatchƬid
	//ע⣺
	//AArray<AArray<int,int>,AArray<int,int>>ڱʱᱨ
	//˵ģʹʱ֧Ƕ׶塣ˣָ룡
	AArray<AArray<int,int>*,AArray<int,int>*> PatchesIntersectV;
	
	//ƬЩ¼Ķ
	AArray<AArray<int,int>*,AArray<int,int>*> VerticesInPatch;
	VerticesInPatch.SetSize(npCount,0);
	int i(0);
	for(i=0;i<npCount;i++)
	{	
		//ʼVerticesInPatchÿһԪ
		VerticesInPatch[i]=new AArray<int,int>;
	}

	/////////////////////////////////////////////////////////////////////
	// ½㲿֣
	/////////////////////////////////////////////////////////////////////
	
	int n[3];		//洢ѡƬid
	CCombGenerator cg(3,npCount);
	//assert(cg.IsSolvable());			//ȷnpCount>=3
	A3DVECTOR3 v;
	bool bValid;	
	
	//ѭ
	while(!cg.IsOver())
	{
		//һ
		cg.GetNextComb(n);
		if(Processed(n,PatchesIntersectV))			//Ѿֱһѭ
			continue;

		if(Solve3NPIntersection(n,v))				//Ψһ
		{
			bValid=true;
			
			//н⣬ȴ뵽ǰƽķ
			//ע⣺쵱ǰƬʱӦǲڵǰƬڲ
			//ڸƽϻⲿ
			if(this->Inside(v)) 
				continue;			//ֱӽһwhileѭ
			AArray<int,int>* pPatchesPassV=new AArray<int,int>;		//һvƬĶ̬
			
			//δƬ̼
			for(i=0;i<npCount;i++)
			{
				if(i!=n[0] && i!=n[1] && i!=n[2])
				{
					//ЩƬⲿ
					if(m_arrNeighbors[i].pNeighborPatch->Outside(v))
					{
						bValid=false;
						break;		//ĳƽⲿforѭ
					}
					//ƽϵ
					if(m_arrNeighbors[i].pNeighborPatch->OnPlane(v))
					{
						pPatchesPassV->Add(i);			//ֹ
					}
				}
			} // end of for-loop
			
			if(bValid)	//ЧĽ
			{
				VerteciesAdded.Add(v);		//ӵЧб
				
				//n[0,1,2]ཻڸöƽб
				pPatchesPassV->Add(n[0]);
				pPatchesPassV->Add(n[1]);
				pPatchesPassV->Add(n[2]);
				
				//modified by wf, 04-10-09
				//Ϊ֤ǰһԶĴ޸ģ
				int ExistPIV;
				if((ExistPIV=HasPIntersectVExist(pPatchesPassV,PatchesIntersectV))==-1)
				{
					//ڲһµ

					//бPatchesIntersectV
					PatchesIntersectV.Add(pPatchesPassV);	
					
					//¼
					VDegree.Add(pPatchesPassV->GetSize());
					
					//öVerteciesAddedеidӵ
					//ཻڸöĸƬӦVerticesInPatch
					int vid=VerteciesAdded.GetSize()-1;
					int npid;
					for(i=0;i<pPatchesPassV->GetSize();i++)
					{
						npid=pPatchesPassV->GetAt(i);
						VerticesInPatch[npid]->Add(vid);
					}
				}
				else
				{
					//˲һµʱƬཻ
					VerteciesAdded.RemoveTail();		//ɾõ

					AArray<int,int>* pExistPIV=PatchesIntersectV[ExistPIV];
					PatchesIntersectV[ExistPIV]=pPatchesPassV;
					VDegree[ExistPIV]=pPatchesPassV->GetSize();		
					//öVerteciesAddedеidӵ
					//ཻڸöĸƬӦVerticesInPatch
					//int vid=VerteciesAdded.GetSize()-1;
					int npid;
					for(i=0;i<pPatchesPassV->GetSize();i++)
					{
						npid=pPatchesPassV->GetAt(i);
						if(!InArray(npid,pExistPIV))			//npidûгֹvid
							VerticesInPatch[npid]->Add(ExistPIV);
					}
					
					delete pExistPIV;		//ͷڴ
				}

			}
			else
				delete pPatchesPassV;			//ǰЧǰڴ

		}//޽ݲ
	}// end of while-loop

	//ûкϷ½㣬Ӧ÷false
	//ԣӦò̫سΪڼСʱ
	//Ӧų޽˻һСͱһԵ
	if(VerteciesAdded.GetSize()==0)
	{
		//ͷڴ

		for(i=0;i<PatchesIntersectV.GetSize();i++)
			delete PatchesIntersectV[i];
		for(i=0;i<VerticesInPatch.GetSize();i++)
			delete VerticesInPatch[i];

		return false;
	}

	/////////////////////////////////////////////////////////////////////
	// Polytopeв½㲿֣
	/////////////////////////////////////////////////////////////////////
	//¼ǰPolytopeеĶĿ½ȫidΪg_vid,g_vid+1,g_vid+2...
	//˿ɹԺƬ򶥵бʹ
	int g_vid=m_pConvexPolytope->GetVNum();	
	for(i=0;i<VerteciesAdded.GetSize();i++)
	{
		VertexInfo vInfo;
		vInfo.cDegree=VDegree[i];
		m_pConvexPolytope->AddV(VerteciesAdded[i],vInfo);
	}
	
	
	//֮ǰӦȽǰƬݣһԿǷCPolytopeRemoved()
	//ǰУ

	/////////////////////////////////////////////////////////////////////
	// Ƭб(Ƭ)
	/////////////////////////////////////////////////////////////////////
	CPatch* pCurNP;			//ǰƬ
	int g_vid1,g_vid2;		//ǰƬӦĶ㣬ڱϵһ㣨ȫid
	/////////////////////////////////////////////////////////////////////
	// עƬУߵķ෴
	//
	//				 ǰƬP
	//             \  ---->   /
	//	Ӧ(Pnk) v1\________/ v2 ӦƬ(Pn2)
	//              /        \
	//             / <-----   \
	//				  Ƭ(Pn1)
	//
	/////////////////////////////////////////////////////////////////////
	int next,pre;
	AArray<int,int> VSorted;				//ն˳Ӻõ
	AArray<int,int>* pArrVertices;
	int vid,lastvid;
	for(i=0;i<npCount;i++)					//ѭÿһƬֱǣѭһƬĴ
	{
		VSorted.RemoveAll();				//ϴѭеĶб

		next=(i+1<npCount)?i+1:0;			//һneighborʾ״ṹҪһ
		pre=(i-1<0)?npCount-1:i-1;			//һneighbor

		pCurNP=m_arrNeighbors[i].pNeighborPatch;
		g_vid1=m_arrNeighbors[i].vid;
		g_vid2=m_arrNeighbors[next].vid;
		pArrVertices=VerticesInPatch[i];
		
		/////////////////////////////////////////////////////////////////////
		// ʼ
		// עĶ㷨ƺûбȻóȷı
		// ˣһҲӦΪԺ͵Եص㣡
		/////////////////////////////////////////////////////////////////////

		//Ȳvid2ڽӵĶ
		int j(0);
		for(j=0;j<pArrVertices->GetSize();j++)
		{
			vid=pArrVertices->GetAt(j);
			if(InArray(i,PatchesIntersectV[vid]) &&		//vid1ӦƬ(Pn1)vid
			   InArray(next,PatchesIntersectV[vid]))	//vid2ӦƬ(Pn2)vid
			{
				//˵vidv2ڽ
				VSorted.Add(vid);		//
				break;					//ҵˣ
			}
		}
		//ȷҵ
		ASSERT_IN_REMOVE_PATCH(VSorted.GetSize()==1);	

		//ȻѰҲڵ㣡
		
		//lastvid־һѱӵĶ
		//llvid־ڶӵĶ㣬ıΪ˱ظӣ
		int llvid;	
		int counter=1;			//counterֹѭ
		while(counter<pArrVertices->GetSize())
		{
			counter++;

			lastvid=VSorted[VSorted.GetSize()-1];
			if(VSorted.GetSize()<2)
				llvid=-1;		//һЧֵΪʱûеڶ
			else
				llvid=VSorted[VSorted.GetSize()-2];

			for(j=0;j<pArrVertices->GetSize();j++)
			{
				vid=pArrVertices->GetAt(j);
				//طӦжϣظӣ
				if((vid!=lastvid) && (vid!=llvid) && IsVAdjacent(PatchesIntersectV[lastvid],PatchesIntersectV[vid]))	//
				{
					VSorted.Add(vid);
					break;
				}
			} // end of for-loop
		} // end of while-loop
		
		ASSERT_IN_REMOVE_PATCH(counter==VSorted.GetSize());
		
		lastvid=VSorted[VSorted.GetSize()-1];
		
		//ȷһlastvidӦǺv1ڽӵ
		ASSERT_IN_REMOVE_PATCH(InArray(pre,PatchesIntersectV[lastvid]) && 
							   InArray(i,PatchesIntersectV[lastvid]) );
			   
		/////////////////////////////////////////////////////////////////////
		// ȷӹϵԿʼƬĶ
		/////////////////////////////////////////////////////////////////////
		//жv1v2ǷӦôӵǰƬNeighborɾ
		//жϷv2Ϊv2ƬP,Pn1,Pn2v2ɾˣԼΪǷΪ3>3
		AArray<VPNeighbor,VPNeighbor>& Neighbors=pCurNP->GetNeighbors();
		//Ѱv2ڵǰƬеλ
		for(j=0;j<Neighbors.GetSize();j++)
		{
			int tmp=Neighbors[j].vid;
			if(g_vid2==Neighbors[j].vid)
				break;
		}
		//ѭj˵ǰv2λ
		int v2pos=j;
		ASSERT_IN_REMOVE_PATCH(v2pos<Neighbors.GetSize());				//ȷһҵ
		ASSERT_IN_REMOVE_PATCH(g_vid1==pCurNP->GetNextV(v2pos));		//ȷv2һӶv1
		
		bool bv2Last=(v2pos==Neighbors.GetSize()-1);	//v2ǷNeighborһԪأ

		//ȴv1ΪĲȽϼ򵥣ֱɾɣ
		//жv1ǷӦôӵǰƬNeighborɾ
		VertexInfo& v1Info=m_pConvexPolytope->GetVInfo(g_vid1);
		if(v1Info.cDegree==3)
		{
			//ɾv1ڵǰpatchеΪpCurNP->GetNext(j)
			Neighbors.RemoveAt(pCurNP->GetNext(v2pos));	
			if(bv2Last)		//˵v1ǵһԪأˣɾv1Ӧv2posԼ
				v2pos--;
		}
		int InsertPos;				//ӵλ

		//v2Ƿɾ
		VertexInfo& v2Info=m_pConvexPolytope->GetVInfo(g_vid2);
		if(v2Info.cDegree==3)
		{
			//Ӧɾv2
			Neighbors.RemoveAt(v2pos);
			InsertPos=v2pos;						//v2ѱɾֱӴv2pos
		}
		else
		{
			//ɾv2޸pNeighborPatch
			Neighbors[v2pos].pNeighborPatch=m_arrNeighbors[next].pNeighborPatch;	//޸ӦNeighborPatchΪPn2!
			InsertPos=pCurNP->GetNext(v2pos);		//v2posһԪ
		}		
		
		//Ҫӵ
		AArray<VPNeighbor,VPNeighbor> NeighborsToAdd;		//Ҫӵ
		VPNeighbor vpn;
		for(j=0;j<VSorted.GetSize();j++)					
		{
			vpn.vid =VSorted[j]+g_vid;						//ע⣬ҪȫidӦg_vid
			if(j==VSorted.GetSize()-1)	
			{
				//һڵҪ⴦
				//ƬӦڱƬһƬ
				vpn.pNeighborPatch=m_arrNeighbors[pre].pNeighborPatch;	
			}
			else
			{
				//Ҫһ㷨ҳӦڸõƬ
				for(int k=0;k<npCount;k++)
				{
					if(k!=i)		//ǵǰڿƬ
					{
						AArray<int,int>* pVertecies=VerticesInPatch[k];
						if(InArray(VSorted[j],pVertecies) && InArray(VSorted[j+1],pVertecies) )
						{
							//VSorted[j,j+1]ɵı߳pVertecies
							//˵kƬӦ˶VSorted[j]
							vpn.pNeighborPatch=m_arrNeighbors[k].pNeighborPatch;
						}

					}
				}
			}
			ASSERT_IN_REMOVE_PATCH(vpn.pNeighborPatch);
			NeighborsToAdd.Add(vpn);
		}

		//µ
		Neighbors.InsertAt(InsertPos,NeighborsToAdd);
		
		//ǰƬpCurNPµOKҪиɾ
		pCurNP->UpdateRemovedError();

	} // end of for-loop
	
	//ѭǰƬÿһ㣬Լ1
	int curvid;
	for(i=0;i<npCount;i++)
	{
		curvid=m_arrNeighbors[i].vid;
		VertexInfo& curVInfo=m_pConvexPolytope->GetVInfo(curvid);
		curVInfo.cDegree--;
	}

	//ͷڴ
	for(i=0;i<PatchesIntersectV.GetSize();i++)
		delete PatchesIntersectV[i];
	for(i=0;i<VerticesInPatch.GetSize();i++)
		delete VerticesInPatch[i];

	return true;		//ɾɹ

//쳣
ExceptionOccur:
	//ͷڴ
	for(i=0;i<PatchesIntersectV.GetSize();i++)
		delete PatchesIntersectV[i];
	for(i=0;i<VerticesInPatch.GetSize();i++)
		delete VerticesInPatch[i];
	
	//ɾΪЧ
	m_fRemovedError=-1.0f;

	//׳쳣
	m_pConvexPolytope->ThrowException();
	
	//أɾʧ
	return false;
}

//////////////////////////////////////////////////////////////
// жn[0,1,2]ԪǷѾڶཻһ
// ͬбС
// ǣ¼idӦƬĽˣ
// Removed()е
//////////////////////////////////////////////////////////////
bool CPatch::Processed(int n[], AArray<AArray<int,int>*,AArray<int,int>*>& CoSolutionList)
{
	bool bInArray[3];
	AArray<int,int>* pArr;

	for(int i=0;i<CoSolutionList.GetSize();i++)
	{
		pArr=CoSolutionList[i];
		assert(pArr->GetSize()>=3);
		if(pArr->GetSize()==3)			//׼һ⣬ֱ
			continue;
		
		bInArray[0]=false;				//ʼ
		bInArray[1]=false;				//ʼ
		bInArray[2]=false;				//ʼ

		//ͬ
		for(int j=0;j<pArr->GetSize();j++)
		{
			if(n[0]==pArr->GetAt(j)) bInArray[0]=true;
			if(n[1]==pArr->GetAt(j)) bInArray[1]=true;
			if(n[2]==pArr->GetAt(j)) bInArray[2]=true;
		}

		if(bInArray[0] && bInArray[1] && bInArray[2])
			return true;
	}
	
	return false;
}

bool CPatch::InArray(int pid, AArray<int,int>* pArr)
{
	for(int i=0;i<pArr->GetSize();i++)
		if(pid==pArr->GetAt(i))
			return true;
	return false;
}

//////////////////////////////////////////////////////////////
// ж¼Ƿڽ
// ䷽ΪжӦƬУǷȫͬ
// Removed()е
//////////////////////////////////////////////////////////////
bool CPatch::IsVAdjacent(AArray<int,int>* pArr1, AArray<int,int>* pArr2)
{
	int count=0;
	for(int i=0;i<pArr1->GetSize();i++)
		if(InArray(pArr1->GetAt(i),pArr2))
		{
			count++;
			if(count==2) return true;
		}
	return false;
}

//жpPatchǷڵǰƬƬ֮
bool CPatch::InNeighbors(CPatch *pPatch)
{
	for(int i=0;i<m_arrNeighbors.GetSize();i++)
	{
		if(pPatch==m_arrNeighbors[i].pNeighborPatch)
			return true;
	}
	
	return false;

}

//////////////////////////////////////////////////////////////
// дһƹ캯ȱʡĸƹ캯
// Ӷڿʱm_arrNeighborsֱӸֵ
// ָĿӶڴɾ
//////////////////////////////////////////////////////////////
CPatch::CPatch(const CPatch &patch)
{
	m_vNormal=patch.m_vNormal;
	m_d=patch.m_d;
	m_fRemovedError=patch.m_fRemovedError;
	m_pConvexPolytope=patch.m_pConvexPolytope;

	//עһĲͬ
	int nSize=patch.m_arrNeighbors.GetSize();
	for(int i=0;i<nSize;i++)
	{
		VPNeighbor vpNB=patch.m_arrNeighbors[i];
		m_arrNeighbors.Add(patch.m_arrNeighbors[i]);
	}

}

//////////////////////////////////////////////////////////////
// дһֵӶָ
// ǳдĸƹ캯вͬ
//////////////////////////////////////////////////////////////
const CPatch& CPatch::operator=(const CPatch& patch)
{
	if(this!=&patch)	//ֵֹ
	{
		m_vNormal=patch.m_vNormal;
		m_d=patch.m_d;
		m_fRemovedError=patch.m_fRemovedError;
		m_pConvexPolytope=patch.m_pConvexPolytope;

		//עһĲͬ
		int nSize=patch.m_arrNeighbors.GetSize();

		m_arrNeighbors.RemoveAll();			//һ
		
		for(int i=0;i<nSize;i++)
		{
			VPNeighbor vpNB=patch.m_arrNeighbors[i];
			m_arrNeighbors.Add(patch.m_arrNeighbors[i]);
		}

	}
	
	return *this;
}

//////////////////////////////////////////////////////////////
// Added by wf,04-10-09
// Ϊ֤㽻һԶӵĺ
// ǰÿһཻһƽƬǷ
// ԰ڵǰĽһƽƬPIntersectV
// У򷵻PatchesIntersectVid
// 򣬷-1
//////////////////////////////////////////////////////////////
int CPatch::HasPIntersectVExist(AArray<int,int>* pPIntersectV,const AArray<AArray<int,int>*,AArray<int,int>*>& PatchesIntersectV)
{
	if(pPIntersectV->GetSize()==3)		
		return -1;			//ֻԪأ˲ڰϵֱӷأ1

	AArray<int,int>* pPIV;
	int pid;
	bool bIn;
	for(int i=0;i<PatchesIntersectV.GetSize();i++)
	{
		bIn=true;
		pPIV=PatchesIntersectV[i];
		for(int j=0;j<pPIV->GetSize();j++)
		{
			pid=pPIV->GetAt(j);
			if(!InArray(pid,pPIntersectV))
			{
				bIn=false;
				break;
			}
		}
		if(bIn)
			return i;
	}

	return -1;

}
///////////////////////////////////////////////////
// ƬжĶ1
// ⽫Ƭɾָʱ
///////////////////////////////////////////////////
void CPatch::IncreVDegree()
{
	int vid;
	for(int i=0;i<m_arrNeighbors.GetSize();i++)
	{
		vid=m_arrNeighbors[i].vid;
		m_pConvexPolytope->GetVInfo(vid).cDegree++;
	}
}

///////////////////////////////////////////////////
// ƬжĶ1
// ⽫Ƭɾָɾʱ
///////////////////////////////////////////////////
void CPatch::DecreVDegree()
{
	int vid;
	for(int i=0;i<m_arrNeighbors.GetSize();i++)
	{
		vid=m_arrNeighbors[i].vid;
		m_pConvexPolytope->GetVInfo(vid).cDegree--;
	}

}

A3DVECTOR3 CPatch::GetVertex(int vid) 
{ 
	return m_pConvexPolytope->GetV(m_arrNeighbors[vid].vid);
}

void CPatch::GetEdge(int id,A3DVECTOR3& v1,A3DVECTOR3& v2)
{
	v1=m_pConvexPolytope->GetV(m_arrNeighbors[id].vid);
	v2=m_pConvexPolytope->GetV(GetNextV(id));
}

}	// end namespace