// ConvexPolytope.cpp: implementation of the CConvexPolytope class.
//
//////////////////////////////////////////////////////////////////////
#include "ConvexPolytope.h"
#include "GiftWrap.h"
#include "ConvexHullData.h"
#include "2DGiftWrap.h"
#include <A3DGDI.h>

#define MAX_ERROR 1e8

#ifndef ABS
	#define ABS(x) (((x)<0)?(-(x)):(x))
#endif



namespace CHBasedCD
{

//ʼ̬Ա
float CConvexPolytope::Hull2D_Half_Thickness=0.05f;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CConvexPolytope::CConvexPolytope()
{
	m_pIndices=new WORD[1000*3];						//ʼΪһֵ
	m_pLEPIndices=new WORD[60*3];						//СƬθ*3
	m_pLEPNIndices=new WORD[60*3];						//СƬƬθ*3

	m_pVerticesForRender=new A3DVECTOR3[2000];		//ʼȾõĶ
	m_nOriginPatchNum=0;
	m_nCurOperator=-1;

	m_fArrRemovedError=NULL;
	m_fErrorBase=1.0f;					//һȱʡֵ1.0f
	m_nMinPatchNum=4;
	m_bExceptionOccur=false;

	m_vCentroid.Clear();			//ʼ

	CHalfSpace::SetDistThresh();  //Halfspaceָȱʡֵ
}

CConvexPolytope::~CConvexPolytope()
{
	Reset();							//

	delete []m_pIndices;				//ζб
	delete []m_pLEPIndices;				//ζб
	delete []m_pLEPNIndices;			//ζб

	delete []m_pVerticesForRender;
	
	if(m_fArrRemovedError) delete []m_fArrRemovedError;

		
}

//ʹCGiftWrapɵ͹ʼǰƬԱ
bool CConvexPolytope::Init(const CGiftWrap &gw)
{
	assert(!gw.m_bExceptionOccur);			//ûз쳣
 
	Reset();								//Ϊʼ״̬

	m_vCentroid=gw.m_vCentroid;				//Ϊʼgw

	int i(0);
	//ǹCConvexPolytope
	if(gw.GetHullType()==CGiftWrap::HULL_3D)	//3D Hull	
	{
		int* Map=new int[gw.m_nVNum];		//һӳ
		int count=0;
		
		//Ч&ӳ
		for(i=0;i<gw.m_nVNum;i++)
		{
			Map[i]=-1;			
			if(gw.m_pbExtremeVertex[i])
			{
				//ǰЧʼv뵽б
				A3DVECTOR3 v(gw.m_pVertexes[i]);	
			
				// DEBUGGING
				//char buffer[100];
				//sprintf(buffer, "Adding Vertex: %f, %f, %f\n", v.x, v.y, v.z);
				//OutputDebugString(&buffer[0]);
				// DEBUGGING END

				m_arrVertecies.Add(v);
				m_arrVertexInfo.Add(VertexInfo());
				Map[i]=count++;
			}
		}

		//Ƭ
		//Ƭ
		for(i=0;i<gw.m_Faces.GetSize();i++)
		{
			Face f=gw.m_Faces[i];
			if(!f.InPolygon)		//κζΣ
			{
				A3DVECTOR3 v1(gw.m_pVertexes[f.v1]),v2(gw.m_pVertexes[f.v2]),v3(gw.m_pVertexes[f.v3]);
				CPatch* pPatch=new CPatch(this);
				pPatch->Set(v1,v2,v3);			//Ϣ

				// DEBUGGING
				//char buffer[100];
				//sprintf(buffer, "Add Patch From GW Face: %f (%f, %f, %f)\n", pPatch->GetDist(), pPatch->GetNormal().x, pPatch->GetNormal().y, pPatch->GetNormal().z);
				//OutputDebugString(&buffer[0]);
				// DEBUGGING END


				//NeighborsԪ
				VPNeighbor vpn;
				AArray<VPNeighbor,VPNeighbor>& arrNeighbors=pPatch->GetNeighbors();
				
				vpn.vid=Map[f.v1];				//һӳ
				assert(vpn.vid>=0);
				arrNeighbors.Add(vpn);
				// DEBUGGING
				//sprintf(buffer, "\tNeighbor: %d\n", vpn.vid);
				//OutputDebugString(&buffer[0]);
				// DEBUGGING END
				
				vpn.vid=Map[f.v2];
				assert(vpn.vid>=0);
				arrNeighbors.Add(vpn);
				// DEBUGGING
				//sprintf(buffer, "\tNeighbor: %d\n", vpn.vid);
				//OutputDebugString(&buffer[0]);
				// DEBUGGING END

				vpn.vid=Map[f.v3];
				assert(vpn.vid>=0);
				arrNeighbors.Add(vpn);
				// DEBUGGING
				//sprintf(buffer, "\tNeighbor: %d\n", vpn.vid);
				//OutputDebugString(&buffer[0]);
				// DEBUGGING END

				//1
				m_arrVertexInfo[Map[f.v1]].cDegree++;
				m_arrVertexInfo[Map[f.v2]].cDegree++;
				m_arrVertexInfo[Map[f.v3]].cDegree++;

				//ӵ
				m_listPatches.AddTail(pPatch);
			}
		}

		//ӶƬ
		for(i=0;i<gw.m_Planes.GetSize();i++)
		{
			AArray<int,int>* pPlane=gw.m_Planes[i];
			
			//ȡǰ㹹ƽ漸Ϣ
			A3DVECTOR3 v1(gw.m_pVertexes[pPlane->GetAt(0)]),v2(gw.m_pVertexes[pPlane->GetAt(1)]),v3(gw.m_pVertexes[pPlane->GetAt(2)]);
			CPatch* pPatch=new CPatch(this);
			pPatch->Set(v1,v2,v3);			//Ϣ			

			// DEBUGGING
			//char buffer[100];
			//sprintf(buffer, "Add Patch From GW Plane: %f (%f, %f, %f)\n", pPatch->GetDist(), pPatch->GetNormal().x, pPatch->GetNormal().y, pPatch->GetNormal().z);
			//OutputDebugString(&buffer[0]);
			// DEBUGGING END


			//NeighborsԪ
			VPNeighbor vpn;
			AArray<VPNeighbor,VPNeighbor>& arrNeighbors=pPatch->GetNeighbors();

			for(int j=0;j<pPlane->GetSize();j++)
			{
				vpn.vid=Map[pPlane->GetAt(j)];			//һӳ
				arrNeighbors.Add(vpn);
				// DEBUGGING
				//sprintf(buffer, "\tNeighbor: %d\n", vpn.vid);
				//OutputDebugString(&buffer[0]);
				// DEBUGGING END
				
				m_arrVertexInfo[vpn.vid].cDegree++;		//1
			}
			
			//ӵ
			m_listPatches.AddTail(pPatch);
		}
		
		delete [] Map;

	}
	else
	{

		//˵2D Hull
		AArray<int,int>* pCHVs=gw.GetCHVertecies();
		if (!pCHVs) 
			return false;	
		if(pCHVs->GetSize()<3)		//һ
			return false;

		//Ϣ
		VertexInfo vInfo;
		vInfo.cDegree=3;			//ֱжΪ3

		CHalfSpace PlaneOut,PlaneIn;

		//ȡǰ㹹ƽ漸Ϣ
		A3DVECTOR3 v1(gw.m_pVertexes[pCHVs->GetAt(0)]),v2(gw.m_pVertexes[pCHVs->GetAt(1)]),v3(gw.m_pVertexes[pCHVs->GetAt(2)]);
		
		//ƽPlaneOutPlaneInֱʾ͵
		PlaneOut.Set(v1,v2,v3);			
		
		PlaneIn.SetNormal(-PlaneOut.GetNormal());
		PlaneIn.SetD(-PlaneOut.GetDist());
		
		PlaneIn.Translate(Hull2D_Half_Thickness);
		PlaneOut.Translate(Hull2D_Half_Thickness);
		
		A3DVECTOR3 vOutNormal=PlaneOut.GetNormal();
		A3DVECTOR3 vInNormal=PlaneIn.GetNormal();
		
		//ֱPlaneOut,PlaneInϵ
		A3DVECTOR3 vOut=v1+Hull2D_Half_Thickness*vOutNormal;
		A3DVECTOR3 vIn=v1+Hull2D_Half_Thickness*vInNormal;

		//춥㼰Ϣ
		for(i=0;i<pCHVs->GetSize();i++)
		{
			//ͬʱӵͶһ
			A3DVECTOR3 vec1=gw.m_pVertexes[pCHVs->GetAt(i)];
			A3DVECTOR3 vec2=vec1;
			if(i<3)
			{
				vec1+=Hull2D_Half_Thickness*vOutNormal;
				vec2+=Hull2D_Half_Thickness*vInNormal;
			}
			else
			{
				A3DVECTOR3 vDiff=vec1-vOut;
				vec1-=DotProduct(vDiff,vOutNormal)*vOutNormal;

				vDiff=vec2-vIn;
				vec2-=DotProduct(vDiff,vInNormal)*vInNormal;
			}

			m_arrVertecies.Add(vec1);
			m_arrVertecies.Add(vec2);

			//ӦģϢ
			m_arrVertexInfo.Add(vInfo);
			m_arrVertexInfo.Add(vInfo);
		}
	
		//ʼƽƬ

		//
		CPatch* pPatch=new CPatch(this);
		pPatch->SetNormal(vOutNormal);			//Ϣ
		pPatch->SetD(PlaneOut.GetDist());
		
		//NeighborsԪ
		VPNeighbor vpn;
		AArray<VPNeighbor,VPNeighbor>& arrNeighbors1=pPatch->GetNeighbors();
		for(i=0;i<pCHVs->GetSize();i++)
		{
			vpn.vid=2*i;			
			arrNeighbors1.Add(vpn);
		}
		//ӵ
		m_listPatches.AddTail(pPatch);	
		
		//ڵ

		pPatch=new CPatch(this);
		pPatch->SetNormal(vInNormal);			//Ϣ
		pPatch->SetD(PlaneIn.GetDist());
		
		//NeighborsԪ
		AArray<VPNeighbor,VPNeighbor>& arrNeighbors2=pPatch->GetNeighbors();
		//水
		for(i=pCHVs->GetSize()-1;i>=0;i--)
		{
			vpn.vid=2*i+1;			
			arrNeighbors2.Add(vpn);
		}
		//ӵ
		m_listPatches.AddTail(pPatch);	
		
		//ʼӸ
		for(i=0;i<pCHVs->GetSize();i++)
		{
			pPatch=new CPatch(this);		
			AArray<VPNeighbor,VPNeighbor>& arrNeighbors=pPatch->GetNeighbors();
			
			//ÿ涼һ
			if(i<pCHVs->GetSize()-1)
			{
				v1=m_arrVertecies[2*i+2];
				v2=m_arrVertecies[2*i];
				v3=m_arrVertecies[2*i+1];
				pPatch->Set(v1,v2,v3);
				
				vpn.vid=2*i;
				arrNeighbors.Add(vpn);

				vpn.vid=2*i+1;
				arrNeighbors.Add(vpn);

				vpn.vid=2*i+3;
				arrNeighbors.Add(vpn);

				vpn.vid=2*i+2;
				arrNeighbors.Add(vpn);
				
			}
			else		
			{
				//һεȽ
				v1=m_arrVertecies[0];
				v2=m_arrVertecies[2*i];
				v3=m_arrVertecies[2*i+1];
				pPatch->Set(v1,v2,v3);
				
				vpn.vid=2*i;
				arrNeighbors.Add(vpn);

				vpn.vid=2*i+1;
				arrNeighbors.Add(vpn);

				vpn.vid=1;
				arrNeighbors.Add(vpn);

				vpn.vid=0;
				arrNeighbors.Add(vpn);			
			}
			m_listPatches.AddTail(pPatch);
		}	
			

	}

	
	m_nOriginPatchNum = m_listPatches.GetCount();
	m_nCurVNum=m_arrVertecies.GetSize();

	//ʼɾ
	if(m_fArrRemovedError)
		delete[] m_fArrRemovedError;
	m_fArrRemovedError=new float[m_nOriginPatchNum+1];
	for(i=0;i<m_nOriginPatchNum+1;i++)
		m_fArrRemovedError[i]=-1.0f;			//0,1,2,3ΪЧֵ
	
	m_bExceptionOccur=false;

	//ÿpatchpatch
	ComputePatchNeighbors();
 
	//CHalfSpace::SetDistThresh(1e-3);  //ָȱʡֵ

	//ѰСɾӦƬ
	SearchLeastErrorPatch();		

	//ʼ򻯣򻯵ͷ
	ReduceAll();

	return true;
}

void CConvexPolytope::ComputePatchNeighbors()
{
	//һѭ
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	ALISTPOSITION TraPatchPos;
	CPatch *pCurPatch,*pTraPatch;

	for(int i=0;i<m_listPatches.GetCount();i++)
	{
		pCurPatch=m_listPatches.GetNext(CurPatchPos);
		TraPatchPos=m_listPatches.GetHeadPosition();
		for(int j=0;j<m_listPatches.GetCount();j++)
		{
			pTraPatch=m_listPatches.GetNext(TraPatchPos);
			if(i!=j)
				pCurPatch->Neighbor(pTraPatch);
		}
		//굱ǰPatchƬ
		//ͿԼɾ
		pCurPatch->UpdateRemovedError();

		// DEBUGGING
		//char buffer[100];
		//sprintf(buffer, "Patch (%d): %f (%f, %f, %f) Err: %f\n", i, pCurPatch->m_d, pCurPatch->m_vNormal.x, pCurPatch->m_vNormal.y, pCurPatch->m_vNormal.z, pCurPatch->GetRemovedError());
		//OutputDebugString(&buffer[0]);

		// DEBUGGING END

	}
}

void CConvexPolytope::UndoRemove()
{
	if(m_nCurOperator==-1)			//Ѿݵʼ״̬ˣܼ
		return;
	
	int RemOprCount=m_arrRemoveOperatorRecords.GetSize();
	RemoveOperatorRecord& ror=*(m_arrRemoveOperatorRecords[m_nCurOperator]); 
	
	//뵱ǰ¼ɾƬ
	m_listPatches.AddTail(ror.pRemoved);
	ror.pRemoved->IncreVDegree();			//1

	//޸ĵǰ
	m_nCurVNum-=ror.VNumAdded;

	CPatch *pCur,*pBak;
	CPatch patchTemp(this);
	int nNBNum=ror.arrNeighborBak.GetSize();
	//ALISTPOSITION lpos;
	for(int i=0;i<nNBNum;i++)
	{
		//for debug
		int vid=ror.pRemoved->GetNeighbors()[i].vid;
		A3DVECTOR3 v=m_arrVertecies[vid];
		VertexInfo vInfo=m_arrVertexInfo[vid];


		pCur=ror.arrNeighborBak[i].pPatchCur;
		pBak=ror.arrNeighborBak[i].pPatchBak;


		patchTemp=*pCur;
		*pCur=*pBak;
		*pBak=patchTemp;

	}

	m_nCurOperator--;						//ǰһ

	m_pCurLeastErrorPatch=ror.pRemoved;		//޸ĵǰСƬ

}

void CConvexPolytope::RedoRemove()
{
	int RemOprCount=m_arrRemoveOperatorRecords.GetSize();
	if(m_nCurOperator==RemOprCount-1)	//Ѿһˣǰָ
		return;

	RemoveOperatorRecord& ror=*(m_arrRemoveOperatorRecords[m_nCurOperator+1]); 
	
	//һɾǰ¼ɾƬΪǰĻָѾ
	//ע⣺ƬӦǱlistpatchΪǰĻָ뵽βˡ
	//ͿԱһαѰң
	CPatch* ptail=m_listPatches.GetTail();
	assert(ptail==ror.pRemoved);			//һ֤
	m_listPatches.RemoveTail();
	ror.pRemoved->DecreVDegree();			//1
	
	//޸ĵǰ
	m_nCurVNum+=ror.VNumAdded;

	CPatch *pCur,*pBak;
	CPatch patchTemp(this);
	int nNBNum=ror.arrNeighborBak.GetSize();
	for(int i=0;i<nNBNum;i++)
	{

		pCur=ror.arrNeighborBak[i].pPatchCur;
		pBak=ror.arrNeighborBak[i].pPatchBak;

		patchTemp=*pCur;
		*pCur=*pBak;
		*pBak=patchTemp;
	}

	m_nCurOperator++;		//ǰһ
	
	if(m_nCurOperator==RemOprCount-1)		//һһ
		SearchLeastErrorPatch();			//ʱҪ¼СƬ
	else
		m_pCurLeastErrorPatch=m_arrRemoveOperatorRecords[m_nCurOperator+1]->pRemoved;		//޸ĵǰСƬ
}

void CConvexPolytope::Reset()
{
	m_arrVertecies.RemoveAll();
	m_arrVertexInfo.RemoveAll();
	
	//m_fErrorBase=1.0f;					//һȱʡֵ1.0f

	//ListPatch
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	CPatch* pCurPatch;
	int i(0);
	for(i=0;i<m_listPatches.GetCount();i++)
	{
		pCurPatch=m_listPatches.GetNext(CurPatchPos);
		delete pCurPatch;
	}
	m_listPatches.RemoveAll();		
	
	//RemoveOperatorRecords
	for(i=0;i<m_arrRemoveOperatorRecords.GetSize();i++)
	{
		RemoveOperatorRecord* pror=m_arrRemoveOperatorRecords[i];
		RemoveOperatorRecord& ror=*pror;
		for(int j=0;j<ror.arrNeighborBak.GetSize();j++)
			delete ror.arrNeighborBak[j].pPatchBak;		//ɾǵıָ

		if(i<=m_nCurOperator)		//m_nCurOperator֮ǰĲ
		{
			//ɾƬָʵϲδɾͬʱҲm_listPatchesУˣҪɾ
			delete ror.pRemoved;
		}
		else
		{

		}
		
		delete pror;		//ɾ
		
	}
	m_nCurOperator=-1;
	m_arrRemoveOperatorRecords.RemoveAll();
}

//////////////////////////////////////////////////////////////
// ɾƬpPatch
// ҪɾǰֳãͿֳ֧ɾ
// ֱӵpPatchԼıɾ
//////////////////////////////////////////////////////////////
bool CConvexPolytope::RemovePatch(CPatch *pPatch)
{
	//return pPatch->Removed();
	
	//*
	RemoveOperatorRecord* pror=new RemoveOperatorRecord;
	RemoveOperatorRecord& ror=*pror;			//ǰɾ¼
	ror.pRemoved=pPatch;

	//ƬƲ
	CPatch *pNPBak,*pCurNP;
	AArray<VPNeighbor,VPNeighbor>& Neighbors=pPatch->GetNeighbors();
	int iNBSize=Neighbors.GetSize();
	int i(0);
	for(i=0;i<iNBSize;i++)
	{
		//for debug
		int vid=Neighbors[i].vid;
		A3DVECTOR3 v=m_arrVertecies[vid];
		VertexInfo vInfo=m_arrVertexInfo[vid];

		pCurNP=Neighbors[i].pNeighborPatch;
		pNPBak=new CPatch(*pCurNP);				//ƸpatchNeighborBak
		
		//Ҫǳͻָƺֱӵ
		//ӦΪm_nCurOperatorαɾɾ
		//Ȼӵλã
		ror.arrNeighborBak.Add(NeighborBak(pCurNP,pNPBak));
	}
	
	if(	pPatch->Removed() )		//ɾɹ
	{
		
		//ƳǰƬ
		ALISTPOSITION pos=m_listPatches.Find(pPatch);
		m_listPatches.RemoveAt(pos);

		//¼ӵĶ
		ror.VNumAdded=m_arrVertecies.GetSize()-m_nCurVNum;
		m_nCurVNum=m_arrVertecies.GetSize();

		//ݲ
		m_arrRemoveOperatorRecords.Add(&ror);
		m_nCurOperator++;
		return true;
	}
	else						//ɾʧ
	{
		//ͷڴ
		for(i=0;i<iNBSize;i++)
		{
			delete ror.arrNeighborBak[i].pPatchBak;
		}
		delete pror;
		return false;
	}
	
	 //*/
}

//A3DFlatCollectorл
//һʾǷСƬȱʡΪtrue

//04-10-23 ޸Ĵ˽ӿ
//һpSpecialPatch估ƬĻƴ
void CConvexPolytope::Render(A3DFlatCollector *pFC,A3DMATRIX4& tMatrix, DWORD dwColor,CPatch* pSpecialPatch)
{
	//Ƶɫ
	DWORD dwNCol[]={
					0x8000ff00,
					0x8000ffff,
					0x800000ff,
					0x80ff00ff,
					0x80ffff00,
					0x80007f00,
					0x8000007f
					/*
					0x80000050,
					0x800000a0,
					0x800000ff,
					0x80005050,
					0x800050a0,
					0x800050ff,
					0x8000a050,
					0x8000a0a0,
					0x8000a0ff,
					0x8000ff50,
					0x8000ffa0,
					0x8000ffff
					*/
					};
	
	int colSize=sizeof(dwNCol)/sizeof(dwNCol[0]);

	//
	A3DVECTOR3* pVertices=m_arrVertecies.GetData();
	int vNum=m_arrVertecies.GetSize();
	
	int i,j;	

	
	//ȾĶ㣬Ҫһ任
	for(i=0;i<m_nCurVNum;i++)
	{
		//ֻȾЧĶ㣬öĶ벻С3
		if(m_arrVertexInfo[i].cDegree<3) continue;
		
		//任Ⱦ
		m_pVerticesForRender[i]=pVertices[i]*tMatrix;
		//ݲƶ	
		g_pA3DGDI->Draw3DPoint(m_pVerticesForRender[i],0xff00ff00,3.0f);
	}

	//εĶidб
	//ӦʹΪһһ
	//ȾʱַϢ
	//WORD* pIndices=new WORD(10000);			//Ԥȷһ㹻Ŀռ
	int cur=0;								//һָǰidļ
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	CPatch* pCurPatch;
	if(pSpecialPatch)	
	{
		//pSpecialPatchΪ
		//ƬpSpecialPatchһ⴦ƳɲͬɫӶڹ۲Ч

		//ѡԻ
		for(i=0;i<m_listPatches.GetCount();i++)
		{
			pCurPatch=m_listPatches.GetNext(CurPatchPos);
			if(pCurPatch!=pSpecialPatch && ! pSpecialPatch->InNeighbors(pCurPatch))
			{
				//pSpecialPatchҲ

				AArray<VPNeighbor,VPNeighbor>& Neighbors=pCurPatch->GetNeighbors();
				assert(Neighbors.GetSize()>=3);
				for(j=2;j<Neighbors.GetSize();j++)
				{
					//
					m_pIndices[cur]=Neighbors[0].vid;			//v1ʼΪԪ
					m_pIndices[cur+1]=Neighbors[j-1].vid;		//v2ΪһԪ
					m_pIndices[cur+2]=Neighbors[j].vid;			//v3ΪǰԪ
					cur+=3;
				}
			}
		}

		//
		pFC->AddRenderData_3D(m_pVerticesForRender,vNum,m_pIndices,cur,dwColor);
		
		//СƬ
		cur=0;
		int ncur=0;			//Ƭ
		AArray<VPNeighbor,VPNeighbor>& Neighbors=pSpecialPatch->GetNeighbors();
		for(j=0;j<Neighbors.GetSize();j++)
		{
			if(j>=2)
			{
				//
				m_pLEPIndices[cur]=Neighbors[0].vid;			//v1ʼΪԪ
				m_pLEPIndices[cur+1]=Neighbors[j-1].vid;		//v2ΪһԪ
				m_pLEPIndices[cur+2]=Neighbors[j].vid;		//v3ΪǰԪ
				cur+=3;
			}

			//
			pCurPatch=Neighbors[j].pNeighborPatch;
			AArray<VPNeighbor,VPNeighbor>& NN=pCurPatch->GetNeighbors();	//
			for(i=2;i<NN.GetSize();i++)				//2ʼѭ
			{
				//
				m_pLEPNIndices[ncur]=NN[0].vid;			//v1ʼΪԪ
				m_pLEPNIndices[ncur+1]=NN[i-1].vid;		//v2ΪһԪ
				m_pLEPNIndices[ncur+2]=NN[i].vid;		//v3ΪǰԪ
				ncur+=3;			
			}
			//Ƶǰ
			DWORD curCol=dwNCol[j%colSize];
			pFC->AddRenderData_3D(m_pVerticesForRender,vNum,m_pLEPNIndices,ncur,curCol);	//ɫȾ
			ncur=0;
		}
		pFC->AddRenderData_3D(m_pVerticesForRender,vNum,m_pLEPIndices,cur,0x80ff0000);		//ɫȾ
		


	}
	else
	{
		//pSpecialPatchΪգ
		//ȫƣ
		for(i=0;i<m_listPatches.GetCount();i++)
		{
			pCurPatch=m_listPatches.GetNext(CurPatchPos);
			//СƬҲ

			AArray<VPNeighbor,VPNeighbor>& Neighbors=pCurPatch->GetNeighbors();
			assert(Neighbors.GetSize()>=3);
			for(j=2;j<Neighbors.GetSize();j++)
			{
				
				//
				m_pIndices[cur]=Neighbors[0].vid;			//v1ʼΪԪ
				m_pIndices[cur+1]=Neighbors[j-1].vid;		//v2ΪһԪ
				m_pIndices[cur+2]=Neighbors[j].vid;		//v3ΪǰԪ
				cur+=3;
			}

		}
		//
		pFC->AddRenderData_3D(m_pVerticesForRender,vNum,m_pIndices,cur,dwColor);	

	}

	pFC->Flush();
}

//ɾһСƬΪϵͳԶʱʹ
bool CConvexPolytope::RemoveLeastErrorPatch()
{
	//ѰСɾӦƬ
	SearchLeastErrorPatch();
	if(!m_pCurLeastErrorPatch)
		return false;

	return RemovePatch(m_pCurLeastErrorPatch);
	
	/*
	//²⣡wf04-12-2
	//µĲԣǰСƬɾʧܣѰҼɾ
	
	while(!RemovePatch(m_pCurLeastErrorPatch))				
	{
		if(SearchLeastErrorPatch()==NULL)		//һСɾƬ
			return false;						//޷ҵ		
	}
	//ɾƬɹ
	return true;
	//*/
	
}

CPatch* CConvexPolytope::SearchLeastErrorPatch()
{
	int PatchNum=m_listPatches.GetCount();
	if(PatchNum<=4)
	{
		//Сڵ4ڽмˣ
		m_pCurLeastErrorPatch= NULL;
		return NULL;			
	}


	//Сpatch
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	CPatch *pCurPatch,*pLeastErrorPatch;
	float LeastError=MAX_ERROR;			//ʼΪһֵ
	for(int i=0;i<PatchNum;i++)
	{
		pCurPatch=m_listPatches.GetNext(CurPatchPos);
		float error=pCurPatch->GetRemovedError();
		if(error!=-1.0f && error<LeastError)
		{
			LeastError=pCurPatch->GetRemovedError();
			pLeastErrorPatch=pCurPatch;
		
			// DEBUGGING
			//char buffer[100];
			//sprintf(buffer, "Least Error (%d): %f\n", i, error);
			//OutputDebugString(&buffer[0]);
			// DEBUGGING END
		}
	}

	
	if(LeastError!=MAX_ERROR)			//ӦΪڵ0
		m_pCurLeastErrorPatch=pLeastErrorPatch;
		
	else	//˵ûСɾ
		m_pCurLeastErrorPatch= NULL;

	return m_pCurLeastErrorPatch;
}

//Ѿеɾ
//ûκɾҲtrue!
bool CConvexPolytope::UndoAll()
{
	//if(m_arrRemoveOperatorRecords.GetSize()==0)
	//	return true;

	if(m_nCurOperator==-1)		//˵ͷ
		return true;
	else 
		return false;
}

//Ѿָеɾ
bool CConvexPolytope::RedoAll()
{
	return (m_nCurOperator==m_arrRemoveOperatorRecords.GetSize()-1);
}

// ֱ򻯺ĳһ
// LeftPatchesNumָʾʣµƬ򻯲
bool CConvexPolytope::Goto(int LeftPatchesNum)
{
	if(LeftPatchesNum<m_nMinPatchNum || LeftPatchesNum> m_nOriginPatchNum )
		return false;
	int i;
	int RemovedPatchesNum=m_nOriginPatchNum-LeftPatchesNum;
	int UnRemoveTimes=m_nCurOperator+1-RemovedPatchesNum;
	if(UnRemoveTimes>0)
	{
		for(i=0;i<UnRemoveTimes;i++)
			UndoRemove();
	}
	else
	{
		for(i=0;i<-UnRemoveTimes;i++)
			RedoRemove();
	}
		// DEBUGGING
		//ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
		//for(int i = 0; i < m_listPatches.GetCount(); i++)
		//{
		//	CPatch* pPatch = m_listPatches.GetNext(CurPatchPos);
		//	char buffer[100];
		//	sprintf(buffer, "Patch GOTO (%d): %f (%f, %f, %f) Err: %f\n", i, pPatch->m_d, pPatch->m_vNormal.x,pPatch->m_vNormal.y,pPatch->m_vNormal.z, pPatch->GetRemovedError() );
		//	OutputDebugString(&buffer[0]);

		//	for(int jj = 0; jj < pPatch->GetNeighborCount(); jj++ )
		//	{
		//		sprintf(buffer, "\tNeighbor: %d\n", pPatch->GetNeighbors().GetAt(jj).vid);
		//		OutputDebugString(&buffer[0]);
		//	}
		//}
		// DEBUGGING END

	return true;
}

//СƬΪƬʱĻƣֱӵRender(...)
void CConvexPolytope::RenderLEPatchSpecial(A3DFlatCollector *pFC, A3DMATRIX4 &tMatrix, DWORD dwColor)
{
	Render(pFC,tMatrix,dwColor,m_pCurLeastErrorPatch);
}

void CConvexPolytope::ReduceAll()
{
	int curPatchNum=m_nOriginPatchNum;
	do{
		// DEBUGGING
		//ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
		//for(int i = 0; i < m_listPatches.GetCount(); i++)
		//{
		//	CPatch* pPatch = m_listPatches.GetNext(CurPatchPos);
		//	char buffer[100];
		//	sprintf(buffer, "Patch Updated (%d): %f (%f, %f, %f) Err: %f\n", i, pPatch->m_d, pPatch->m_vNormal.x,pPatch->m_vNormal.y,pPatch->m_vNormal.z, pPatch->GetRemovedError() );
		//	OutputDebugString(&buffer[0]);
		//}
		// DEBUGGING END

		m_fArrRemovedError[curPatchNum]=GetCurLeastError()/m_fErrorBase;
		curPatchNum--;
	}while(RemoveLeastErrorPatch());
	
	m_nMinPatchNum=++curPatchNum;

	if(curPatchNum<4)		//ܱ4٣
		m_bExceptionOccur=true;
}

void CConvexPolytope::Goto(float fError)
{
	if(fError<0) return;
	int LeftPatchesNum=GetLPNByError(fError);
	Goto(LeftPatchesNum);
}

int CConvexPolytope::GetLPNByError(float fError)
{
	int i=m_nOriginPatchNum;
	//Ϊ  //ֲ
	while(m_fArrRemovedError[i]<fError && i > m_nMinPatchNum)
		i--;
	/*
		i>>=1;		//ȼi/=2
	while(m_fArrRemovedError[i]>fError)
		i++;
	*/
	return i;
}

//򻯺õݵCConvexHullData
void CConvexPolytope::ExportCHData(CConvexHullData* pCHData)
{
	AArray<int,int> Map;		//һɶڱidCConvexHullDataidһӳ
	
	//ÿһPatch
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	CPatch *pCurPatch;
	for(int i=0;i<m_listPatches.GetCount();i++)
	{
		pCurPatch=m_listPatches.GetNext(CurPatchPos);
		A3DVECTOR3 n=pCurPatch->GetNormal();
		CFace face;
		face.SetNormal(n);
		face.SetD(pCurPatch->GetDist());
		
		CHalfSpace hs;
		for(int j=0;j<pCurPatch->GetVNum();j++)
		{
			int vid=pCurPatch->GetVID(j);
			
			//촹ֱڸñ߷HalfSpace
			A3DVECTOR3 v1,v2;
			pCurPatch->GetEdge(j,v1,v2);
			hs.Set(v1,v2,v2+n);
			
			// for debug, by wenfeng, 05-04-08
			float d = face.DistV2Plane(v1);

			int ExistID;
			if((ExistID=FindInArray(vid,Map))==-1)
			{
				//˵µĶ

				//뵽CConvexHullDataVertices
				pCHData->AddVertex(v1);
				int newID=pCHData->GetVertexNum()-1;	//pCHDataеid
				face.AddElement(newID,hs);
				
				Map.Add(vid);
			}
			else
			{
				//˵ѾڵĶ
				face.AddElement(ExistID,hs);
			}
		}

		//Ƭ
		pCHData->AddFace(face);
		
	}
	
	// ߽ռ
	pCHData->ComputeFaceExtraHS();

}

int FindInArray(int id,const AArray<int,int>& arr)
{
	for(int i=0;i<arr.GetSize();i++)
		if(arr[i]==id)
			return i;
	return -1;
}

//Verticesв벻ظĵ
void AddDifferentV(AArray<A3DVECTOR3,A3DVECTOR3>& Vertices, A3DVECTOR3& v)
{
	A3DVECTOR3 vDiff;
	for(int i=0;i<Vertices.GetSize();i++)
	{
		vDiff=Vertices[i]-v;
		if(vDiff.SquaredMagnitude()<1e-6f)			//˵кvظĵ㣡˲κβ
			return;
	}
	Vertices.Add(v);
}

//͹ƽཻõĽͶӰXOZƽ湹ɵ2D͹
//Ҫƽ淨ֱܴYᣬƽ治YƽУһģǵƽ涼ֱY
//2򷵻false
//gw2dЩ㹹ɵ2D͹ͶӰXOZƽ
//ͨb2ParallelPlanesǷΪƽƽصõĲֵ2D͹
bool CConvexPolytope::IntersectPlanesProj2XOZ(CHalfSpace* Planes,int PlaneNum,C2DGiftWrap& gw2d,bool b2ParallelPlanes)
{
	A3DVECTOR3 n1,n2;
	if (b2ParallelPlanes) 
	{
		//ƽƬ͹
		if(PlaneNum!=2) return false;
		n1=Planes[0].GetNormal();
		n2=Planes[1].GetNormal();
		if(!(n1==n2 || n1==-n2))
			return false;
	}
	
	if (PlaneNum<1) return false;

	int i,j,k;
	//жPlanesķ
	for(i=0;i<PlaneNum;i++)
	{
		//ƽYļнΪ30 degree
		//ֵɵ
		if (ABS(Planes[i].GetNormal().y)<0.5f) 
		{
			return false;
		}
	}

	//ʼ
	AArray<A3DVECTOR3,A3DVECTOR3> Vertices;		//ŽĶ㼯
	//ÿһƬ
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	CPatch *pCurPatch;
	for(i=0;i<m_listPatches.GetCount();i++)
	{
		pCurPatch=m_listPatches.GetNext(CurPatchPos);
		A3DVECTOR3 v1,v2;
		//߽п
		for(k=0;k<pCurPatch->GetVNum();k++)
		{
			pCurPatch->GetEdge(k,v1,v2);
			for(j=0;j<PlaneNum;j++)
			{
				A3DVECTOR3 vI;
				int res=Planes[j].IntersectLineSeg(v1,v2,vI);
				switch(res) {
				case 0:
					break;
				case 1:
					AddDifferentV(Vertices,v1);
					break;
				case 2:
					AddDifferentV(Vertices,v2);
					break;
				case 3:
					AddDifferentV(Vertices,v1);
					AddDifferentV(Vertices,v2);
					break;
				case 4:
					AddDifferentV(Vertices,vI);
					break;
				default:
					break;
				}
			}
		}

	}
	
	if (b2ParallelPlanes) 
	{
		//ӱ͹ƽĶ
		if(n1==-n2)
			Planes[1].Inverse();	//P2תʹP1,P2ͬ
		
		//Ч
		for(int i=0;i<m_nCurVNum;i++)
			if(m_arrVertexInfo[i].cDegree>=3) 		//Ч
				if(Planes[0].Outside(m_arrVertecies[i]) && Planes[1].Inside(m_arrVertecies[i]) ||
				   Planes[0].Inside(m_arrVertecies[i])  && Planes[1].Outside(m_arrVertecies[i]))
				   Vertices.Add(m_arrVertecies[i]);
	}

	//ϣʼ2D͹
	int vNum=Vertices.GetSize();
	if (vNum<3) return false;

	A3DVECTOR3* Vs=new A3DVECTOR3[vNum];
	for(i=0;i<vNum;i++)
		Vs[i]=Vertices[i];

	gw2d.SetVertexes(Vs,vNum);
	gw2d.ComputeConvexHull();
	delete [] Vs;
	return true;
}

//ж϶Ƿ͹֮
bool CConvexPolytope::IsVertexOutside(A3DVECTOR3 v,float fInflateRadius)
{
	CHalfSpace hs;
	//ÿһƬ
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	CPatch *pCurPatch;
	for(int i=0;i<m_listPatches.GetCount();i++)
	{
		pCurPatch=m_listPatches.GetNext(CurPatchPos);		
		hs.SetNormal(pCurPatch->GetNormal());
		hs.SetD(pCurPatch->GetDist()+fInflateRadius);
		if(hs.Outside(v))
			return true;
	}
	return false;
}

//ж϶Ƿ͹֮
bool CConvexPolytope::IsVertexInside(A3DVECTOR3 v, float fInflateRadius)
{
	CHalfSpace hs;
	//ÿһƬ
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	CPatch *pCurPatch;
	for(int i=0;i<m_listPatches.GetCount();i++)
	{
		pCurPatch=m_listPatches.GetNext(CurPatchPos);		
		hs.SetNormal(pCurPatch->GetNormal());
		hs.SetD(pCurPatch->GetDist()+fInflateRadius);
		if(!hs.Inside(v))
			return false;
	}
	return true;
}

//vǷĳ߽ƽϣ
CPatch* CConvexPolytope::IsVertexOnPatch(A3DVECTOR3 v, float fInflateRadius)
{
	CHalfSpace hs;
	//ÿһƬ
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	CPatch *pCurPatch;
	for(int i=0;i<m_listPatches.GetCount();i++)
	{
		pCurPatch=m_listPatches.GetNext(CurPatchPos);		
		hs.SetNormal(pCurPatch->GetNormal());
		hs.SetD(pCurPatch->GetDist()+fInflateRadius);
		//wf04.12.25ƺ⣬Ϊƽϲһнƽ
		if(hs.OnPlane(v))
			return pCurPatch;
	}
	return NULL;
	
}

A3DAABB CConvexPolytope::GetAABB()
{
	A3DAABB aabb;
	aabb.Clear();
	for(int i=0; i<m_nCurVNum; i++)
	{
		//ֻǶ벻С3Ķ
		if(m_arrVertexInfo[i].cDegree<3) continue;
		
		aabb.AddVertex(m_arrVertecies[i]);
	}
	aabb.CompleteCenterExts();
	return aabb;
}

}	// end namespace