// CombGenerator.cpp: implementation of the CCombGenerator class.
//
//////////////////////////////////////////////////////////////////////

#include "CombGenerator.h"
#include <memory.h>

#ifndef NULL
#define NULL 0


namespace CHBasedCD
{

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCombGenerator::CCombGenerator(int nn,int mm)
{
	Set(nn,mm);
}

CCombGenerator::~CCombGenerator()
{
	if(m_pData) delete [] m_pData;
}

void CCombGenerator::Set(int nn, int mm)
{
	n=nn;
	m=mm;

	if(n<=0 || m<=0 || n>m )
	{
		//޽
		m_bSolvable=false;
		m_pData=NULL;
		return;
	}

	m_pData=new int[n];			//ռ

	for(int i=0;i<n;i++)		//ʼõ˵һ 0,1,2,...,n-1
		m_pData[i]=i;			

	m_bOver=false;
}

//////////////////////////////////////////////////////////////////////
// ĺķ
// ǰϴpDataͬʱһ
// ҪpDataڵѾʼΪΪnһ
//////////////////////////////////////////////////////////////////////
void CCombGenerator::GetNextComb(int *pData)
{
	//ǰ
	memcpy(pData,m_pData,n*sizeof(int));

	if(IsOver()) return;

	int CarryPos=n-1;		//λλã
	//һ
	int i(0);
	for(i=n-1;i>=0;i--)
	{
		if(m_pData[i]==m-n+i)			//ǰλѾﵽֵ1Ҫλ˼¼λλΪһλ
			CarryPos=i-1;
		else
			break;
	}

	if(CarryPos==-1)
	{
		m_bOver=true;		//е϶Ѳϣ
		return;				//λλ-1˵ѾеϣҲٽλˣֱӷأ
	}

	m_pData[CarryPos]++;					//λ1

	int nValue=m_pData[CarryPos]+1;
	for(i=CarryPos+1;i<n;i++)				//λλֵλΪk,Ϊk+1,k+2,...
	{
		m_pData[i]=nValue;
		nValue++;
	}

}

}	// end namespace

#endif	//NULL
