// 2DGiftWrap.cpp: implementation of the C2DGiftWrap class.
//
//////////////////////////////////////////////////////////////////////

#include "2DGiftWrap.h"
#include "2DObstruct.h"

#include <vector.h>
using namespace abase;

namespace CHBasedCD
{

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

C2DGiftWrap::C2DGiftWrap()
{
	m_pVertexes=NULL;
}

C2DGiftWrap::~C2DGiftWrap()
{
	if(m_pVertexes) delete [] m_pVertexes;
}

void C2DGiftWrap::SetVertexes(A3DVECTOR3* pVertexes,int vNum)
{

	//ǰѾݣͷ
	if(m_pVertexes)	delete [] m_pVertexes;
	
	CConvexHullAlgorithm::SetVertexes(pVertexes,vNum);

	//ݿڲ
	m_pVertexes=new A3DVECTOR3[vNum];
	memcpy(m_pVertexes,pVertexes,vNum*sizeof(A3DVECTOR3));

	//㣬ʵֶƽϵ㼯͹

	//öYΪ0.0f;
	for(int i=0;i<vNum;i++)
		m_pVertexes[i].y=0.0f;
	

}

void C2DGiftWrap::SetVertexes(float* Xs,float* Zs,int vNum)
{
	//ǰѾݣͷ
	if(m_pVertexes)	delete [] m_pVertexes;	

	CConvexHullAlgorithm::SetVertexes(NULL,vNum);
	
	m_pVertexes=new A3DVECTOR3[vNum];
	for(int i=0;i<vNum;i++)
	{
		m_pVertexes[i].x=Xs[i];
		m_pVertexes[i].y=0.0f;
		m_pVertexes[i].z=Zs[i];
	}

}

void C2DGiftWrap::ComputeConvexHull()
{
	//HalfSpaceĹֵ	
	float hsDistThresh=1e-1f;
		
	//֤û쳣͹
	do{
		hsDistThresh*=0.1f;							//Ŵֵ10
		CHalfSpace::SetDistThresh(hsDistThresh);	//ֵ

		//ȵøຯӶղ
		CConvexHullAlgorithm::ComputeConvexHull();
		ResetSameVertices();

		//Ѱҵһ
		Edge e=SearchFirstEdge();
		m_eFirst=e;

		//ڶǹˣҪѹջȴˣ
		
		//ñ
		DealE(e);

	}while(m_bExceptionOccur && hsDistThresh>5e-7);

	if(hsDistThresh<5e-7f)
	{
		//˵ѾֵΧ쳣
		//˵ȷʵģ͵͹Ǽ쳣
		m_bExceptionOccur=true;
	}

	//m_Planesб2D͹ĶϢ
	
	//ձջ
	m_EdgeStack.Clear();
	
	CHalfSpace::SetDistThresh();  //ָȱʡֵ

}

void C2DGiftWrap::Export2DObstruct(C2DObstruct* p2DObstruct)
{
	AArray<int,int>* pBaseFaceVIDs=GetCHVertecies();
	if(!pBaseFaceVIDs) return ;

	vector<A3DVECTOR3> Vertices(pBaseFaceVIDs->GetSize(), A3DVECTOR3(0.0f, 0.0f, 0.0f));
	for(int i=0;i<pBaseFaceVIDs->GetSize();i++)
		Vertices[i]=m_pVertexes[pBaseFaceVIDs->GetAt(i)];

	p2DObstruct->Init(Vertices);
	
}


}	// end namespace