//-------------------------------------------------------------------------//
//  VisualStyle Style Guide symbols
//-------------------------------------------------------------------------//

#ifndef __BCGPVSSTYLE_H__
#define __BCGPVSSTYLE_H__

#ifndef TMSCHEMA_H
#ifndef __VSSYM32_H__

//
//  property symbol definitions
//

#define TMTVS_RESERVEDLOW	100000
#define TMTVS_RESERVEDHIGH	19999



//
//  AEROWIZARDSTYLE class parts and states 
//
#define VSCLASS_AEROWIZARDSTYLE	L"AEROWIZARDSTYLE"
#define VSCLASS_AEROWIZARD	L"AEROWIZARD"

enum AEROWIZARDPARTS {
	AW_TITLEBAR = 1,
	AW_HEADERAREA = 2,
	AW_CONTENTAREA = 3,
	AW_COMMANDAREA = 4,
	AW_BUTTON = 5,
};

#define AEROWIZARDSTYLEPARTS AEROWIZARDPARTS;

enum TITLEBARSTATES {
	AW_S_TITLEBAR_ACTIVE = 1,
	AW_S_TITLEBAR_INACTIVE = 2,
};

enum HEADERAREASTATES {
	AW_S_HEADERAREA_NOMARGIN = 1,
};

enum CONTENTAREASTATES {
	AW_S_CONTENTAREA_NOMARGIN = 1,
};


//
//  BUTTONSTYLE class parts and states 
//
#define VSCLASS_BUTTONSTYLE	L"BUTTONSTYLE"
#define VSCLASS_BUTTON	L"BUTTON"

enum BUTTONPARTS {
	BP_PUSHBUTTON = 1,
	BP_RADIOBUTTON = 2,
	BP_CHECKBOX = 3,
	BP_GROUPBOX = 4,
	BP_USERBUTTON = 5,
	BP_COMMANDLINK = 6,
	BP_COMMANDLINKGLYPH = 7,
};

#define BUTTONSTYLEPARTS BUTTONPARTS;

enum PUSHBUTTONSTATES {
	PBS_NORMAL = 1,
	PBS_HOT = 2,
	PBS_PRESSED = 3,
	PBS_DISABLED = 4,
	PBS_DEFAULTED = 5,
	PBS_DEFAULTED_ANIMATING = 6,
};

enum RADIOBUTTONSTATES {
	RBS_UNCHECKEDNORMAL = 1,
	RBS_UNCHECKEDHOT = 2,
	RBS_UNCHECKEDPRESSED = 3,
	RBS_UNCHECKEDDISABLED = 4,
	RBS_CHECKEDNORMAL = 5,
	RBS_CHECKEDHOT = 6,
	RBS_CHECKEDPRESSED = 7,
	RBS_CHECKEDDISABLED = 8,
};

enum CHECKBOXSTATES {
	CBS_UNCHECKEDNORMAL = 1,
	CBS_UNCHECKEDHOT = 2,
	CBS_UNCHECKEDPRESSED = 3,
	CBS_UNCHECKEDDISABLED = 4,
	CBS_CHECKEDNORMAL = 5,
	CBS_CHECKEDHOT = 6,
	CBS_CHECKEDPRESSED = 7,
	CBS_CHECKEDDISABLED = 8,
	CBS_MIXEDNORMAL = 9,
	CBS_MIXEDHOT = 10,
	CBS_MIXEDPRESSED = 11,
	CBS_MIXEDDISABLED = 12,
	CBS_IMPLICITNORMAL = 13,
	CBS_IMPLICITHOT = 14,
	CBS_IMPLICITPRESSED = 15,
	CBS_IMPLICITDISABLED = 16,
	CBS_EXCLUDEDNORMAL = 17,
	CBS_EXCLUDEDHOT = 18,
	CBS_EXCLUDEDPRESSED = 19,
	CBS_EXCLUDEDDISABLED = 20,
};

enum GROUPBOXSTATES {
	GBS_NORMAL = 1,
	GBS_DISABLED = 2,
};

enum COMMANDLINKSTATES {
	CMDLS_NORMAL = 1,
	CMDLS_HOT = 2,
	CMDLS_PRESSED = 3,
	CMDLS_DISABLED = 4,
	CMDLS_DEFAULTED = 5,
	CMDLS_DEFAULTED_ANIMATING = 6,
};

enum COMMANDLINKGLYPHSTATES {
	CMDLGS_NORMAL = 1,
	CMDLGS_HOT = 2,
	CMDLGS_PRESSED = 3,
	CMDLGS_DISABLED = 4,
	CMDLGS_DEFAULTED = 5,
};


//
//  COMBOBOXSTYLE class parts and states 
//
#define VSCLASS_COMBOBOXSTYLE	L"COMBOBOXSTYLE"
#define VSCLASS_COMBOBOX	L"COMBOBOX"

enum COMBOBOXPARTS {
	CP_DROPDOWNBUTTON = 1,
	CP_BACKGROUND = 2,
	CP_TRANSPARENTBACKGROUND = 3,
	CP_BORDER = 4,
	CP_READONLY = 5,
	CP_DROPDOWNBUTTONRIGHT = 6,
	CP_DROPDOWNBUTTONLEFT = 7,
	CP_CUEBANNER = 8,
};

#define COMBOBOXSTYLEPARTS COMBOBOXPARTS;

enum COMBOBOXSTYLESTATES {
	CBXS_NORMAL = 1,
	CBXS_HOT = 2,
	CBXS_PRESSED = 3,
	CBXS_DISABLED = 4,
};

enum DROPDOWNBUTTONRIGHTSTATES {
	CBXSR_NORMAL = 1,
	CBXSR_HOT = 2,
	CBXSR_PRESSED = 3,
	CBXSR_DISABLED = 4,
};

enum DROPDOWNBUTTONLEFTSTATES {
	CBXSL_NORMAL = 1,
	CBXSL_HOT = 2,
	CBXSL_PRESSED = 3,
	CBXSL_DISABLED = 4,
};

enum TRANSPARENTBACKGROUNDSTATES {
	CBTBS_NORMAL = 1,
	CBTBS_HOT = 2,
	CBTBS_DISABLED = 3,
	CBTBS_FOCUSED = 4,
};

enum BORDERSTATES {
	CBB_NORMAL = 1,
	CBB_HOT = 2,
	CBB_FOCUSED = 3,
	CBB_DISABLED = 4,
};

enum READONLYSTATES {
	CBRO_NORMAL = 1,
	CBRO_HOT = 2,
	CBRO_PRESSED = 3,
	CBRO_DISABLED = 4,
};

enum CUEBANNERSTATES {
	CBCB_NORMAL = 1,
	CBCB_HOT = 2,
	CBCB_PRESSED = 3,
	CBCB_DISABLED = 4,
};


//
//  COMMUNICATIONSSTYLE class parts and states 
//
#define VSCLASS_COMMUNICATIONSSTYLE	L"COMMUNICATIONSSTYLE"
#define VSCLASS_COMMUNICATIONS	L"COMMUNICATIONS"

enum COMMUNICATIONSPARTS {
	CSST_TAB = 1,
};

#define COMMUNICATIONSSTYLEPARTS COMMUNICATIONSPARTS;

enum TABSTATES {
	CSTB_NORMAL = 1,
	CSTB_HOT = 2,
	CSTB_SELECTED = 3,
};


//
//  CONTROLPANELSTYLE class parts and states 
//
#define VSCLASS_CONTROLPANELSTYLE	L"CONTROLPANELSTYLE"
#define VSCLASS_CONTROLPANEL	L"CONTROLPANEL"

enum CONTROLPANELPARTS {
	CPANEL_NAVIGATIONPANE = 1,
	CPANEL_CONTENTPANE = 2,
	CPANEL_NAVIGATIONPANELABEL = 3,
	CPANEL_CONTENTPANELABEL = 4,
	CPANEL_TITLE = 5,
	CPANEL_BODYTEXT = 6,
	CPANEL_HELPLINK = 7,
	CPANEL_TASKLINK = 8,
	CPANEL_GROUPTEXT = 9,
	CPANEL_CONTENTLINK = 10,
	CPANEL_SECTIONTITLELINK = 11,
	CPANEL_LARGECOMMANDAREA = 12,
	CPANEL_SMALLCOMMANDAREA = 13,
	CPANEL_BUTTON = 14,
	CPANEL_MESSAGETEXT = 15,
	CPANEL_NAVIGATIONPANELINE = 16,
	CPANEL_CONTENTPANELINE = 17,
	CPANEL_BANNERAREA = 18,
	CPANEL_BODYTITLE = 19,
};

#define CONTROLPANELSTYLEPARTS CONTROLPANELPARTS;

enum HELPLINKSTATES {
	CPHL_NORMAL = 1,
	CPHL_HOT = 2,
	CPHL_PRESSED = 3,
	CPHL_DISABLED = 4,
};

enum TASKLINKSTATES {
	CPTL_NORMAL = 1,
	CPTL_HOT = 2,
	CPTL_PRESSED = 3,
	CPTL_DISABLED = 4,
	CPTL_PAGE = 5,
};

enum CONTENTLINKSTATES {
	CPCL_NORMAL = 1,
	CPCL_HOT = 2,
	CPCL_PRESSED = 3,
	CPCL_DISABLED = 4,
};

enum SECTIONTITLELINKSTATES {
	CPSTL_NORMAL = 1,
	CPSTL_HOT = 2,
};


//
//  DATEPICKERSTYLE class parts and states 
//
#define VSCLASS_DATEPICKERSTYLE	L"DATEPICKERSTYLE"
#define VSCLASS_DATEPICKER	L"DATEPICKER"

enum DATEPICKERPARTS {
	DP_DATETEXT = 1,
	DP_DATEBORDER = 2,
	DP_SHOWCALENDARBUTTONRIGHT = 3,
};

#define DATEPICKERSTYLEPARTS DATEPICKERPARTS;

enum DATETEXTSTATES {
	DPDT_NORMAL = 1,
	DPDT_DISABLED = 2,
	DPDT_SELECTED = 3,
};

enum DATEBORDERSTATES {
	DPDB_NORMAL = 1,
	DPDB_HOT = 2,
	DPDB_FOCUSED = 3,
	DPDB_DISABLED = 4,
};

enum SHOWCALENDARBUTTONRIGHTSTATES {
	DPSCBR_NORMAL = 1,
	DPSCBR_HOT = 2,
	DPSCBR_PRESSED = 3,
	DPSCBR_DISABLED = 4,
};


//
//  DRAGDROPSTYLE class parts and states 
//
#define VSCLASS_DRAGDROPSTYLE	L"DRAGDROPSTYLE"
#define VSCLASS_DRAGDROP	L"DRAGDROP"

enum DRAGDROPPARTS {
	DD_COPY = 1,
	DD_MOVE = 2,
	DD_UPDATEMETADATA = 3,
	DD_CREATELINK = 4,
	DD_WARNING = 5,
	DD_NONE = 6,
	DD_IMAGEBG = 7,
	DD_TEXTBG = 8,
};

#define DRAGDROPSTYLEPARTS DRAGDROPPARTS;

enum COPYSTATES {
	DDCOPY_HIGHLIGHT = 1,
	DDCOPY_NOHIGHLIGHT = 2,
};

enum MOVESTATES {
	DDMOVE_HIGHLIGHT = 1,
	DDMOVE_NOHIGHLIGHT = 2,
};

enum UPDATEMETADATASTATES {
	DDUPDATEMETADATA_HIGHLIGHT = 1,
	DDUPDATEMETADATA_NOHIGHLIGHT = 2,
};

enum CREATELINKSTATES {
	DDCREATELINK_HIGHLIGHT = 1,
	DDCREATELINK_NOHIGHLIGHT = 2,
};

enum WARNINGSTATES {
	DDWARNING_HIGHLIGHT = 1,
	DDWARNING_NOHIGHLIGHT = 2,
};

enum NONESTATES {
	DDNONE_HIGHLIGHT = 1,
	DDNONE_NOHIGHLIGHT = 2,
};


//
//  EDITSTYLE class parts and states 
//
#define VSCLASS_EDITSTYLE	L"EDITSTYLE"
#define VSCLASS_EDIT	L"EDIT"

enum EDITPARTS {
	EP_EDITTEXT = 1,
	EP_CARET = 2,
	EP_BACKGROUND = 3,
	EP_PASSWORD = 4,
	EP_BACKGROUNDWITHBORDER = 5,
	EP_EDITBORDER_NOSCROLL = 6,
	EP_EDITBORDER_HSCROLL = 7,
	EP_EDITBORDER_VSCROLL = 8,
	EP_EDITBORDER_HVSCROLL = 9,
};

#define EDITSTYLEPARTS EDITPARTS;

enum EDITTEXTSTATES {
	ETS_NORMAL = 1,
	ETS_HOT = 2,
	ETS_SELECTED = 3,
	ETS_DISABLED = 4,
	ETS_FOCUSED = 5,
	ETS_READONLY = 6,
	ETS_ASSIST = 7,
	ETS_CUEBANNER = 8,
};

enum BACKGROUNDSTATES {
	EBS_NORMAL = 1,
	EBS_HOT = 2,
	EBS_DISABLED = 3,
	EBS_FOCUSED = 4,
	EBS_READONLY = 5,
	EBS_ASSIST = 6,
};

enum BACKGROUNDWITHBORDERSTATES {
	EBWBS_NORMAL = 1,
	EBWBS_HOT = 2,
	EBWBS_DISABLED = 3,
	EBWBS_FOCUSED = 4,
};

enum EDITBORDER_NOSCROLLSTATES {
	EPSN_NORMAL = 1,
	EPSN_HOT = 2,
	EPSN_FOCUSED = 3,
	EPSN_DISABLED = 4,
};

enum EDITBORDER_HSCROLLSTATES {
	EPSH_NORMAL = 1,
	EPSH_HOT = 2,
	EPSH_FOCUSED = 3,
	EPSH_DISABLED = 4,
};

enum EDITBORDER_VSCROLLSTATES {
	EPSV_NORMAL = 1,
	EPSV_HOT = 2,
	EPSV_FOCUSED = 3,
	EPSV_DISABLED = 4,
};

enum EDITBORDER_HVSCROLLSTATES {
	EPSHV_NORMAL = 1,
	EPSHV_HOT = 2,
	EPSHV_FOCUSED = 3,
	EPSHV_DISABLED = 4,
};


//
//  EXPLORERBARSTYLE class parts and states 
//
#define VSCLASS_EXPLORERBARSTYLE	L"EXPLORERBARSTYLE"
#define VSCLASS_EXPLORERBAR	L"EXPLORERBAR"

enum EXPLORERBARPARTS {
	EBP_HEADERBACKGROUND = 1,
	EBP_HEADERCLOSE = 2,
	EBP_HEADERPIN = 3,
	EBP_IEBARMENU = 4,
	EBP_NORMALGROUPBACKGROUND = 5,
	EBP_NORMALGROUPCOLLAPSE = 6,
	EBP_NORMALGROUPEXPAND = 7,
	EBP_NORMALGROUPHEAD = 8,
	EBP_SPECIALGROUPBACKGROUND = 9,
	EBP_SPECIALGROUPCOLLAPSE = 10,
	EBP_SPECIALGROUPEXPAND = 11,
	EBP_SPECIALGROUPHEAD = 12,
};

#define EXPLORERBARSTYLEPARTS EXPLORERBARPARTS;

enum HEADERCLOSESTATES {
	EBHC_NORMAL = 1,
	EBHC_HOT = 2,
	EBHC_PRESSED = 3,
};

enum HEADERPINSTATES {
	EBHP_NORMAL = 1,
	EBHP_HOT = 2,
	EBHP_PRESSED = 3,
	EBHP_SELECTEDNORMAL = 4,
	EBHP_SELECTEDHOT = 5,
	EBHP_SELECTEDPRESSED = 6,
};

enum IEBARMENUSTATES {
	EBM_NORMAL = 1,
	EBM_HOT = 2,
	EBM_PRESSED = 3,
};

enum NORMALGROUPCOLLAPSESTATES {
	EBNGC_NORMAL = 1,
	EBNGC_HOT = 2,
	EBNGC_PRESSED = 3,
};

enum NORMALGROUPEXPANDSTATES {
	EBNGE_NORMAL = 1,
	EBNGE_HOT = 2,
	EBNGE_PRESSED = 3,
};

enum SPECIALGROUPCOLLAPSESTATES {
	EBSGC_NORMAL = 1,
	EBSGC_HOT = 2,
	EBSGC_PRESSED = 3,
};

enum SPECIALGROUPEXPANDSTATES {
	EBSGE_NORMAL = 1,
	EBSGE_HOT = 2,
	EBSGE_PRESSED = 3,
};


//
//  FLYOUTSTYLE class parts and states 
//
#define VSCLASS_FLYOUTSTYLE	L"FLYOUTSTYLE"
#define VSCLASS_FLYOUT	L"FLYOUT"

enum FLYOUTPARTS {
	FLYOUT_HEADER = 1,
	FLYOUT_BODY = 2,
	FLYOUT_LABEL = 3,
	FLYOUT_LINK = 4,
	FLYOUT_DIVIDER = 5,
	FLYOUT_WINDOW = 6,
	FLYOUT_LINKAREA = 7,
	FLYOUT_LINKHEADER = 8,
};

#define FLYOUTSTYLEPARTS FLYOUTPARTS;

enum LABELSTATES {
	FLS_NORMAL = 1,
	FLS_SELECTED = 2,
	FLS_EMPHASIZED = 3,
	FLS_DISABLED = 4,
};

enum LINKSTATES {
	FLYOUTLINK_NORMAL = 1,
	FLYOUTLINK_HOVER = 2,
};

enum BODYSTATES {
	FBS_NORMAL = 1,
	FBS_EMPHASIZED = 2,
};

enum LINKHEADERSTATES {
	FLH_NORMAL = 1,
	FLH_HOVER = 2,
};


//
//  HEADERSTYLE class parts and states 
//
#define VSCLASS_HEADERSTYLE	L"HEADERSTYLE"
#define VSCLASS_HEADER	L"HEADER"

enum HEADERPARTS {
	HP_HEADERITEM = 1,
	HP_HEADERITEMLEFT = 2,
	HP_HEADERITEMRIGHT = 3,
	HP_HEADERSORTARROW = 4,
	HP_HEADERDROPDOWN = 5,
	HP_HEADERDROPDOWNFILTER = 6,
	HP_HEADEROVERFLOW = 7,
};

#define HEADERSTYLEPARTS HEADERPARTS;

enum HEADERSTYLESTATES {
	HBG_DETAILS = 1,
	HBG_ICON = 2,
};

enum HEADERITEMSTATES {
	HIS_NORMAL = 1,
	HIS_HOT = 2,
	HIS_PRESSED = 3,
	HIS_SORTEDNORMAL = 4,
	HIS_SORTEDHOT = 5,
	HIS_SORTEDPRESSED = 6,
	HIS_ICONNORMAL = 7,
	HIS_ICONHOT = 8,
	HIS_ICONPRESSED = 9,
	HIS_ICONSORTEDNORMAL = 10,
	HIS_ICONSORTEDHOT = 11,
	HIS_ICONSORTEDPRESSED = 12,
};

enum HEADERITEMLEFTSTATES {
	HILS_NORMAL = 1,
	HILS_HOT = 2,
	HILS_PRESSED = 3,
};

enum HEADERITEMRIGHTSTATES {
	HIRS_NORMAL = 1,
	HIRS_HOT = 2,
	HIRS_PRESSED = 3,
};

enum HEADERSORTARROWSTATES {
	HSAS_SORTEDUP = 1,
	HSAS_SORTEDDOWN = 2,
};

enum HEADERDROPDOWNSTATES {
	HDDS_NORMAL = 1,
	HDDS_SOFTHOT = 2,
	HDDS_HOT = 3,
};

enum HEADERDROPDOWNFILTERSTATES {
	HDDFS_NORMAL = 1,
	HDDFS_SOFTHOT = 2,
	HDDFS_HOT = 3,
};

enum HEADEROVERFLOWSTATES {
	HOFS_NORMAL = 1,
	HOFS_HOT = 2,
};


//
//  LISTBOXSTYLE class parts and states 
//
#define VSCLASS_LISTBOXSTYLE	L"LISTBOXSTYLE"
#define VSCLASS_LISTBOX	L"LISTBOX"

enum LISTBOXPARTS {
	LBCP_BORDER_HSCROLL = 1,
	LBCP_BORDER_HVSCROLL = 2,
	LBCP_BORDER_NOSCROLL = 3,
	LBCP_BORDER_VSCROLL = 4,
	LBCP_ITEM = 5,
};

#define LISTBOXSTYLEPARTS LISTBOXPARTS;

enum BORDER_HSCROLLSTATES {
	LBPSH_NORMAL = 1,
	LBPSH_FOCUSED = 2,
	LBPSH_HOT = 3,
	LBPSH_DISABLED = 4,
};

enum BORDER_HVSCROLLSTATES {
	LBPSHV_NORMAL = 1,
	LBPSHV_FOCUSED = 2,
	LBPSHV_HOT = 3,
	LBPSHV_DISABLED = 4,
};

enum BORDER_NOSCROLLSTATES {
	LBPSN_NORMAL = 1,
	LBPSN_FOCUSED = 2,
	LBPSN_HOT = 3,
	LBPSN_DISABLED = 4,
};

enum BORDER_VSCROLLSTATES {
	LBPSV_NORMAL = 1,
	LBPSV_FOCUSED = 2,
	LBPSV_HOT = 3,
	LBPSV_DISABLED = 4,
};

enum ITEMSTATES {
	LBPSI_HOT = 1,
	LBPSI_HOTSELECTED = 2,
	LBPSI_SELECTED = 3,
	LBPSI_SELECTEDNOTFOCUS = 4,
};


//
//  LISTVIEWSTYLE class parts and states 
//
#define VSCLASS_LISTVIEWSTYLE	L"LISTVIEWSTYLE"
#define VSCLASS_LISTVIEW	L"LISTVIEW"

enum LISTVIEWPARTS {
	LVP_LISTITEM = 1,
	LVP_LISTGROUP = 2,
	LVP_LISTDETAIL = 3,
	LVP_LISTSORTEDDETAIL = 4,
	LVP_EMPTYTEXT = 5,
	LVP_GROUPHEADER = 6,
	LVP_GROUPHEADERLINE = 7,
	LVP_EXPANDBUTTON = 8,
	LVP_COLLAPSEBUTTON = 9,
	LVP_COLUMNDETAIL = 10,
};

#define LISTVIEWSTYLEPARTS LISTVIEWPARTS;

enum LISTITEMSTATES {
	LISS_NORMAL = 1,
	LISS_HOT = 2,
	LISS_SELECTED = 3,
	LISS_DISABLED = 4,
	LISS_SELECTEDNOTFOCUS = 5,
	LISS_HOTSELECTED = 6,
};

enum GROUPHEADERSTATES {
	LVGH_OPEN = 1,
	LVGH_OPENHOT = 2,
	LVGH_OPENSELECTED = 3,
	LVGH_OPENSELECTEDHOT = 4,
	LVGH_OPENSELECTEDNOTFOCUSED = 5,
	LVGH_OPENSELECTEDNOTFOCUSEDHOT = 6,
	LVGH_OPENMIXEDSELECTION = 7,
	LVGH_OPENMIXEDSELECTIONHOT = 8,
	LVGH_CLOSE = 9,
	LVGH_CLOSEHOT = 10,
	LVGH_CLOSESELECTED = 11,
	LVGH_CLOSESELECTEDHOT = 12,
	LVGH_CLOSESELECTEDNOTFOCUSED = 13,
	LVGH_CLOSESELECTEDNOTFOCUSEDHOT = 14,
	LVGH_CLOSEMIXEDSELECTION = 15,
	LVGH_CLOSEMIXEDSELECTIONHOT = 16,
};

enum GROUPHEADERLINESTATES {
	LVGHL_OPEN = 1,
	LVGHL_OPENHOT = 2,
	LVGHL_OPENSELECTED = 3,
	LVGHL_OPENSELECTEDHOT = 4,
	LVGHL_OPENSELECTEDNOTFOCUSED = 5,
	LVGHL_OPENSELECTEDNOTFOCUSEDHOT = 6,
	LVGHL_OPENMIXEDSELECTION = 7,
	LVGHL_OPENMIXEDSELECTIONHOT = 8,
	LVGHL_CLOSE = 9,
	LVGHL_CLOSEHOT = 10,
	LVGHL_CLOSESELECTED = 11,
	LVGHL_CLOSESELECTEDHOT = 12,
	LVGHL_CLOSESELECTEDNOTFOCUSED = 13,
	LVGHL_CLOSESELECTEDNOTFOCUSEDHOT = 14,
	LVGHL_CLOSEMIXEDSELECTION = 15,
	LVGHL_CLOSEMIXEDSELECTIONHOT = 16,
};

enum EXPANDBUTTONSTATES {
	LVEB_NORMAL = 1,
	LVEB_HOVER = 2,
	LVEB_PUSHED = 3,
};

enum COLLAPSEBUTTONSTATES {
	LVCB_NORMAL = 1,
	LVCB_HOVER = 2,
	LVCB_PUSHED = 3,
};


//
//  MENUSTYLE class parts and states 
//
#define VSCLASS_MENUSTYLE	L"MENUSTYLE"
#define VSCLASS_MENU	L"MENU"

enum MENUPARTS {
	MENU_MENUITEM_TMSCHEMA = 1,
	MENU_MENUDROPDOWN_TMSCHEMA = 2,
	MENU_MENUBARITEM_TMSCHEMA = 3,
	MENU_MENUBARDROPDOWN_TMSCHEMA = 4,
	MENU_CHEVRON_TMSCHEMA = 5,
	MENU_SEPARATOR_TMSCHEMA = 6,
	MENU_BARBACKGROUND = 7,
	MENU_BARITEM = 8,
	MENU_POPUPBACKGROUND = 9,
	MENU_POPUPBORDERS = 10,
	MENU_POPUPCHECK = 11,
	MENU_POPUPCHECKBACKGROUND = 12,
	MENU_POPUPGUTTER = 13,
	MENU_POPUPITEM = 14,
	MENU_POPUPSEPARATOR = 15,
	MENU_POPUPSUBMENU = 16,
	MENU_SYSTEMCLOSE = 17,
	MENU_SYSTEMMAXIMIZE = 18,
	MENU_SYSTEMMINIMIZE = 19,
	MENU_SYSTEMRESTORE = 20,
};

#define MENUSTYLEPARTS MENUPARTS;

enum BARBACKGROUNDSTATES {
	MB_ACTIVE = 1,
	MB_INACTIVE = 2,
};

enum BARITEMSTATES {
	MBI_NORMAL = 1,
	MBI_HOT = 2,
	MBI_PUSHED = 3,
	MBI_DISABLED = 4,
	MBI_DISABLEDHOT = 5,
	MBI_DISABLEDPUSHED = 6,
};

enum POPUPCHECKSTATES {
	MC_CHECKMARKNORMAL = 1,
	MC_CHECKMARKDISABLED = 2,
	MC_BULLETNORMAL = 3,
	MC_BULLETDISABLED = 4,
};

enum POPUPCHECKBACKGROUNDSTATES {
	MCB_DISABLED = 1,
	MCB_NORMAL = 2,
	MCB_BITMAP = 3,
};

enum POPUPITEMSTATES {
	MPI_NORMAL = 1,
	MPI_HOT = 2,
	MPI_DISABLED = 3,
	MPI_DISABLEDHOT = 4,
};

enum POPUPSUBMENUSTATES {
	MSM_NORMAL = 1,
	MSM_DISABLED = 2,
};

enum SYSTEMCLOSESTATES {
	MSYSC_NORMAL = 1,
	MSYSC_DISABLED = 2,
};

enum SYSTEMMAXIMIZESTATES {
	MSYSMX_NORMAL = 1,
	MSYSMX_DISABLED = 2,
};

enum SYSTEMMINIMIZESTATES {
	MSYSMN_NORMAL = 1,
	MSYSMN_DISABLED = 2,
};

enum SYSTEMRESTORESTATES {
	MSYSR_NORMAL = 1,
	MSYSR_DISABLED = 2,
};


//
//  NAVIGATION class parts and states 
//
#define VSCLASS_NAVIGATION	L"NAVIGATION"

enum NAVIGATIONPARTS {
	NAV_BACKBUTTON = 1,
	NAV_FORWARDBUTTON = 2,
	NAV_MENUBUTTON = 3,
};

enum NAV_BACKBUTTONSTATES {
	NAV_BB_NORMAL = 1,
	NAV_BB_HOT = 2,
	NAV_BB_PRESSED = 3,
	NAV_BB_DISABLED = 4,
};

enum NAV_FORWARDBUTTONSTATES {
	NAV_FB_NORMAL = 1,
	NAV_FB_HOT = 2,
	NAV_FB_PRESSED = 3,
	NAV_FB_DISABLED = 4,
};

enum NAV_MENUBUTTONSTATES {
	NAV_MB_NORMAL = 1,
	NAV_MB_HOT = 2,
	NAV_MB_PRESSED = 3,
	NAV_MB_DISABLED = 4,
};


//
//  PROGRESSSTYLE class parts and states 
//
#define VSCLASS_PROGRESSSTYLE	L"PROGRESSSTYLE"
#define VSCLASS_PROGRESS	L"PROGRESS"

enum PROGRESSPARTS {
	PP_BAR = 1,
	PP_BARVERT = 2,
	PP_CHUNK = 3,
	PP_CHUNKVERT = 4,
	PP_FILL = 5,
	PP_FILLVERT = 6,
	PP_PULSEOVERLAY = 7,
	PP_MOVEOVERLAY = 8,
	PP_PULSEOVERLAYVERT = 9,
	PP_MOVEOVERLAYVERT = 10,
	PP_TRANSPARENTBAR = 11,
	PP_TRANSPARENTBARVERT = 12,
};

#define PROGRESSSTYLEPARTS PROGRESSPARTS;

enum TRANSPARENTBARSTATES {
	PBBS_NORMAL = 1,
	PBBS_PARTIAL = 2,
};

enum TRANSPARENTBARVERTSTATES {
	PBBVS_NORMAL = 1,
	PBBVS_PARTIAL = 2,
};

enum FILLSTATES {
	PBFS_NORMAL = 1,
	PBFS_ERROR = 2,
	PBFS_PAUSED = 3,
	PBFS_PARTIAL = 4,
};

enum FILLVERTSTATES {
	PBFVS_NORMAL = 1,
	PBFVS_ERROR = 2,
	PBFVS_PAUSED = 3,
	PBFVS_PARTIAL = 4,
};


//
//  REBARSTYLE class parts and states 
//
#define VSCLASS_REBARSTYLE	L"REBARSTYLE"
#define VSCLASS_REBAR	L"REBAR"

enum REBARPARTS {
	RP_GRIPPER = 1,
	RP_GRIPPERVERT = 2,
	RP_BAND = 3,
	RP_CHEVRON = 4,
	RP_CHEVRONVERT = 5,
	RP_BACKGROUND = 6,
	RP_SPLITTER = 7,
	RP_SPLITTERVERT = 8,
};

#define REBARSTYLEPARTS REBARPARTS;

enum CHEVRONSTATES {
	CHEVS_NORMAL = 1,
	CHEVS_HOT = 2,
	CHEVS_PRESSED = 3,
};

enum CHEVRONVERTSTATES {
	CHEVSV_NORMAL = 1,
	CHEVSV_HOT = 2,
	CHEVSV_PRESSED = 3,
};

enum SPLITTERSTATES {
	SPLITS_NORMAL = 1,
	SPLITS_HOT = 2,
	SPLITS_PRESSED = 3,
};

enum SPLITTERVERTSTATES {
	SPLITSV_NORMAL = 1,
	SPLITSV_HOT = 2,
	SPLITSV_PRESSED = 3,
};


//
//  SCROLLBARSTYLE class parts and states 
//
#define VSCLASS_SCROLLBARSTYLE	L"SCROLLBARSTYLE"
#define VSCLASS_SCROLLBAR	L"SCROLLBAR"

enum SCROLLBARPARTS {
	SBP_ARROWBTN = 1,
	SBP_THUMBBTNHORZ = 2,
	SBP_THUMBBTNVERT = 3,
	SBP_LOWERTRACKHORZ = 4,
	SBP_UPPERTRACKHORZ = 5,
	SBP_LOWERTRACKVERT = 6,
	SBP_UPPERTRACKVERT = 7,
	SBP_GRIPPERHORZ = 8,
	SBP_GRIPPERVERT = 9,
	SBP_SIZEBOX = 10,
};

#define SCROLLBARSTYLEPARTS SCROLLBARPARTS;

enum ARROWBTNSTATES {
	ABS_UPNORMAL = 1,
	ABS_UPHOT = 2,
	ABS_UPPRESSED = 3,
	ABS_UPDISABLED = 4,
	ABS_DOWNNORMAL = 5,
	ABS_DOWNHOT = 6,
	ABS_DOWNPRESSED = 7,
	ABS_DOWNDISABLED = 8,
	ABS_LEFTNORMAL = 9,
	ABS_LEFTHOT = 10,
	ABS_LEFTPRESSED = 11,
	ABS_LEFTDISABLED = 12,
	ABS_RIGHTNORMAL = 13,
	ABS_RIGHTHOT = 14,
	ABS_RIGHTPRESSED = 15,
	ABS_RIGHTDISABLED = 16,
	ABS_UPHOVER = 17,
	ABS_DOWNHOVER = 18,
	ABS_LEFTHOVER = 19,
	ABS_RIGHTHOVER = 20,
};

enum SCROLLBARSTYLESTATES {
	SCRBS_NORMAL = 1,
	SCRBS_HOT = 2,
	SCRBS_PRESSED = 3,
	SCRBS_DISABLED = 4,
	SCRBS_HOVER = 5,
};

enum SIZEBOXSTATES {
	SZB_RIGHTALIGN = 1,
	SZB_LEFTALIGN = 2,
	SZB_TOPRIGHTALIGN = 3,
	SZB_TOPLEFTALIGN = 4,
	SZB_HALFBOTTOMRIGHTALIGN = 5,
	SZB_HALFBOTTOMLEFTALIGN = 6,
	SZB_HALFTOPRIGHTALIGN = 7,
	SZB_HALFTOPLEFTALIGN = 8,
};


//
//  SPINSTYLE class parts and states 
//
#define VSCLASS_SPINSTYLE	L"SPINSTYLE"
#define VSCLASS_SPIN	L"SPIN"

enum SPINPARTS {
	SPNP_UP = 1,
	SPNP_DOWN = 2,
	SPNP_UPHORZ = 3,
	SPNP_DOWNHORZ = 4,
};

#define SPINSTYLEPARTS SPINPARTS;

enum UPSTATES {
	UPS_NORMAL = 1,
	UPS_HOT = 2,
	UPS_PRESSED = 3,
	UPS_DISABLED = 4,
};

enum DOWNSTATES {
	DNS_NORMAL = 1,
	DNS_HOT = 2,
	DNS_PRESSED = 3,
	DNS_DISABLED = 4,
};

enum UPHORZSTATES {
	UPHZS_NORMAL = 1,
	UPHZS_HOT = 2,
	UPHZS_PRESSED = 3,
	UPHZS_DISABLED = 4,
};

enum DOWNHORZSTATES {
	DNHZS_NORMAL = 1,
	DNHZS_HOT = 2,
	DNHZS_PRESSED = 3,
	DNHZS_DISABLED = 4,
};


//
//  STATUSSTYLE class parts and states 
//
#define VSCLASS_STATUSSTYLE	L"STATUSSTYLE"
#define VSCLASS_STATUS	L"STATUS"

enum STATUSPARTS {
	SP_PANE = 1,
	SP_GRIPPERPANE = 2,
	SP_GRIPPER = 3,
};

#define STATUSSTYLEPARTS STATUSPARTS;


//
//  TABSTYLE class parts and states 
//
#define VSCLASS_TABSTYLE	L"TABSTYLE"
#define VSCLASS_TAB	L"TAB"

enum TABPARTS {
	TABP_TABITEM = 1,
	TABP_TABITEMLEFTEDGE = 2,
	TABP_TABITEMRIGHTEDGE = 3,
	TABP_TABITEMBOTHEDGE = 4,
	TABP_TOPTABITEM = 5,
	TABP_TOPTABITEMLEFTEDGE = 6,
	TABP_TOPTABITEMRIGHTEDGE = 7,
	TABP_TOPTABITEMBOTHEDGE = 8,
	TABP_PANE = 9,
	TABP_BODY = 10,
	TABP_AEROWIZARDBODY = 11,
};

#define TABSTYLEPARTS TABPARTS;

enum TABITEMSTATES {
	TIS_NORMAL = 1,
	TIS_HOT = 2,
	TIS_SELECTED = 3,
	TIS_DISABLED = 4,
	TIS_FOCUSED = 5,
};

enum TABITEMLEFTEDGESTATES {
	TILES_NORMAL = 1,
	TILES_HOT = 2,
	TILES_SELECTED = 3,
	TILES_DISABLED = 4,
	TILES_FOCUSED = 5,
};

enum TABITEMRIGHTEDGESTATES {
	TIRES_NORMAL = 1,
	TIRES_HOT = 2,
	TIRES_SELECTED = 3,
	TIRES_DISABLED = 4,
	TIRES_FOCUSED = 5,
};

enum TABITEMBOTHEDGESTATES {
	TIBES_NORMAL = 1,
	TIBES_HOT = 2,
	TIBES_SELECTED = 3,
	TIBES_DISABLED = 4,
	TIBES_FOCUSED = 5,
};

enum TOPTABITEMSTATES {
	TTIS_NORMAL = 1,
	TTIS_HOT = 2,
	TTIS_SELECTED = 3,
	TTIS_DISABLED = 4,
	TTIS_FOCUSED = 5,
};

enum TOPTABITEMLEFTEDGESTATES {
	TTILES_NORMAL = 1,
	TTILES_HOT = 2,
	TTILES_SELECTED = 3,
	TTILES_DISABLED = 4,
	TTILES_FOCUSED = 5,
};

enum TOPTABITEMRIGHTEDGESTATES {
	TTIRES_NORMAL = 1,
	TTIRES_HOT = 2,
	TTIRES_SELECTED = 3,
	TTIRES_DISABLED = 4,
	TTIRES_FOCUSED = 5,
};

enum TOPTABITEMBOTHEDGESTATES {
	TTIBES_NORMAL = 1,
	TTIBES_HOT = 2,
	TTIBES_SELECTED = 3,
	TTIBES_DISABLED = 4,
	TTIBES_FOCUSED = 5,
};


//
//  TASKDIALOGSTYLE class parts and states 
//
#define VSCLASS_TASKDIALOGSTYLE	L"TASKDIALOGSTYLE"
#define VSCLASS_TASKDIALOG	L"TASKDIALOG"

enum TASKDIALOGPARTS {
	TDLG_PRIMARYPANEL = 1,
	TDLG_MAININSTRUCTIONPANE = 2,
	TDLG_MAINICON = 3,
	TDLG_CONTENTPANE = 4,
	TDLG_CONTENTICON = 5,
	TDLG_EXPANDEDCONTENT = 6,
	TDLG_COMMANDLINKPANE = 7,
	TDLG_SECONDARYPANEL = 8,
	TDLG_CONTROLPANE = 9,
	TDLG_BUTTONSECTION = 10,
	TDLG_BUTTONWRAPPER = 11,
	TDLG_EXPANDOTEXT = 12,
	TDLG_EXPANDOBUTTON = 13,
	TDLG_VERIFICATIONTEXT = 14,
	TDLG_FOOTNOTEPANE = 15,
	TDLG_FOOTNOTEAREA = 16,
	TDLG_FOOTNOTESEPARATOR = 17,
	TDLG_EXPANDEDFOOTERAREA = 18,
	TDLG_PROGRESSBAR = 19,
	TDLG_IMAGEALIGNMENT = 20,
	TDLG_RADIOBUTTONPANE = 21,
};

#define TASKDIALOGSTYLEPARTS TASKDIALOGPARTS;

enum CONTENTPANESTATES {
	TDLGCPS_STANDALONE = 1,
};

enum EXPANDOBUTTONSTATES {
	TDLGEBS_NORMAL = 1,
	TDLGEBS_HOVER = 2,
	TDLGEBS_PRESSED = 3,
	TDLGEBS_EXPANDEDNORMAL = 4,
	TDLGEBS_EXPANDEDHOVER = 5,
	TDLGEBS_EXPANDEDPRESSED = 6,
};


//
//  TEXTSTYLE class parts and states 
//
#define VSCLASS_TEXTSTYLE	L"TEXTSTYLE"

enum TEXTSTYLEPARTS {
	TEXT_MAININSTRUCTION = 1,
	TEXT_INSTRUCTION = 2,
	TEXT_BODYTITLE = 3,
	TEXT_BODYTEXT = 4,
	TEXT_SECONDARYTEXT = 5,
	TEXT_HYPERLINKTEXT = 6,
	TEXT_EXPANDED = 7,
	TEXT_LABEL = 8,
	TEXT_CONTROLLABEL = 9,
};

enum HYPERLINKTEXTSTATES {
	TS_HYPERLINK_NORMAL = 1,
	TS_HYPERLINK_HOT = 2,
	TS_HYPERLINK_PRESSED = 3,
	TS_HYPERLINK_DISABLED = 4,
};

enum CONTROLLABELSTATES {
	TS_CONTROLLABEL_NORMAL = 1,
	TS_CONTROLLABEL_DISABLED = 2,
};


//
//  TOOLBARSTYLE class parts and states 
//
#define VSCLASS_TOOLBARSTYLE	L"TOOLBARSTYLE"
#define VSCLASS_TOOLBAR	L"TOOLBAR"

enum TOOLBARPARTS {
	TP_BUTTON = 1,
	TP_DROPDOWNBUTTON = 2,
	TP_SPLITBUTTON = 3,
	TP_SPLITBUTTONDROPDOWN = 4,
	TP_SEPARATOR = 5,
	TP_SEPARATORVERT = 6,
};

#define TOOLBARSTYLEPARTS TOOLBARPARTS;

enum TOOLBARSTYLESTATES {
	TS_NORMAL = 1,
	TS_HOT = 2,
	TS_PRESSED = 3,
	TS_DISABLED = 4,
	TS_CHECKED = 5,
	TS_HOTCHECKED = 6,
	TS_NEARHOT = 7,
	TS_OTHERSIDEHOT = 8,
};


//
//  TOOLTIPSTYLE class parts and states 
//
#define VSCLASS_TOOLTIPSTYLE	L"TOOLTIPSTYLE"
#define VSCLASS_TOOLTIP	L"TOOLTIP"

enum TOOLTIPPARTS {
	TTP_STANDARD = 1,
	TTP_STANDARDTITLE = 2,
	TTP_BALLOON = 3,
	TTP_BALLOONTITLE = 4,
	TTP_CLOSE = 5,
	TTP_BALLOONSTEM = 6,
};

#define TOOLTIPSTYLEPARTS TOOLTIPPARTS;

enum CLOSESTATES {
	TTCS_NORMAL = 1,
	TTCS_HOT = 2,
	TTCS_PRESSED = 3,
};

enum STANDARDSTATES {
	TTSS_NORMAL = 1,
	TTSS_LINK = 2,
};

enum BALLOONSTATES {
	TTBS_NORMAL = 1,
	TTBS_LINK = 2,
};

enum BALLOONSTEMSTATES {
	TTBSS_POINTINGUPLEFTWALL = 1,
	TTBSS_POINTINGUPCENTERED = 2,
	TTBSS_POINTINGUPRIGHTWALL = 3,
	TTBSS_POINTINGDOWNRIGHTWALL = 4,
	TTBSS_POINTINGDOWNCENTERED = 5,
	TTBSS_POINTINGDOWNLEFTWALL = 6,
};


//
//  TRACKBARSTYLE class parts and states 
//
#define VSCLASS_TRACKBARSTYLE	L"TRACKBARSTYLE"
#define VSCLASS_TRACKBAR	L"TRACKBAR"

enum TRACKBARPARTS {
	TKP_TRACK = 1,
	TKP_TRACKVERT = 2,
	TKP_THUMB = 3,
	TKP_THUMBBOTTOM = 4,
	TKP_THUMBTOP = 5,
	TKP_THUMBVERT = 6,
	TKP_THUMBLEFT = 7,
	TKP_THUMBRIGHT = 8,
	TKP_TICS = 9,
	TKP_TICSVERT = 10,
};

#define TRACKBARSTYLEPARTS TRACKBARPARTS;

enum TRACKBARSTYLESTATES {
	TKS_NORMAL = 1,
};

enum TRACKSTATES {
	TRS_NORMAL = 1,
};

enum TRACKVERTSTATES {
	TRVS_NORMAL = 1,
};

enum THUMBSTATES {
	TUS_NORMAL = 1,
	TUS_HOT = 2,
	TUS_PRESSED = 3,
	TUS_FOCUSED = 4,
	TUS_DISABLED = 5,
};

enum THUMBBOTTOMSTATES {
	TUBS_NORMAL = 1,
	TUBS_HOT = 2,
	TUBS_PRESSED = 3,
	TUBS_FOCUSED = 4,
	TUBS_DISABLED = 5,
};

enum THUMBTOPSTATES {
	TUTS_NORMAL = 1,
	TUTS_HOT = 2,
	TUTS_PRESSED = 3,
	TUTS_FOCUSED = 4,
	TUTS_DISABLED = 5,
};

enum THUMBVERTSTATES {
	TUVS_NORMAL = 1,
	TUVS_HOT = 2,
	TUVS_PRESSED = 3,
	TUVS_FOCUSED = 4,
	TUVS_DISABLED = 5,
};

enum THUMBLEFTSTATES {
	TUVLS_NORMAL = 1,
	TUVLS_HOT = 2,
	TUVLS_PRESSED = 3,
	TUVLS_FOCUSED = 4,
	TUVLS_DISABLED = 5,
};

enum THUMBRIGHTSTATES {
	TUVRS_NORMAL = 1,
	TUVRS_HOT = 2,
	TUVRS_PRESSED = 3,
	TUVRS_FOCUSED = 4,
	TUVRS_DISABLED = 5,
};

enum TICSSTATES {
	TSS_NORMAL = 1,
};

enum TICSVERTSTATES {
	TSVS_NORMAL = 1,
};


//
//  TREEVIEWSTYLE class parts and states 
//
#define VSCLASS_TREEVIEWSTYLE	L"TREEVIEWSTYLE"
#define VSCLASS_TREEVIEW	L"TREEVIEW"

enum TREEVIEWPARTS {
	TVP_TREEITEM = 1,
	TVP_GLYPH = 2,
	TVP_BRANCH = 3,
	TVP_HOTGLYPH = 4,
};

#define TREEVIEWSTYLEPARTS TREEVIEWPARTS;

enum TREEITEMSTATES {
	TREIS_NORMAL = 1,
	TREIS_HOT = 2,
	TREIS_SELECTED = 3,
	TREIS_DISABLED = 4,
	TREIS_SELECTEDNOTFOCUS = 5,
	TREIS_HOTSELECTED = 6,
};

enum GLYPHSTATES {
	GLPS_CLOSED = 1,
	GLPS_OPENED = 2,
};

enum HOTGLYPHSTATES {
	HGLPS_CLOSED = 1,
	HGLPS_OPENED = 2,
};


//
//  WINDOWSTYLE class parts and states 
//
#define VSCLASS_WINDOWSTYLE	L"WINDOWSTYLE"
#define VSCLASS_WINDOW	L"WINDOW"

enum WINDOWPARTS {
	WP_CAPTION = 1,
	WP_SMALLCAPTION = 2,
	WP_MINCAPTION = 3,
	WP_SMALLMINCAPTION = 4,
	WP_MAXCAPTION = 5,
	WP_SMALLMAXCAPTION = 6,
	WP_FRAMELEFT = 7,
	WP_FRAMERIGHT = 8,
	WP_FRAMEBOTTOM = 9,
	WP_SMALLFRAMELEFT = 10,
	WP_SMALLFRAMERIGHT = 11,
	WP_SMALLFRAMEBOTTOM = 12,
	WP_SYSBUTTON = 13,
	WP_MDISYSBUTTON = 14,
	WP_MINBUTTON = 15,
	WP_MDIMINBUTTON = 16,
	WP_MAXBUTTON = 17,
	WP_CLOSEBUTTON = 18,
	WP_SMALLCLOSEBUTTON = 19,
	WP_MDICLOSEBUTTON = 20,
	WP_RESTOREBUTTON = 21,
	WP_MDIRESTOREBUTTON = 22,
	WP_HELPBUTTON = 23,
	WP_MDIHELPBUTTON = 24,
	WP_HORZSCROLL = 25,
	WP_HORZTHUMB = 26,
	WP_VERTSCROLL = 27,
	WP_VERTTHUMB = 28,
	WP_DIALOG = 29,
	WP_CAPTIONSIZINGTEMPLATE = 30,
	WP_SMALLCAPTIONSIZINGTEMPLATE = 31,
	WP_FRAMELEFTSIZINGTEMPLATE = 32,
	WP_SMALLFRAMELEFTSIZINGTEMPLATE = 33,
	WP_FRAMERIGHTSIZINGTEMPLATE = 34,
	WP_SMALLFRAMERIGHTSIZINGTEMPLATE = 35,
	WP_FRAMEBOTTOMSIZINGTEMPLATE = 36,
	WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE = 37,
	WP_FRAME = 38,
};

#define WINDOWSTYLEPARTS WINDOWPARTS;

enum FRAMESTATES {
	FS_ACTIVE = 1,
	FS_INACTIVE = 2,
};

enum CAPTIONSTATES {
	CS_ACTIVE = 1,
	CS_INACTIVE = 2,
	CS_DISABLED = 3,
};

enum MAXCAPTIONSTATES {
	MXCS_ACTIVE = 1,
	MXCS_INACTIVE = 2,
	MXCS_DISABLED = 3,
};

enum MINCAPTIONSTATES {
	MNCS_ACTIVE = 1,
	MNCS_INACTIVE = 2,
	MNCS_DISABLED = 3,
};

enum HORZSCROLLSTATES {
	HSS_NORMAL = 1,
	HSS_HOT = 2,
	HSS_PUSHED = 3,
	HSS_DISABLED = 4,
};

enum HORZTHUMBSTATES {
	HTS_NORMAL = 1,
	HTS_HOT = 2,
	HTS_PUSHED = 3,
	HTS_DISABLED = 4,
};

enum VERTSCROLLSTATES {
	VSS_NORMAL = 1,
	VSS_HOT = 2,
	VSS_PUSHED = 3,
	VSS_DISABLED = 4,
};

enum VERTTHUMBSTATES {
	VTS_NORMAL = 1,
	VTS_HOT = 2,
	VTS_PUSHED = 3,
	VTS_DISABLED = 4,
};

enum SYSBUTTONSTATES {
	SBS_NORMAL = 1,
	SBS_HOT = 2,
	SBS_PUSHED = 3,
	SBS_DISABLED = 4,
};

enum MINBUTTONSTATES {
	MINBS_NORMAL = 1,
	MINBS_HOT = 2,
	MINBS_PUSHED = 3,
	MINBS_DISABLED = 4,
};

enum MAXBUTTONSTATES {
	MAXBS_NORMAL = 1,
	MAXBS_HOT = 2,
	MAXBS_PUSHED = 3,
	MAXBS_DISABLED = 4,
};

enum RESTOREBUTTONSTATES {
	RBS_NORMAL = 1,
	RBS_HOT = 2,
	RBS_PUSHED = 3,
	RBS_DISABLED = 4,
};

enum HELPBUTTONSTATES {
	HBS_NORMAL = 1,
	HBS_HOT = 2,
	HBS_PUSHED = 3,
	HBS_DISABLED = 4,
};

enum CLOSEBUTTONSTATES {
	CBS_NORMAL = 1,
	CBS_HOT = 2,
	CBS_PUSHED = 3,
	CBS_DISABLED = 4,
};


//
//  enumerated property values
//

enum BGTYPE {
	BT_IMAGEFILE = 0,
	BT_BORDERFILL = 1,
	BT_NONE = 2,
};


//
//  enumerated property values
//

enum IMAGELAYOUT {
	IL_VERTICAL = 0,
	IL_HORIZONTAL = 1,
};


//
//  enumerated property values
//

enum BORDERTYPE {
	BT_RECT = 0,
	BT_ROUNDRECT = 1,
	BT_ELLIPSE = 2,
};


//
//  enumerated property values
//

enum FILLTYPE {
	FT_SOLID = 0,
	FT_VERTGRADIENT = 1,
	FT_HORZGRADIENT = 2,
	FT_RADIALGRADIENT = 3,
	FT_TILEIMAGE = 4,
};


//
//  enumerated property values
//

enum SIZINGTYPE {
	ST_TRUESIZE = 0,
	ST_STRETCH = 1,
	ST_TILE = 2,
};


//
//  enumerated property values
//

enum HALIGN {
	HA_LEFT = 0,
	HA_CENTER = 1,
	HA_RIGHT = 2,
};


//
//  enumerated property values
//

enum CONTENTALIGNMENT {
	CA_LEFT = 0,
	CA_CENTER = 1,
	CA_RIGHT = 2,
};


//
//  enumerated property values
//

enum VALIGN {
	VA_TOP = 0,
	VA_CENTER = 1,
	VA_BOTTOM = 2,
};


//
//  enumerated property values
//

enum OFFSETTYPE {
	OT_TOPLEFT = 0,
	OT_TOPRIGHT = 1,
	OT_TOPMIDDLE = 2,
	OT_BOTTOMLEFT = 3,
	OT_BOTTOMRIGHT = 4,
	OT_BOTTOMMIDDLE = 5,
	OT_MIDDLELEFT = 6,
	OT_MIDDLERIGHT = 7,
	OT_LEFTOFCAPTION = 8,
	OT_RIGHTOFCAPTION = 9,
	OT_LEFTOFLASTBUTTON = 10,
	OT_RIGHTOFLASTBUTTON = 11,
	OT_ABOVELASTBUTTON = 12,
	OT_BELOWLASTBUTTON = 13,
};


//
//  enumerated property values
//

enum ICONEFFECT {
	ICE_NONE = 0,
	ICE_GLOW = 1,
	ICE_SHADOW = 2,
	ICE_PULSE = 3,
	ICE_ALPHA = 4,
};


//
//  enumerated property values
//

enum TEXTSHADOWTYPE {
	TST_NONE = 0,
	TST_SINGLE = 1,
	TST_CONTINUOUS = 2,
};


//
//  enumerated property values
//

enum GLYPHTYPE {
	GT_NONE = 0,
	GT_IMAGEGLYPH = 1,
	GT_FONTGLYPH = 2,
};


//
//  enumerated property values
//

enum IMAGESELECTTYPE {
	IST_NONE = 0,
	IST_SIZE = 1,
	IST_DPI = 2,
};


//
//  enumerated property values
//

enum TRUESIZESCALINGTYPE {
	TSST_NONE = 0,
	TSST_SIZE = 1,
	TSST_DPI = 2,
};


//
//  enumerated property values
//

enum GLYPHFONTSIZINGTYPE {
	GFST_NONE = 0,
	GFST_SIZE = 1,
	GFST_DPI = 2,
};

//
//  property symbol definitions
//

#define TMT_RESERVEDLOW	0
#define TMT_RESERVEDHIGH	7999

#define TMT_DIBDATA	2
#define TMT_GLYPHDIBDATA	8
#define TMT_ENUM	200
#define TMT_STRING	201
#define TMT_INT	202
#define TMT_BOOL	203
#define TMT_COLOR	204
#define TMT_MARGINS	205
#define TMT_FILENAME	206
#define TMT_SIZE	207
#define TMT_POSITION	208
#define TMT_RECT	209
#define TMT_FONT	210
#define TMT_INTLIST	211
#define TMT_HBITMAP	212
#define TMT_DISKSTREAM	213
#define TMT_STREAM	214
#define TMT_BITMAPREF	215
#define TMT_COLORSCHEMES	401
#define TMT_SIZES	402
#define TMT_CHARSET	403
#define TMT_NAME	600
#define TMT_DISPLAYNAME	601
#define TMT_TOOLTIP	602
#define TMT_COMPANY	603
#define TMT_AUTHOR	604
#define TMT_COPYRIGHT	605
#define TMT_URL	606
#define TMT_VERSION	607
#define TMT_DESCRIPTION	608
#define TMT_FIRST_RCSTRING_NAME	TMT_DISPLAYNAME
#define TMT_LAST_RCSTRING_NAME	TMT_DESCRIPTION
#define TMT_CAPTIONFONT	801
#define TMT_SMALLCAPTIONFONT	802
#define TMT_MENUFONT	803
#define TMT_STATUSFONT	804
#define TMT_MSGBOXFONT	805
#define TMT_ICONTITLEFONT	806
#define TMT_HEADING1FONT	807
#define TMT_HEADING2FONT	808
#define TMT_BODYFONT	809
#define TMT_FIRSTFONT	TMT_CAPTIONFONT
#define TMT_LASTFONT	TMT_BODYFONT
#define TMT_FLATMENUS	1001
#define TMT_FIRSTBOOL	TMT_FLATMENUS
#define TMT_LASTBOOL	TMT_FLATMENUS
#define TMT_SIZINGBORDERWIDTH	1201
#define TMT_SCROLLBARWIDTH	1202
#define TMT_SCROLLBARHEIGHT	1203
#define TMT_CAPTIONBARWIDTH	1204
#define TMT_CAPTIONBARHEIGHT	1205
#define TMT_SMCAPTIONBARWIDTH	1206
#define TMT_SMCAPTIONBARHEIGHT	1207
#define TMT_MENUBARWIDTH	1208
#define TMT_MENUBARHEIGHT	1209
#define TMT_PADDEDBORDERWIDTH	1210
#define TMT_FIRSTSIZE	TMT_SIZINGBORDERWIDTH
#define TMT_LASTSIZE	TMT_PADDEDBORDERWIDTH
#define TMT_MINCOLORDEPTH	1301
#define TMT_FIRSTINT	TMT_MINCOLORDEPTH
#define TMT_LASTINT	TMT_MINCOLORDEPTH
#define TMT_CSSNAME	1401
#define TMT_XMLNAME	1402
#define TMT_LASTUPDATED	1403
#define TMT_ALIAS	1404
#define TMT_FIRSTSTRING	TMT_CSSNAME
#define TMT_LASTSTRING	TMT_ALIAS
#define TMT_SCROLLBAR	1601
#define TMT_BACKGROUND	1602
#define TMT_ACTIVECAPTION	1603
#define TMT_INACTIVECAPTION	1604
#define TMT_MENU	1605
#define TMT_WINDOW	1606
#define TMT_WINDOWFRAME	1607
#define TMT_MENUTEXT	1608
#define TMT_WINDOWTEXT	1609
#define TMT_CAPTIONTEXT	1610
#define TMT_ACTIVEBORDER	1611
#define TMT_INACTIVEBORDER	1612
#define TMT_APPWORKSPACE	1613
#define TMT_HIGHLIGHT	1614
#define TMT_HIGHLIGHTTEXT	1615
#define TMT_BTNFACE	1616
#define TMT_BTNSHADOW	1617
#define TMT_GRAYTEXT	1618
#define TMT_BTNTEXT	1619
#define TMT_INACTIVECAPTIONTEXT	1620
#define TMT_BTNHIGHLIGHT	1621
#define TMT_DKSHADOW3D	1622
#define TMT_LIGHT3D	1623
#define TMT_INFOTEXT	1624
#define TMT_INFOBK	1625
#define TMT_BUTTONALTERNATEFACE	1626
#define TMT_HOTTRACKING	1627
#define TMT_GRADIENTACTIVECAPTION	1628
#define TMT_GRADIENTINACTIVECAPTION	1629
#define TMT_MENUHILIGHT	1630
#define TMT_MENUBAR	1631
#define TMT_FIRSTCOLOR	TMT_SCROLLBAR
#define TMT_LASTCOLOR	TMT_MENUBAR
#define TMT_FROMHUE1	1801
#define TMT_FROMHUE2	1802
#define TMT_FROMHUE3	1803
#define TMT_FROMHUE4	1804
#define TMT_FROMHUE5	1805
#define TMT_TOHUE1	1806
#define TMT_TOHUE2	1807
#define TMT_TOHUE3	1808
#define TMT_TOHUE4	1809
#define TMT_TOHUE5	1810
#define TMT_FROMCOLOR1	2001
#define TMT_FROMCOLOR2	2002
#define TMT_FROMCOLOR3	2003
#define TMT_FROMCOLOR4	2004
#define TMT_FROMCOLOR5	2005
#define TMT_TOCOLOR1	2006
#define TMT_TOCOLOR2	2007
#define TMT_TOCOLOR3	2008
#define TMT_TOCOLOR4	2009
#define TMT_TOCOLOR5	2010
#define TMT_TRANSPARENT	2201
#define TMT_AUTOSIZE	2202
#define TMT_BORDERONLY	2203
#define TMT_COMPOSITED	2204
#define TMT_BGFILL	2205
#define TMT_GLYPHTRANSPARENT	2206
#define TMT_GLYPHONLY	2207
#define TMT_ALWAYSSHOWSIZINGBAR	2208
#define TMT_MIRRORIMAGE	2209
#define TMT_UNIFORMSIZING	2210
#define TMT_INTEGRALSIZING	2211
#define TMT_SOURCEGROW	2212
#define TMT_SOURCESHRINK	2213
#define TMT_DRAWBORDERS	2214
#define TMT_NOETCHEDEFFECT	2215
#define TMT_TEXTAPPLYOVERLAY	2216
#define TMT_TEXTGLOW	2217
#define TMT_TEXTITALIC	2218
#define TMT_COMPOSITEDOPAQUE	2219
#define TMT_LOCALIZEDMIRRORIMAGE	2220
#define TMT_IMAGECOUNT	2401
#define TMT_ALPHALEVEL	2402
#define TMT_BORDERSIZE	2403
#define TMT_ROUNDCORNERWIDTH	2404
#define TMT_ROUNDCORNERHEIGHT	2405
#define TMT_GRADIENTRATIO1	2406
#define TMT_GRADIENTRATIO2	2407
#define TMT_GRADIENTRATIO3	2408
#define TMT_GRADIENTRATIO4	2409
#define TMT_GRADIENTRATIO5	2410
#define TMT_PROGRESSCHUNKSIZE	2411
#define TMT_PROGRESSSPACESIZE	2412
#define TMT_SATURATION	2413
#define TMT_TEXTBORDERSIZE	2414
#define TMT_ALPHATHRESHOLD	2415
#define TMT_WIDTH	2416
#define TMT_HEIGHT	2417
#define TMT_GLYPHINDEX	2418
#define TMT_TRUESIZESTRETCHMARK	2419
#define TMT_MINDPI1	2420
#define TMT_MINDPI2	2421
#define TMT_MINDPI3	2422
#define TMT_MINDPI4	2423
#define TMT_MINDPI5	2424
#define TMT_TEXTGLOWSIZE	2425
#define TMT_FRAMESPERSECOND	2426
#define TMT_PIXELSPERFRAME	2427
#define TMT_ANIMATIONDELAY	2428
#define TMT_GLOWINTENSITY	2429
#define TMT_OPACITY	2430
#define TMT_COLORIZATIONCOLOR	2431
#define TMT_COLORIZATIONOPACITY	2432
#define TMT_GLYPHFONT	2601
#define TMT_IMAGEFILE	3001
#define TMT_IMAGEFILE1	3002
#define TMT_IMAGEFILE2	3003
#define TMT_IMAGEFILE3	3004
#define TMT_IMAGEFILE4	3005
#define TMT_IMAGEFILE5	3006
#define TMT_GLYPHIMAGEFILE	3008
#define TMT_TEXT	3201
#define TMT_CLASSICVALUE	3202
#define TMT_OFFSET	3401
#define TMT_TEXTSHADOWOFFSET	3402
#define TMT_MINSIZE	3403
#define TMT_MINSIZE1	3404
#define TMT_MINSIZE2	3405
#define TMT_MINSIZE3	3406
#define TMT_MINSIZE4	3407
#define TMT_MINSIZE5	3408
#define TMT_NORMALSIZE	3409
#define TMT_SIZINGMARGINS	3601
#define TMT_CONTENTMARGINS	3602
#define TMT_CAPTIONMARGINS	3603
#define TMT_BORDERCOLOR	3801
#define TMT_FILLCOLOR	3802
#define TMT_TEXTCOLOR	3803
#define TMT_EDGELIGHTCOLOR	3804
#define TMT_EDGEHIGHLIGHTCOLOR	3805
#define TMT_EDGESHADOWCOLOR	3806
#define TMT_EDGEDKSHADOWCOLOR	3807
#define TMT_EDGEFILLCOLOR	3808
#define TMT_TRANSPARENTCOLOR	3809
#define TMT_GRADIENTCOLOR1	3810
#define TMT_GRADIENTCOLOR2	3811
#define TMT_GRADIENTCOLOR3	3812
#define TMT_GRADIENTCOLOR4	3813
#define TMT_GRADIENTCOLOR5	3814
#define TMT_SHADOWCOLOR	3815
#define TMT_GLOWCOLOR	3816
#define TMT_TEXTBORDERCOLOR	3817
#define TMT_TEXTSHADOWCOLOR	3818
#define TMT_GLYPHTEXTCOLOR	3819
#define TMT_GLYPHTRANSPARENTCOLOR	3820
#define TMT_FILLCOLORHINT	3821
#define TMT_BORDERCOLORHINT	3822
#define TMT_ACCENTCOLORHINT	3823
#define TMT_TEXTCOLORHINT	3824
#define TMT_HEADING1TEXTCOLOR	3825
#define TMT_HEADING2TEXTCOLOR	3826
#define TMT_BODYTEXTCOLOR	3827
#define TMT_BGTYPE	4001
#define TMT_BORDERTYPE	4002
#define TMT_FILLTYPE	4003
#define TMT_SIZINGTYPE	4004
#define TMT_HALIGN	4005
#define TMT_CONTENTALIGNMENT	4006
#define TMT_VALIGN	4007
#define TMT_OFFSETTYPE	4008
#define TMT_ICONEFFECT	4009
#define TMT_TEXTSHADOWTYPE	4010
#define TMT_IMAGELAYOUT	4011
#define TMT_GLYPHTYPE	4012
#define TMT_IMAGESELECTTYPE	4013
#define TMT_GLYPHFONTSIZINGTYPE	4014
#define TMT_TRUESIZESCALINGTYPE	4015
#define TMT_USERPICTURE	5001
#define TMT_DEFAULTPANESIZE	5002
#define TMT_BLENDCOLOR	5003
#define TMT_CUSTOMSPLITRECT	5004
#define TMT_ANIMATIONBUTTONRECT	5005
#define TMT_ANIMATIONDURATION	5006
#define TMT_TRANSITIONDURATIONS	6000
#define TMT_SCALEDBACKGROUND	7001
#define TMT_ATLASIMAGE	8000
#define TMT_ATLASINPUTIMAGE	8001
#define TMT_ATLASRECT	8002


//
//  LINK class parts and states 
//
#define VSCLASS_LINK	L"LINK"

enum LINKPARTS {
	LP_HYPERLINK = 1,
};

enum HYPERLINKSTATES {
	HLS_NORMALTEXT = 1,
	HLS_LINKTEXT = 2,
};


//
//  EMPTYMARKUP class parts and states 
//
#define VSCLASS_EMPTYMARKUP	L"EMPTYMARKUP"

enum EMPTYMARKUPPARTS {
	EMP_MARKUPTEXT = 1,
};

enum MARKUPTEXTSTATES {
	EMT_NORMALTEXT = 1,
	EMT_LINKTEXT = 2,
};


//
//  STATIC class parts and states 
//
#define VSCLASS_STATIC	L"STATIC"

enum STATICPARTS {
	STAT_TEXT = 1,
};


//
//  PAGE class parts and states 
//
#define VSCLASS_PAGE	L"PAGE"

enum PAGEPARTS {
	PGRP_UP = 1,
	PGRP_DOWN = 2,
	PGRP_UPHORZ = 3,
	PGRP_DOWNHORZ = 4,
};


//
//  MONTHCAL class parts and states 
//
#define VSCLASS_MONTHCAL	L"MONTHCAL"

enum MONTHCALPARTS {
	MC_BACKGROUND = 1,
	MC_BORDERS = 2,
	MC_GRIDBACKGROUND = 3,
	MC_COLHEADERSPLITTER = 4,
	MC_GRIDCELLBACKGROUND = 5,
	MC_GRIDCELL = 6,
	MC_GRIDCELLUPPER = 7,
	MC_TRAILINGGRIDCELL = 8,
	MC_TRAILINGGRIDCELLUPPER = 9,
	MC_NAVNEXT = 10,
	MC_NAVPREV = 11,
};

enum GRIDCELLBACKGROUNDSTATES {
	MCGCB_SELECTED = 1,
	MCGCB_HOT = 2,
	MCGCB_SELECTEDHOT = 3,
	MCGCB_SELECTEDNOTFOCUSED = 4,
	MCGCB_TODAY = 5,
};

enum GRIDCELLSTATES {
	MCGC_HOT = 1,
	MCGC_HASSTATE = 2,
	MCGC_HASSTATEHOT = 3,
	MCGC_TODAY = 4,
};

enum GRIDCELLUPPERSTATES {
	MCGCU_HOT = 1,
	MCGCU_HASSTATE = 2,
	MCGCU_HASSTATEHOT = 3,
};

enum TRAILINGGRIDCELLSTATES {
	MCTGC_HOT = 1,
	MCTGC_HASSTATE = 2,
	MCTGC_HASSTATEHOT = 3,
	MCTGC_TODAY = 4,
};

enum TRAILINGGRIDCELLUPPERSTATES {
	MCTGCU_HOT = 1,
	MCTGCU_HASSTATE = 2,
	MCTGCU_HASSTATEHOT = 3,
};

enum NAVNEXTSTATES {
	MCNN_NORMAL = 1,
	MCNN_HOT = 2,
	MCNN_PRESSED = 3,
	MCNN_DISABLED = 4,
};

enum NAVPREVSTATES {
	MCNP_NORMAL = 1,
	MCNP_HOT = 2,
	MCNP_PRESSED = 3,
	MCNP_DISABLED = 4,
};


//
//  CLOCK class parts and states 
//
#define VSCLASS_CLOCK	L"CLOCK"

enum CLOCKPARTS {
	CLP_TIME = 1,
};

enum CLOCKSTATES {
	CLS_NORMAL = 1,
};


//
//  TRAYNOTIFY class parts and states 
//
#define VSCLASS_TRAYNOTIFY	L"TRAYNOTIFY"

enum TRAYNOTIFYPARTS {
	TNP_BACKGROUND = 1,
	TNP_ANIMBACKGROUND = 2,
};


//
//  TASKBAR class parts and states 
//
#define VSCLASS_TASKBAR	L"TASKBAR"

enum TASKBARPARTS {
	TBP_BACKGROUNDBOTTOM = 1,
	TBP_BACKGROUNDRIGHT = 2,
	TBP_BACKGROUNDTOP = 3,
	TBP_BACKGROUNDLEFT = 4,
	TBP_SIZINGBARBOTTOM = 5,
	TBP_SIZINGBARRIGHT = 6,
	TBP_SIZINGBARTOP = 7,
	TBP_SIZINGBARLEFT = 8,
};


//
//  TASKBAND class parts and states 
//
#define VSCLASS_TASKBAND	L"TASKBAND"

enum TASKBANDPARTS {
	TDP_GROUPCOUNT = 1,
	TDP_FLASHBUTTON = 2,
	TDP_FLASHBUTTONGROUPMENU = 3,
};


//
//  STARTPANEL class parts and states 
//
#define VSCLASS_STARTPANEL	L"STARTPANEL"

enum STARTPANELPARTS {
	SPP_USERPANE = 1,
	SPP_MOREPROGRAMS = 2,
	SPP_MOREPROGRAMSARROW = 3,
	SPP_PROGLIST = 4,
	SPP_PROGLISTSEPARATOR = 5,
	SPP_PLACESLIST = 6,
	SPP_PLACESLISTSEPARATOR = 7,
	SPP_LOGOFF = 8,
	SPP_LOGOFFBUTTONS = 9,
	SPP_USERPICTURE = 10,
	SPP_PREVIEW = 11,
	SPP_MOREPROGRAMSTAB = 12,
	SPP_NSCHOST = 13,
	SPP_SOFTWAREEXPLORER = 14,
	SPP_OPENBOX = 15,
	SPP_SEARCHVIEW = 16,
	SPP_MOREPROGRAMSARROWBACK = 17,
	SPP_TOPMATCH = 18,
	SPP_LOGOFFSPLITBUTTONDROPDOWN = 19,
};

enum MOREPROGRAMSTABSTATES {
	SPMPT_NORMAL = 1,
	SPMPT_HOT = 2,
	SPMPT_SELECTED = 3,
	SPMPT_DISABLED = 4,
	SPMPT_FOCUSED = 5,
};

enum SOFTWAREEXPLORERSTATES {
	SPSE_NORMAL = 1,
	SPSE_HOT = 2,
	SPSE_SELECTED = 3,
	SPSE_DISABLED = 4,
	SPSE_FOCUSED = 5,
};

enum OPENBOXSTATES {
	SPOB_NORMAL = 1,
	SPOB_HOT = 2,
	SPOB_SELECTED = 3,
	SPOB_DISABLED = 4,
	SPOB_FOCUSED = 5,
};

enum MOREPROGRAMSARROWSTATES {
	SPS_NORMAL = 1,
	SPS_HOT = 2,
	SPS_PRESSED = 3,
};

enum MOREPROGRAMSARROWBACKSTATES {
	SPSB_NORMAL = 1,
	SPSB_HOT = 2,
	SPSB_PRESSED = 3,
};

enum LOGOFFBUTTONSSTATES {
	SPLS_NORMAL = 1,
	SPLS_HOT = 2,
	SPLS_PRESSED = 3,
};


//
//  MENUBAND class parts and states 
//
#define VSCLASS_MENUBAND	L"MENUBAND"

enum MENUBANDPARTS {
	MDP_NEWAPPBUTTON = 1,
	MDP_SEPERATOR = 2,
};

enum MENUBANDSTATES {
	MDS_NORMAL = 1,
	MDS_HOT = 2,
	MDS_PRESSED = 3,
	MDS_DISABLED = 4,
	MDS_CHECKED = 5,
	MDS_HOTCHECKED = 6,
};

#endif // TMSCHEMA_H
#endif // __VSSYM32_H__
#endif //__BCGPVSSTYLE_H__
