/*
 * FILE: MAXNode.h
 *
 * DESCRIPTION: 3DMAX node class
 *
 * CREATED BY: duyuxin, 2003/8/25
 *
 * HISTORY:
 *
 * Copyright (c) 2003 Archosaur Studio, All Rights Reserved.
 */

#ifndef _MAXNODE_H_
#define _MAXNODE_H_

#include "max.h"
#include "AString.h"
#include "A3DTypes.h"
#include "A3DQuaternion.h"

///////////////////////////////////////////////////////////////////////////
//
//	Define and Macro
//
///////////////////////////////////////////////////////////////////////////

enum MAXNODETYPE
{
	NODE_OTHER = 0,
	NODE_BONE,
	NODE_DUMMY,
	NODE_MESH,
	NODE_HOOK,
	NODE_HITBOX,
	NODE_PHYSHAPE,
};

///////////////////////////////////////////////////////////////////////////
//
//	Types and Global variables
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Declare of Global functions
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Class CMAXNode
//
///////////////////////////////////////////////////////////////////////////

class CMAXNode
{
public:		//	Types

public:		//	Constructions and Destructions

	CMAXNode();
	virtual ~CMAXNode() {}

public:		//	Attributes

public:		//	Operaitons

	bool Create(INode *pINode);
	CMAXNode* GetChild(int iChildId);
	int GetChildCount();
	const char* GetName();
	MAXNODETYPE GetType();

	INode* GetINode() { return m_pINode; }
	
protected:	//	Attributes

	INode*	m_pINode;

protected:	//	Operations

};

///////////////////////////////////////////////////////////////////////////
//
//	Inline functions
//
///////////////////////////////////////////////////////////////////////////


#endif	//	_MAXNODE_H_

