/*
 * FILE: PT_Sector.h
 *
 * DESCRIPTION: Sector routines
 *
 * CREATED BY: Duyuxin, 2003/6/12
 *
 * HISTORY:
 *
 * Copyright (c) 2001 Archosaur Studio, All Rights Reserved.	
 */

#ifndef	_PT_SECTOR_H_
#define _PT_SECTOR_H_

#include "PT_Internal.h"

/////////////////////////////////////////////////////////////////////////
//
//	Constants and Macros
//
/////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////
//
//	Types and Global variables
//
/////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////
//
//	Global functions
//
/////////////////////////////////////////////////////////////////////////

namespace PORTAL
{
	s_PTSECTOR* CreateSector(A3DVECTOR3* aVerts, WORD* aIndices, int iNumFace);
	bool CreatePortal(const PTADDPORTALDATA& Data, s_PTPORTAL** ppPortal1, s_PTPORTAL** ppPortal2);
	void ReleaseSector(s_PTSECTOR* pSector);
	void ReleasePortal(s_PTPORTAL* pPortal);
	bool LinkSectors();
	bool DispatchDrawSurfaces();
	bool PartSectors();
	int SectorOnPlaneSide(s_PTSECTOR* pSector, A3DVECTOR3& vNormal, float fDist);
}

/////////////////////////////////////////////////////////////////////////
//
//	Inline functions
//
/////////////////////////////////////////////////////////////////////////


#endif	//	_PT_SECTOR_H_


