//	RayTrace.h

#pragma once

#include <A3DVector.h>

///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Types and Global variables
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Declare of Global functions
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Class CRayTrace
//	
///////////////////////////////////////////////////////////////////////////

class CRayTrace
{
public:		//	Types

	//	Entity id
	enum
	{
		ENT_NONE = 0,
		ENT_TERRAIN,
		ENT_NPC,
	};

	//	Trace filter
	enum
	{
		FILTER_TERRAIN	= 0x0001,
		FILTER_NPC		= 0x0002,
		FILTER_ALL		= 0xffff,
	};
	
public:		//	Constructor and Destructor

	CRayTrace();
	virtual ~CRayTrace() {}
	
public:		//	Attributes

	//	Results of last ray trace
	int			m_iEntity;		//	Entity
	float		m_fFaction;		//	Fraction
	A3DVECTOR3	m_vHitPos;		//	Hit position
	A3DVECTOR3	m_vHitNormal;	//	Hit normal
	DWORD		m_dwObject;		//	Hit object

public:		//	Operations

	//	Do ray trace
	bool DoRayTrace(int x, int y, DWORD dwFilter=FILTER_ALL);
	bool DoRayTrace(const A3DVECTOR3& vFrom, const A3DVECTOR3& vTo, DWORD dwFilter=FILTER_ALL);

protected:	//	Attributes

protected:	//	Operations

};

///////////////////////////////////////////////////////////////////////////
//	
//	Inline functions
//	
///////////////////////////////////////////////////////////////////////////

