/*
 * FILE: Global.cpp
 *
 * DESCRIPTION: Global variables and definitions
 *
 * CREATED BY: Duyuxin, 2002/9/1
 *
 * HISTORY:
 *
 * Copyright (c) 2001 Archosaur Studio, All Rights Reserved.
 */

#include "Global.h"
#include "PhysDemo.h"

///////////////////////////////////////////////////////////////////////////
//
//	Define and Macro
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Reference to External variables and functions
//
///////////////////////////////////////////////////////////////////////////

char		g_szWorkDir[MAX_PATH];

A3DVECTOR3	g_vOrigin(0.0f);
A3DVECTOR3	g_vAxisX(1.0f, 0.0f, 0.0f);
A3DVECTOR3	g_vAxisY(0.0f, 1.0f, 0.0f);
A3DVECTOR3	g_vAxisZ(0.0f, 0.0f, 1.0f);

///////////////////////////////////////////////////////////////////////////
//
//	Local Types and Variables and Global variables
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Local functions
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Implement
//
///////////////////////////////////////////////////////////////////////////

CPhysDemoApp* AUX_GetApp()
{
	return (CPhysDemoApp*)AfxGetApp();
}

CMainFrame*	AUX_GetMainFrame()
{	
	return ((CPhysDemoApp*)AfxGetApp())->GetMainFrame();
}

//	Output message with window's message box
int AUX_MessageBox(int iType, const char* szMsg, ...)
{
	static char szText[1024];
	
	va_list vaList;
	va_start(vaList, szMsg);
	vsprintf(szText, szMsg, vaList);
	va_end(vaList);

	return ((CWnd*)AUX_GetMainFrame())->MessageBox(szText, "ʾ", iType);
}



