
#ifndef __GNET_SOLD_HPP
#define __GNET_SOLD_HPP

#include "rpcdefs.h"
#include "callid.hxx"
#include "state.hxx"


namespace GNET
{

class Sold : public GNET::Protocol
{
	#include "sold"

	void Process(Manager *manager, Manager::Session::ID sid)
	{
		// TODO
		DEBUG_PRINT("sold: receive. zoneid=%d,roleid=%lld,sn=%lld,buyerroleid=%d,orderid=%d\n",zoneid,sellerroleid,sn,buyerroleid,orderid);
/*
Sold_Re
0.ɹ 
1.snڣƽ̨˿
2.Ʒƽ̨Ϊɹط 
3.ط
4.Ҳңƽ̨˿ 
5. Ϸʧܣط 
6. Ϸ˸sn鵽sellerroleidڣǽɫɾǻصڼ佨Ľɫgsƽ̨Ըôƽ̨Ϊɹط
7.ƷϷڴڡƽ̨ͬС״̬ ϷƷڡƽ̨ͬС״̬ʱٴƽ̨߼ֱӷر룬ֱյƽ̨صReƽ̨յôκδط
8Ϸsn鵽selleruseridƽָ̨selleruseridһ£ʱԸôgsƽ̨Ըôƽ̨Ϊɹط
9Ϸsn鵽sellerroleidƽָ̨sellerroleidһ£ʱԸôgsƽ̨Ըôƽ̨Ϊɹط
10.Эз͵buyerroliedbuyeruseridƥ䣨ܴǺϷroleid仯ƽ̨Ϊɹطlog
11 
12 ʺɽɫ
13 ɫָҲƽ̨˿
14 ɫĽɫҲƽ̨˿Ʒϳ
15 ϳ˿
-1. Ϸʧܣط
*/
		int retcode = WebTradeMarket::GetInstance().DoSold(zoneid, selleruserid, sellerroleid, sn, buyeruserid, buyerroleid, orderid, stype, timestamp);
		if(retcode != ERR_SUCCESS)
		{
			Sold_Re re;
			re.zoneid = zoneid;
			re.selleruserid = selleruserid;
			re.sellerroleid = sellerroleid;
			re.buyeruserid = buyeruserid;
			re.buyerroleid = buyerroleid;
			re.sn = sn;
			re.orderid = orderid;
			switch(retcode)
			{
				default:
				case ERR_WT_UNOPEN:
				case ERR_WT_BUYER_STATUS_INAPPROPRIATE:
					re.retcode = -1;
					break;
				case ERR_WT_ENTRY_HAS_BEEN_SOLD:
					re.retcode = 2;
					break;
				case ERR_WT_ENTRY_NOT_FOUND:
					re.retcode = 1; 
					break;
				case ERR_WT_ENTRY_IS_BUSY:
					re.retcode = 7; 
					break;
				case ERR_WT_TIMESTAMP_MISMATCH:
					re.retcode = 0;
					break;
				case ERR_WT_BUYER_NOT_EXIST:
					re.retcode = 4;
					break;
			}
			GWebTradeClient::GetInstance()->SendProtocol(re);
		}
	}
};

};

#endif
