
#ifndef __GNET_SHELFCANCEL_HPP
#define __GNET_SHELFCANCEL_HPP

#include "rpcdefs.h"
#include "callid.hxx"
#include "state.hxx"


namespace GNET
{

class ShelfCancel : public GNET::Protocol
{
	#include "shelfcancel"

	void Process(Manager *manager, Manager::Session::ID sid)
	{
		// TODO
		DEBUG_PRINT("shelfcancel: receive. roleid=%lld,sn=%lld\n",roleid,sn);
/*
ShelfCancel_Re
0.ɹ 
1.snڣƽ̨ΪõӴɾõӣط 
2.ظ¼ ƽ̨Ϊɹط
3.ط 
4. Ϸʧܣط 
5. Ϸ˸sn鵽roleidڣǽɫѱGMɾصԭgsƽ̨Ըôƽ̨Ϊɹط
6.ƷϷڴڡƽ̨ͬС״̬ ϷƷڡƽ̨ͬС״̬ʱٴƽ̨߼ֱӷر룬ֱյƽ̨صReƽ̨յôκδط
7Ϸsn鵽useridƽָ̨useridһ£ʱԸôgsƽ̨Ըôƽ̨Ϊɹط
8Ϸsn鵽roleidƽָ̨roleidһ£ʱԸôgsƽ̨Ըôƽ̨Ϊɹط
-1. Ϸʧܣط
*/		
		int retcode = WebTradeMarket::GetInstance().DoShelfCancel(userid,roleid,sn,messageid,timestamp);
		if(retcode != ERR_SUCCESS)
		{
			ShelfCancel_Re re;
			re.userid = userid;
			re.roleid = roleid;
			re.sn = sn;
			re.messageid = messageid;
			switch(retcode)
			{
				default:
				case ERR_WT_UNOPEN:
					re.retcode = -1;
					break;
				case ERR_WT_ENTRY_NOT_FOUND:
					re.retcode = 1; 
					break;
				case ERR_WT_ENTRY_IS_BUSY:
					re.retcode = 6; 
					break;
				case ERR_WT_TIMESTAMP_MISMATCH:		//ظ¼ܵ
					re.retcode = 0;
					break;
			}
			GWebTradeClient::GetInstance()->SendProtocol(re);
		}
	}
};

};

#endif
