#include "playerbind.h"
#include "world.h"
#include "player_imp.h"
#include "obj_interface.h"
#include "duel_filter.h"
#include "filter_man.h"

void
player_bind::PlayerLinkRequest(gplayer_imp * pImp, const XID & target)
{
	if(!pImp->IsPlayerFemale())
	{
		pImp->_runner->error_message(S2C::ERR_INVALID_GENDER);
		return;
	}
	
	//Լ״̬
	//ܹ 1: 2:ڱ 3:ûҪ 4:ˮ 5:...
	if(_mode || !pImp->CheckPlayerBindRequest() || !target.IsPlayer())
	{
		pImp->_runner->error_message(S2C::ERR_INVALID_BIND_REQUEST);
		return;
	}

	if(world_manager::GetWorldLimit().nobind)
	{
		pImp->_runner->error_message(S2C::ERR_CANNOT_BIND_HERE);
		return;
	}

	//״̬
	_mode = MODE_REQUEST;
	_request_target = target;
	_timeout = NORMAL_TIMEOUT;

	//Ϣ
	pImp->SendTo<0>(GM_MSG_PLAYER_BIND_REQUEST,target,0);

}

void
player_bind::PlayerLinkInvite(gplayer_imp * pImp, const XID & target)
{
	if(pImp->GetPlayerLimit(PLAYER_LIMIT_NOBIND))//ֹ
		return;
	
	if(pImp->IsPlayerFemale())
	{
		pImp->_runner->error_message(S2C::ERR_INVALID_GENDER);
		return;
	}

	//Լ״̬
	//ܹ 1: 2:ڱ 3:ûҪ 4:ˮ 5:...
	if(_mode || !pImp->CheckPlayerBindInvite() || !target.IsPlayer() )
	{
		pImp->_runner->error_message(S2C::ERR_INVALID_BIND_REQUEST);
		return;
	}

	if(world_manager::GetWorldLimit().nobind)
	{
		pImp->_runner->error_message(S2C::ERR_CANNOT_BIND_HERE);
		return;
	}

	//״̬
	_mode = MODE_INVITE;
	_invite_target = target;
	_timeout = NORMAL_TIMEOUT;

	//Ϣ
	pImp->SendTo<0>(GM_MSG_PLAYER_BIND_INVITE,target,0);
}

void
player_bind::PlayerLinkReqReply(gplayer_imp * pImp, const XID & target,int param)
{
	if(pImp->IsPlayerFemale())
	{
		pImp->_runner->error_message(S2C::ERR_INVALID_GENDER);
		return;
	}

	//Լ״̬
	//ܹӦܹ
	if((_mode && _mode != MODE_INVITE ) || !pImp->CheckPlayerBindInvite() || !target.IsPlayer() || pImp->GetPlayerLimit(PLAYER_LIMIT_NOBIND))
	{
		pImp->_runner->error_message(S2C::ERR_INVALID_BIND_REQUEST);
		return;
	}

	if(world_manager::GetWorldLimit().nobind)
	{
		pImp->_runner->error_message(S2C::ERR_CANNOT_BIND_HERE);
		return;
	}

	//״̬
	_mode = MODE_PREPARE;
	_bind_target = target;
	_timeout = PREPARE_TIMEOUT;

	//Ϣ
	pImp->SendTo<0>(GM_MSG_PLAYER_BIND_REQUEST_REPLY,target,param);
}

void
player_bind::PlayerLinkInvReply(gplayer_imp * pImp, const XID & target,int param)
{
	if(!pImp->IsPlayerFemale())
	{
		pImp->_runner->error_message(S2C::ERR_INVALID_GENDER);
		return;
	}

	//Լ״̬
	//ܹӦܹ
	if((_mode && _mode != MODE_REQUEST) || !pImp->CheckPlayerBindRequest() || !target.IsPlayer() || pImp->GetPlayerLimit(PLAYER_LIMIT_NOBIND))
	{
		pImp->_runner->error_message(S2C::ERR_INVALID_BIND_REQUEST);
		return;
	}

	if(world_manager::GetWorldLimit().nobind)
	{
		pImp->_runner->error_message(S2C::ERR_CANNOT_BIND_HERE);
		return;
	}

	//״̬
	_mode = MODE_PREPARE;
	_bind_target = target;
	_timeout = PREPARE_TIMEOUT;

	//Ϣ
	pImp->SendTo<0>(GM_MSG_PLAYER_BIND_INVITE_REPLY,target,param);

}


void 
player_bind::MsgRequest(gplayer_imp * pImp, const XID & target)
{
	//
	if(pImp->IsPlayerFemale()) return;

	//յĲǼǷڿԱ״̬ܣֱӷһܾ
	//йؾж϶
	//ĿǰļӦڷǱ͵ȴ״̬
	if(_mode && ( _mode == MODE_LINKED || _mode == MODE_PREPARE)
		|| ((gplayer*)pImp->_parent)->IsInvisible()
		|| pImp->GetPlayerLimit(PLAYER_LIMIT_NOBIND))
	{
		//ֱӷһܾϢ
		pImp->SendTo<0>(GM_MSG_PLAYER_BIND_REQUEST_REPLY,target,ERR_CANNOT_BIND);
		return;
		
	}

	//֪ͨϢͻ
	pImp->_runner->player_bind_request(target);
}

void 
player_bind::MsgInvite(gplayer_imp * pImp, const XID & target)
{
	//Ů
	if(!pImp->IsPlayerFemale()) return;


	//յĲ
	if(_mode && ( _mode == MODE_LINKED || _mode == MODE_PREPARE)
		|| ((gplayer*)pImp->_parent)->IsInvisible()
		|| pImp->GetPlayerLimit(PLAYER_LIMIT_NOBIND))
	{
		//ֱӷһܾϢ
		pImp->SendTo<0>(GM_MSG_PLAYER_BIND_INVITE_REPLY,target,ERR_CANNOT_BIND);
		return;
		
	}

	//֪ͨϢͻ
	pImp->_runner->player_bind_invite(target);

}

void 
player_bind::MsgRequestReply(gplayer_imp * pImp, const XID & target, int param)
{
	//Ů
	//յĻӦܹǰԼǵǰ
	//ҵǰ״̬
	if(target != _request_target || _mode != MODE_REQUEST || pImp->GetPlayerLimit(PLAYER_LIMIT_NOBIND))
	{
		//һϢ öԷȴ״̬
		if(!param) pImp->SendTo<0>(GM_MSG_PLAYER_BIND_STOP,target, 0);
		return;
	}
	
	//ǾܾϢǰ״̬бҪĲ
	if(param)
	{
		//˲Ҫظͻ
		pImp->_runner->player_bind_request_reply(target,param);

		//ǰ״̬
		_mode = MODE_EMPTY;
		_request_target = XID(-1,-1);
		return;
	}
	
	_mode = MODE_PREPARE;
	_bind_target = target;
	_timeout = PREPARE_TIMEOUT;

	//صǳɹϢ,֮ͨ,֪ͨԷԽ״̬,Ȼз
	pImp->SendTo<0>(GM_MSG_PLAYER_BIND_PREPARE,target,0);
}

void 
player_bind::MsgInviteReply(gplayer_imp * pImp, const XID & target, int param)
{
	//
	//յĻӦ,˺ͷضӦ
	//ҵǰ״̬
	if(target != _invite_target || _mode != MODE_INVITE || !pImp->CheckPlayerBindRequest() || pImp->GetPlayerLimit(PLAYER_LIMIT_NOBIND))
	{
		//һϢ öԷȴ״̬
		if(!param) pImp->SendTo<0>(GM_MSG_PLAYER_BIND_STOP,target, 0);
		return;
	}
	
	//ǾܾϢǰ״̬бҪĲ
	if(param)
	{
		//˲Ҫظͻ
		pImp->_runner->player_bind_invite_reply(target,param);

		//ǰ״̬
		_mode = MODE_EMPTY;
		_invite_target = XID(-1,-1);
		return;
	}
	if(!pImp->EnterBindMoveState(target))
	{
		//״̬ʧ ֱӷ
		return ;
	}
	//ɶԷͰ󶨿ʼϢ

	_mode = MODE_LINKED;
	_bind_target = target;
	//Էͬ⿪ʼ,ֱӽ״̬

	//֪ͨԷʼ
	pImp->SendTo<0>(GM_MSG_PLAYER_BIND_LINK,target,0);
}

void 
player_bind::MsgPrepare(gplayer_imp *pImp, const XID & target)
{
	//յϢıȻ, ͬʱȻڵȴҵ״̬ MODE_PREPARE
	if(_mode != MODE_PREPARE || target != _bind_target || !pImp->CheckPlayerBindRequest() || pImp->GetPlayerLimit(PLAYER_LIMIT_NOBIND))
	{
		//״̬ƥĿ겻ƥ
		return;
	}
	//һǷΪ
	ASSERT(!pImp->IsPlayerFemale());

	//Էͬ⿪ʼ,ֱӽ״̬
	if(!pImp->EnterBindMoveState(target))
	{
		//״̬ʧ ֱӷ
		return ;
	}
	//״̬һ,link״̬
	_mode = MODE_LINKED;
	//ɶԷͰ󶨿ʼϢ
	pImp->SendTo<0>(GM_MSG_PLAYER_BIND_LINK,target,0);
}

void 
player_bind::MsgBeLinked(gplayer_imp * pImp, const XID & target,const A3DVECTOR & pos)
{
	if(_mode != MODE_PREPARE || _bind_target != target || !pImp->CheckPlayerBindRequest() || pImp->GetPlayerLimit(PLAYER_LIMIT_NOBIND))
	{
		//ǷԤڵ״̬򲻴
		//һԼ״̬Ƿ (ǷڿԽƶ״̬,״̬״̬һ)
		//Ƿ񷵻һϢ?
		pImp->SendTo<0>(GM_MSG_PLAYER_BIND_STOP,target, 0);
		return;
	}

	if(!pImp->EnterBindFollowState(target))
	{
		//״̬ʧֱӷ
		return;
	}
	
	_mode = MODE_FOLLOW;
	A3DVECTOR tmp = pos;
	tmp -= pImp->_parent->pos;
	pImp->StepMove(tmp);

	pImp->_runner->player_bind_start(target);
	//״̬
	
}

void 
player_bind::MsgFollowOther(gplayer_imp * pImp, const XID & target,const A3DVECTOR & pos)
{
	//ҷҪϢ
	if(_mode != MODE_FOLLOW || target != _bind_target)
	{
		//账
		//߿Ƿһֹͣlink
		if(target != _bind_target || _mode != MODE_PREPARE)
		{
			//ǵϢ˳,е״̬شϢ
			pImp->SendTo<0>(GM_MSG_PLAYER_BIND_STOP,target, 0);
		}
		return ;
	}
	//ƶ
	A3DVECTOR tmp = pos;
	tmp -= pImp->_parent->pos;
	pImp->StepMove(tmp);
//	pImp->_runner->stop_move(pos,0x7F00,0,0);
}

void 
player_bind::MsgStopLinked(gplayer_imp * pImp, const XID & target)
{
	//յȡlinkϢ 
	if((_mode == MODE_LINKED || _mode == MODE_FOLLOW ) && target == _bind_target)
	{
		pImp->_runner->player_bind_stop();
		pImp->ReturnBindNormalState();
		_mode = MODE_EMPTY;
		_bind_target = XID(-1,-1);
	}
}


void 
player_bind::Heartbeat(gplayer_imp * pImp)
{
	if(!_mode) return ;
	switch(_mode)
	{
		case MODE_REQUEST:
		_timeout --;
		if(_timeout <=0)
		{
			//ʱԿǷؿͻһϢ
			//ͬʱյǰ״̬
			_mode = MODE_EMPTY;
			_request_target = XID(-1,-1);
		}
		break;
		
		case MODE_INVITE:
		_timeout --;
		if(_timeout <=0)
		{
			//ʱԿǷؿͻһϢ
			//ͬʱյǰ״̬
			_mode = MODE_EMPTY;
			_invite_target = XID(-1,-1);
		}
		break;

		case MODE_PREPARE:
		_timeout --;
		if(_timeout <=0)
		{
			//ʱԿǷؿͻһϢ
			//ͬʱյǰ״̬
			_mode = MODE_EMPTY;
			_bind_target = XID(-1,-1);
		}
		break;

		case MODE_LINKED:
		case MODE_FOLLOW:
		//״̬ҪԶ ͬʱ
		{
			//ûгʱзΧλõж
			world::object_info info;
			if(!pImp->_plane->QueryObject(_bind_target,info)
					|| (info.state & world::QUERY_OBJECT_STATE_ZOMBIE)
					|| (info.pos.squared_distance(pImp->_parent->pos)) >= 50.f*50.f)
			{
				//ѯ,߾Զ ˳
				pImp->ReturnBindNormalState();
				pImp->_runner->player_bind_stop();
				_mode = MODE_EMPTY;
				_bind_target = XID(-1,-1);
			}
			else
			{
				//ÿ볤Ԫ5
				pImp->ModifyAP(5);
			}
		}

		break;
	}
}

void 
player_bind::PlayerCancel(gplayer_imp *pImp)
{
	ASSERT(_mode == MODE_LINKED || _mode == MODE_FOLLOW);

	//Էһֹͣ󶨵Ϣ
	pImp->SendTo<0>(GM_MSG_PLAYER_BIND_STOP,_bind_target, 0);
	
	//תƵ״̬ 
	pImp->ReturnBindNormalState();
	pImp->_runner->player_bind_stop();
	_mode = MODE_EMPTY;
	_bind_target = XID(-1,-1);
}

