#ifndef MD5_H
#define MD5_H

#include <stdint.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    uint32_t state[4];
    uint32_t count[2];
    uint8_t buffer[64];
} MD5_CTX;

void MD5_Init(MD5_CTX *context);
void MD5_Update(MD5_CTX *context, const uint8_t *input, size_t inputLen);
void MD5_Final(uint8_t digest[16], MD5_CTX *context);

// Convenience function that matches OpenSSL's MD5 function signature
void MD5(const uint8_t *data, size_t len, uint8_t digest[16]);

#ifdef __cplusplus
}
#endif

#endif // MD5_H

