#ifndef __ONLINE_GAME_IOLIB_THREAD_H__
#define __ONLINE_GAME_IOLIB_THREAD_H__
#include "threadpool.h"
#include "mutex.h"
#include "gnet_timer.h"
#include "protocol.h"
#include <map>

namespace GNET
{       
	namespace Thread
	{       
		typedef GNET::Runnable Runnable;
		typedef GNET::Mutex Mutex;
		typedef GNET::RWLock RWLock;
		typedef GNET::Mutex SpinLock;


		class Pool
		{
			public:
			static ThreadPool _pool;
			static int Run()
			{
				return -1;
			}

			static inline void AddTask(Runnable * task, bool)
			{
				_pool.AddTask(task);
			}

			static inline void AddTask(Runnable * task)
			{
				_pool.AddTask(task);
			}
		};

#ifndef ACCURATE_THREAD_CONDITION
		//Condition򻯰ʵ֣ÿNotifyAllֻܻһ
		class Condition
		{
			int _cond;	// 0ʱʾ¼
			Condition(const Condition& rhs){ }
			public:
			~Condition ()
			{
				NotifyAll();
				NotifyAll();
				NotifyAll();
			}
			explicit Condition( ): _cond (0){}
			int Wait( Mutex & mutex ); 
			int TimedWait( Mutex & mutex, int nseconds );
			int NotifyOne( );
			int NotifyAll( ) 
			{
				NotifyOne();	//ֻһ, жٸ߳Waitûͳơϣϲܹͳһ£ȻNotifyAll
				return 0;
			}
		};
#else
		//Ӱ棬ȷԵǰȴ߳̽м
		class Condition
		{
			int _cond;	// 0ʱʾ¼
			int _wait_num;	//ж߳ڵ, ҪʵNotifyAll.
			Mutex _lock;
			Condition(const Condition& rhs){ }
			public:
			~Condition ();
			explicit Condition(): _cond (0),_wait_num(0){}
			int Wait( Mutex & mutex ); 
			int TimedWait( Mutex & mutex, int nseconds);
			int NotifyOne();
			int NotifyAll(); 
		};
#endif
	}

	class ReconnectTask: public Thread::Runnable
	{
		public:
			PManager* manager;

			ReconnectTask(PManager* m,int priority): Runnable(priority),manager(m) {}
			void Run()
			{
				manager->InitClient(manager->GetIOMan());
				delete this;
			}
	};
	class StaticReconnectTask: public Thread::Runnable	//ͷŵİ汾
	{
		public:
			PManager* manager;

			StaticReconnectTask(PManager* m,int priority): Runnable(priority),manager(m) {}
			void Run()
			{
				manager->InitClient(manager->GetIOMan());
			}
	};
}

namespace GNET
{
	namespace Thread
	{
		class HouseKeeper : public Timer::Observer
		{
			private:
				typedef std::multimap<int, Runnable*>   TimerTaskQueue;
				TimerTaskQueue  tasks;
				Thread::Mutex   locker_tasks;
				Timer   timer;
				ThreadPool  *th_pool;

				void Update();
			public:
				//캯ΪpublicжHouseKeeper,ÿthreadpoolͬǵ
				HouseKeeper(ThreadPool *pool = &Pool::_pool) : locker_tasks("Thread::HouseKeeper::locker_tasks"), th_pool(pool) { }
				void AddTask( Runnable * pTask, int waitsecs )
				{
					Thread::Mutex::Scoped lock(locker_tasks);
					tasks.insert( std::make_pair(timer.Elapse() + waitsecs, pTask) );
				}
				static HouseKeeper& GetInstance(ThreadPool* p = &Pool::_pool); // threadpoolȡInstanceûеĻᴴһHouseKeeper
				static void AddTimerTask( Runnable * pTask, int waitsecs ) //ע⣺ĬϵThreadPoolӦHouseKeeperTask
				{
					GetInstance().AddTask( pTask, waitsecs );
					// IntervalTimer::Schedule( pTask,  waitsecs * 1000000 / IntervalTimer::Resolution() );
				}
		};

	};

};

#endif
