/*
 *	ͷļҪʵݣ
 *	ЭĻ class ProcotolΪЭϵSession class PSession һӺһЭĹPManager 
 *	RPC/ProxyRPCĻ class TimerProtocol; RPCʱʹ class RpcTimeoutManager
 *
 *	ߣ 
 *	޸ģ ϵȫ䶯˹ÿManagerЭĸдд ļֻGCCʹ
 *	ʱ䣺2009-07
 *	˾ʱ
 *
*/
#ifndef __PROTOCOL_H_
#define __PROTOCOL_H_

#include <vector>
#include <set>
#include <hashmap.h>
#include <sstream>
#include "marshal.h"
#include "gnet_timer.h"
#include "mutex.h"
#include "threadpool.h"
#include "netsession.h"
#include "log.h"

namespace GNET
{

class PSession;
class PManager;
class ProtocolStubManager;
class IOMan;
class ActiveIO;
class PassiveIO;
class TimerProtocol;

typedef uint32_t PROTOCOL_TYPE;
typedef uint32_t SESSION_ID;
enum
{
	INVALID_SESSION_ID = 0
};

class Protocol : public Marshal
{
public:
	struct Data {
	/*	DataӦʵֵĺ ЩrpcgenԶɣԶЭҪд
		ʵӦʵȷĺӰ߼
		PROTOCOL_TYPE GetType() const;								//Э
		GNET::Marshal::OctetsStream& marshal(GNET::Marshal::OctetsStream & os) const;		//
		const GNET::Marshal::OctetsStream& unmarshal(const GNET::Marshal::OctetsStream &os);	//лָ
		int PriorPolicy( ) const;								//ȼ 0ʾֱpollio̴߳
		bool SizePolicy(size_t size) const;							//СǷϷ
		unsigned int MaxSize()	const;								//DataܴСǶ
		
		Ӱ߼ĺӰ־Ϣ
		std::stringstream& trace(std::stringstream& os) const;					//dumpЭ
		const char *GetName() const;								//Э־
		*/
	};
#ifdef __OLD_IOLIB_COMPATIBLE__
	typedef PROTOCOL_TYPE Type;			//Զ
	typedef PManager Manager;			//Զ
	Type type;
#endif
protected:
	Protocol() {}
	Protocol(PROTOCOL_TYPE type, ProtocolStubManager *stubman);
	Protocol(PROTOCOL_TYPE type);
	virtual ~Protocol(){}
public:
#ifdef __OLD_IOLIB_COMPATIBLE__
	virtual PROTOCOL_TYPE GetType() const { return type;}	//Դ
	Protocol(const Protocol& rhs):type(rhs.type){}
	static ActiveIO*  Client(PManager * mananger);		//Clientʽmanager
	static PassiveIO* Server(PManager * mananger);		//Serverʽmanager
	static bool	  Dummy(PManager *manager);		//Dummyʽmanager,ַʽ£κζ˿ڣֻAttachSession
	static ActiveIO*  Client(PManager * mananger,const NetSession::Config & cfg);	//Clientʽmanager,ַָ˿ڵ
	static PassiveIO* Server(PManager * mananger,const NetSession::Config & cfg);	//Serverʽmanager,ַָ˿ڵ
#else
	virtual PROTOCOL_TYPE GetType() const= 0;		//Э
	Protocol(const Protocol& rhs){}
#endif

	virtual void Process(PManager *, SESSION_ID sid) = 0;	//ЭĴ
	virtual Protocol *Clone() const = 0;
	virtual void Destroy() { delete this; }
	virtual int  PriorPolicy() const { return 0; }		//ЭĴȼɿг֤˳, Ч˳GetSequenceӿڡ ڼģʽ£ķֵSequence֮á
	virtual unsigned int MaxPolicySize() const {return 0;}	//0ʾδencodeŻ
	virtual bool SizePolicy(size_t) const { return true; }	//ЭСļ
	virtual int GetSequence() const { return -1;}		//ǷҪ֤˳ <0ʾ˳򣬷˳
	virtual const char *GetName() const { return "noname"; }//Эƣڵ
	virtual std::string trace() const {return std::string();}	//Эݣڵ

	void Encode(Marshal::OctetsStream& os) const ;		 //Э ⺯ʵϵPManagerĽӿ

	class Exception 
	{
	public:
	 	enum ECODE 
		{ 
			GENERIC,	//ͨôδ֪)
			STATE, 		//ǰSessionStateЭ
			SIZE, 		//յЭ鳤ȳ󳤶
			TYPE, 		//յδ֪Э
			UNMARSHAL,	//ڽЭunmarshalʱ
		};

		ECODE code;		//쳣
		SESSION_ID sid;		//쳣session
		PROTOCOL_TYPE type;	//쳣Э
		size_t size;		//쳣ʱsize
		std::string state_name; //쳣ʱstate
		int loglevel;

		Exception():code(GENERIC),sid(0), type(0), size(0), loglevel(LOG_DEBUG){}
		Exception(ECODE code, SESSION_ID sid, PROTOCOL_TYPE type, size_t size, const char* state_name, int loglevel):
		code(code), sid(sid), type(type), size(size), state_name(state_name), loglevel(loglevel) {}

		void Log() const
		{
			static const char *errstr[] = {"generic", "state", "size","unknown type", "unmarshal"};
			Log::log(loglevel, "Protocol %s error. sid=%d,type=%d,size=%d,state=%s",
				errstr[code], sid, type, size, state_name.c_str());
		}
	};
};

class SessionState
{
	typedef std::set<PROTOCOL_TYPE> Set;
	Set set;	//״̬Э
	Set ignore;	//ڸ״̬£յҪЭ顣յȲsetУֲignoreеЭ飬ᱻϿ.
	int timeout;
	std::string name;
	public:
	SessionState (PROTOCOL_TYPE *first, size_t len, int t = 0, const char* pname=NULL) : set(first, first+len),timeout(t)
	{ if (pname) name = pname;}
	SessionState (PROTOCOL_TYPE *first, PROTOCOL_TYPE *last, int t = 0, const char*pname = NULL) : set(first, last), timeout(t) 
	{ if (pname) name = pname;}
	void AddIgnore(PROTOCOL_TYPE t) {ignore.insert(t);} //յЭҪ
	void AddIgnore(PROTOCOL_TYPE *first, size_t len) {ignore.insert(first, first +len);}
	void AddIgnore(const SessionState *state) {ignore.insert(state->set.begin(), state->set.end());}
	bool IgnorePolicy(PROTOCOL_TYPE type) const {return ignore.find(type) != ignore.end();}
	bool TypePolicy(PROTOCOL_TYPE type) const { return set.find(type) != set.end(); } 
	bool TimePolicy(int t) const { return timeout <= 0 || t < timeout; }
	const char *GetName() const {return name.c_str();}
	void AddProtocol(PROTOCOL_TYPE type) { set.insert(type);}
};

struct FDTransferPData;
class PManager
{
	friend class PSession;
private:
	//PSessionĹ
	typedef abase::hash_map<SESSION_ID, PSession *> SessionMap;
	SessionMap _map;		//ǰsessionMAP
	RWLock _locker_session_map;	//MapĲ
	SESSION_ID _session_id;		//һSession IDÿManagerһռ
	NetSession::Config _config;	//ActiveIO,PassiveIONetSessionҪ
	PassiveIO *_assoc_passiveio;	//ManagerPassiveIO
	IOMan * _ioman;
	bool _single_thread;
	Runnable *_check_session_task;	//ڼsessionڹرպͳʱtask

	void AddSession(SESSION_ID sid, PSession *session);
	void DelSession(SESSION_ID sid, int status);
	void AbortSession(const SockAddr &sa, PSession *);
	PSession *GetSession(SESSION_ID sid);
	inline SESSION_ID NextSessionID();

	inline void ProcessProtocol(Protocol *p, SESSION_ID sid);
	static void PostEncode(PROTOCOL_TYPE, size_t size, const char *pname, const char *content);
	bool __internal_init_1(IOMan * ioman, const NetSession::Config* spec_config = NULL);
	bool __internal_init_2(IOMan * ioman);
protected:
	GNET::ThreadPool * _th_pool;		//̳߳ضָ
public:
	int protocol_count;
#ifdef __OLD_IOLIB_COMPATIBLE__
	class Session
	{
		public:
		typedef SESSION_ID ID;
		typedef SessionState State;
	};
#endif
	PManager();
	virtual ~PManager();

	//ServerClientʽPManager
	PassiveIO* InitServer(IOMan *ioman );		//Serverʽmanager,ĳ˿ڣֿܻ᷵NULL: 1.üʧ(conf::GetInstanceδ). 2.˿ѱռ
	ActiveIO*  InitClient(IOMan *ioman );		//Clientʽmanager,ĳ˿ڣüʧܼsocketʧʱ᷵NULL
	bool	   InitDummy(IOMan *ioman );		//Dummyʽmanager,ַʽ²κζ˿ڣֻⲿsession(AttachSession)
	PassiveIO* InitCopy(IOMan * ioman, const PManager * src);	//ԭһManagerúͼĶ˿ڣʹdup2һfd ̳߳زи
	PassiveIO* InitServer(IOMan *ioman, const NetSession::Config &cfg);//ضServerʽManager,ټļ
	ActiveIO* InitClient(IOMan *ioman, const NetSession::Config &cfg); //ضClientʽManager,ټļ

	void SetThreadPool(ThreadPool *pool) {_th_pool = pool;}		//Managerĳ̳߳, managerյЭ飬̳߳еProcess
	ThreadPool *GetThreadPool() {return _th_pool;}

	inline IOMan * GetIOMan() const { return _ioman;}

	//޸ĳһSessionʱSecurity
	bool SetISecurity(SESSION_ID sid, Security::Type type, const Octets &key);
	bool SetOSecurity(SESSION_ID sid, Security::Type type, const Octets &key);

	static void EncodeProtocol(const Protocol *, Marshal::OctetsStream& os);		 //Э
	static Protocol *DecodeProtocol(const Marshal::OctetsStream& is, PSession *s); 		//һнЭ, Session״̬
	Protocol *DecodeProtocol(const Marshal::OctetsStream& is) throw (Protocol::Exception); 	//һнЭ

	void RawProcessProtocol(Protocol *, SESSION_ID sid);	//ֱӶProtocolProcessᲶ׽쳣
	//sessionһЭ
	bool Send(SESSION_ID id, const Protocol *protocol, bool urg = false);
	bool Send(SESSION_ID id, const Protocol &protocol, bool urg = false) { return Send(id,&protocol,urg); }
	bool SendFD(SESSION_ID id, int fd, const Octets & o);
	bool SendFD(SESSION_ID id, int fd , const Protocol &protocol);	// for test...

	bool RawSend(SESSION_ID id, const Octets& o, bool urg = false); 	//SessionһԭʼݣݱܹȷĽ

	template<typename PDATA>
	static bool EncodeProtocolData(const PDATA & pdata, Marshal::OctetsStream& os)
	{
		//Эݽб룬osֽ, ʽΪ
		//    [Э]  [Э鳤] []
		//°棬ŻЭ鷢 ٸһλ
		//ѹЭ鳤ȣȻٶЭ鳤Ƚ
		//ҪProtocolDataṩMaxSize()
		size_t size_policy = pdata.MaxSize();
		if(size_policy == 0) size_policy = 0x19999999;
		os << Marshal::Begin;
		os << CompactUINT(pdata.GetType());
		size_t offset = os.raw_size();
		os<< CompactUINT(size_policy);
		size_t offset2 = os.raw_size();
		pdata.marshal(os);
		size_t psize = os.raw_size() - offset2;
		if (psize <= size_policy)
		{
			os << SpecCompactUINT(offset, psize, size_policy);
			os << Marshal::Commit;
			if (PollIO::VerboseMode())
			{
				std::stringstream content;
				pdata.trace(content);
				PostEncode(pdata.GetType(), os.size(), pdata.GetName(),content.str().c_str());
			}
			return true;
		}
		os << Marshal::Rollback;
		Log::log(LOG_ERR,"FATAL, Protocol Size Excceed(type=%d,size=%d).", pdata.GetType(), psize);
		return false;
	}

	template<typename PDATA>
	bool SendProtocolData(SESSION_ID id, const PDATA * pdata, bool urg = false)
	{
		return SendProtocolData(id, *pdata, urg);
	}

	template<typename PDATA>
	bool SendProtocolData(SESSION_ID id, const PDATA & pdata, bool urg = false)
	{
		Marshal::OctetsStream os;
		if (EncodeProtocolData(pdata, os))
		{
			return RawSend(id, os, urg);
		}
		return false;
	}

#ifdef __OLD_IOLIB_COMPATIBLE__
	bool Close(SESSION_ID id, int status=CLOSE_ACTIVE, int delay_secs =0) { return CloseSession(id, status, delay_secs);}
	bool ChangeState(SESSION_ID id, SessionState *state, bool strict = true){return ChangeSessionState(id, state, strict);}
	void SetVerbose(SESSION_ID sid, int priority){ SetSessionLogPriority(sid, priority);}
#endif
	bool CloseSession(SESSION_ID id, int status=CLOSE_ACTIVE, int delay_secs = 0); 		//رһsession, delay_secsָӳٶ೤ʱرգλΪ룩
												//ӳڼ䣬SessionκЭ飬ԷЭ,൱ڵر
												//ӳڼӶϵӳ٣ֱӽر״̬
	bool ChangeSessionState(SESSION_ID id, SessionState *state, bool strict = true); 	//ıһsessionState, ϸstrictζŵյstateжЭ飬Session
	virtual void CheckSessionTimePolicy() {}				//SessionǷʱ, IOڲѾ IsStatePolicyEnableǷԶTimeoutֶ
	void __CheckSessionTimeout();						//SessionǷʱýӿֻIOڲá
	void SetSessionLogPriority(SESSION_ID sid, int priority); 		//ĳSessionLogȼ
	void SetSessionDelayMode(SESSION_ID id, bool nodelay);

	int DetachSession(SESSION_ID sid, FDTransferPData & data);		//Sessionӹ(OnDelSession)һfd,FDTransferPDatatypecustomdataгԱ κδ󷵻-1
	SESSION_ID AttachSession(int socket_fd);				//ΪĳFDӦSessionעᵽManager(OnAddSession)
										//(fdsocketѾرգעʧ,INVALID_SESSION_ID) 򷵻 Session ID
	SESSION_ID AttachSession(int fd, const FDTransferPData & data);		//ΪĳFDӦSessionҸdataָsessionԭе״̬ ֵͬ
	SESSION_ID AttachSession(const FDTransferPData & data);			//ͬϣԶFDStubManagerѰƥFD
	SESSION_ID GetCurSessionID() const;					//ȡǰSessionIDֵֻοжʹãҪؼ߼
	

	virtual void OnAddSession(SESSION_ID) = 0; 				//һSessionʱ
	virtual void OnAddSession(SESSION_ID sid, int fd); 			//fdĴ򿪲
	//Sessionرʱ
	virtual void OnDelSession(SESSION_ID) = 0;
	virtual void OnDelSession(SESSION_ID sid, int status) {  OnDelSession(sid); }

	//ʧʱ, ڿͻ
	virtual void OnAbortSession(SESSION_ID) { }
	virtual void OnAbortSession(const SockAddr&) { }
	
	virtual void OnSetTransport(SESSION_ID sid, const SockAddr& local, const SockAddr& peer) { }
	virtual bool OnCheckAccumulate(size_t) const { return true; }
	
	virtual bool OnSend(SESSION_ID id, const Protocol *protocol) { return true; }
	virtual const SessionState *GetInitState() const = 0; 		//Sessionĳʼstate

	//յδ֪Э
	virtual bool CheckUnknownProtocol(SESSION_ID , PROTOCOL_TYPE , unsigned int ) { return false; }
	virtual void DispatchUnknownProtocol(SESSION_ID , PROTOCOL_TYPE , const Marshal::OctetsStream & ) { }

	virtual void OnRecvSocket(PSession * session, Octets addr, int socket);	//sessionUnix Domain ӽյһsocketsessionѾsocketĺϷԣ
										//ĬʵǵFDStubManager::RegisterԼʵ֣ش˺
										//addrsocketıصַ˿+ⲿַ˿ڣδݵʹ
										//session״̬£PollIO̵߳õģ˲Ҫʹ÷ݺֱܹӺͼʹsessionĹ

	virtual void OnSessionException(const Protocol::Exception& e)  //ĳSession쳣eа˷쳣ʱһЩϢ
	{ 
		e.Log(); 
		CloseSession (e.sid, CLOSE_EXCEPTION); 
	}
	virtual bool IsStatePolicyEnable() const {return true;}			//ԽյЭ"""״̬"Ƿ,ԼǷ״̬ʱ
										//˫ʱΪtrueʱԷfalse
										//Ϊfalseʱյmanager޹صδ֪Э飬ᴥδ֪Э顱쳣ȻԶϿ
	virtual bool IsTrustable() const {return false;}			//ManagerеSessionǷǿŵ, ָͱmanagerЩsessionͼƭ
										//ŵĻЩڲļſһֻڲŻÿš
	virtual std::string Identification() const = 0;				//ManagerConfigļеıʶ
	virtual void OnCheckAddress(SockAddr &) const { } 			//ΪInitServerInitClientManager󶨻ʹõIPַ˿

	virtual bool LoadSessionConfig(NetSession::Config &cnf) 		//ManagerãΪActiveIOPassiveIOò, InitXXXϵʹʱáѡ񲻴confȡ
	{
		return cnf.Load(Identification().c_str());
	}
	virtual const ProtocolStubManager * GetStubManager() const; 		//Ĵ, ڼģʽ£ȫֹIO£Ҫд

public:
	//FDĺlinkӿͻ˵ⲿmanager, tunnelڲmanager, tunnel_sidǶӦUnixDomainsession
	//		fd_trans_p_typeûЭţûҪԼעЭŲȷַ, customdataûԶݣᷢ͵tunnelһˣд
	//		tunnelĿĶ˻յfdЭ fd_trans_p_type(ʵһFDTransferPData(FDTransferProtocol) ûҪֶעfd_trans_p_typeͶӦĴ
	//		tunnelĿĶ˻յfdȻaddrΪkey,fd ΪvalueFDStubManagerУȻյЭFDTransferPDataʱӦdataеaddrҵָfdȻʹAttachܹҪManagerϡ
	//		AttachSessionʱõRegister ̵OnAddSession
	static bool TransferFD(PManager *link, SESSION_ID link_sid, PManager * tunnel, SESSION_ID tunnel_sid, PROTOCOL_TYPE fd_trans_p_type, const Octets & customdata);
	//ڷַЭ鵽̳֮߳ǰٴ޸ȼ˳šţrpcalls.xmlеΪ׼, ʹõ̳߳ء
	//sequencegroupΪ-1ʱʾû˳Żš
	//priorΪ0ʱֱӴ sequencegroupС0ʱThreadPoolPolicyAddTask
	//groupС0ʱgroup_seq
	//ע⣺1.ProxyRpcԣSendManagerRecvManagerͬһЭĴӦȫͬ
	//	2.ЭProcessRpcClientServerOnTimeout,ԼProxyPostProcess,Delivery,OnTimeoutʱѾ˺ʵ̳߳
	virtual void TranslateProtocolAttr(const Protocol *p, SESSION_ID sid, GNET::ThreadPool* &thpool, int & prior, int & sequence, int & group, int & group_seq) {}
};

class ProtocolStubManager
{
	typedef abase::hash_map<PROTOCOL_TYPE, abase::pair<Protocol*, bool> > StubMap;
	StubMap _map;
public:
	ProtocolStubManager() {}
	~ProtocolStubManager();

	bool InsertStub(Protocol*);			//Э(ɵͷŴ)
	bool InsertStub(PROTOCOL_TYPE type, Protocol*);	//Protocolڹ죬вܵGetType()ʱ(ɵͷŴ)
	bool InsertStub2(PROTOCOL_TYPE type, Protocol*);	//StubManagerͷ
	const Protocol *GetStub(PROTOCOL_TYPE type) const; 	//ȡ
	Protocol * CreateProtocol(PROTOCOL_TYPE type) const; 	//һЭ

	static ProtocolStubManager * GetGlobalStub();	//ּԶṩȫִ
};

class FDStubManager		//ڴFDʱάݽṹڴfdֲܷڶManagerFDStubManagerȫֵ
{
	static FDStubManager _manager;
	typedef std::pair<int,time_t> FD_ELEMENT;
	typedef std::map<Octets, FD_ELEMENT > MAP;
	MAP _fd_map;
	time_t _last_checktimeout;

	GNET::Mutex _locker;
public:
	enum
	{
		CHECK_INTERVAL = 10,	//ÿһγʱ
		CHECK_TIMEOUT = 30,	//30볬ʱʱ䣬ӦѾ㹻
	};
	static FDStubManager & GetInstance() { return _manager;}

	FDStubManager():_last_checktimeout(0) {}

	void Register(Octets addr, int fd);				//һfd
	int FindAndGet(Octets addr);					//ȡһfd
	void CheckTimeout(int timeout);					//鳬ʱ	ڵãڲʱÿ10һ

};

struct FDTransferPData  : public Protocol::Data
{
	PROTOCOL_TYPE type;
	Octets addr;
	Octets o_plainbuf;
	Octets o_outputbuf;
	Octets o_securebuf;
	Octets i_securebuf;
	Octets custom_buf;

public:
	FDTransferPData():type((PROTOCOL_TYPE)-1) {}	//ĬһЧtype 
	FDTransferPData(PROTOCOL_TYPE type):type(type) {}

	PROTOCOL_TYPE GetType() const { return type;}
	GNET::Marshal::OctetsStream& marshal(GNET::Marshal::OctetsStream & os) const
	{
		os << addr << o_plainbuf << o_outputbuf << o_securebuf << i_securebuf << custom_buf;
		return os;
	}

	const GNET::Marshal::OctetsStream& unmarshal(const GNET::Marshal::OctetsStream &os)
	{
		os >> addr >> o_plainbuf >> o_outputbuf >> o_securebuf >> i_securebuf >> custom_buf;
		return os;
	}

	int PriorPolicy( ) const {return 110;}	//һ֣FDTransferProtocol
	bool SizePolicy(size_t size) const {return true;}
	unsigned int MaxSize() const {return 0x19999999;}
		
	std::stringstream& trace(std::stringstream& os) const { os << "FDTransferPData:NULL"; return os;}
	const char *GetName() const { return "FDTransferPData";}
};

//FDTransferProtocolģ壬ҪFDڽն˴شಢֶע
class FDTransferProtocol : public Protocol
{
protected:
	FDTransferPData  _data;
public:

	FDTransferProtocol(){}
	FDTransferProtocol(PROTOCOL_TYPE type, ProtocolStubManager *stubman):Protocol(type, stubman){ _data.type = type;}
	FDTransferProtocol(PROTOCOL_TYPE type):Protocol(type){ _data.type = type;}
	FDTransferProtocol(const FDTransferProtocol &rhs) : _data(rhs._data){}

	PROTOCOL_TYPE GetType() const {return _data.GetType();}
	OctetsStream& marshal(OctetsStream & os) const { return _data.marshal(os); }
	const OctetsStream& unmarshal(const OctetsStream &os) { return _data.unmarshal(os); }
	const char * GetName() const { return _data.GetName(); }
	std::string trace() const { std::stringstream os; return _data.trace(os).str();}
	int PriorPolicy() const { return _data.PriorPolicy();}
	bool SizePolicy(size_t size) const { return _data.SizePolicy(size); }
};

class TimerProtocol: public Protocol
{
protected:
	Timer _timer;
public:
	TimerProtocol(){}
	TimerProtocol(PROTOCOL_TYPE type, ProtocolStubManager *stubman):Protocol(type, stubman){}
	TimerProtocol(PROTOCOL_TYPE type):Protocol(type){}
	TimerProtocol(const TimerProtocol& rhs):Protocol(rhs){ _timer.Reset();}
	virtual ~TimerProtocol() {}
	virtual void OnTimeout() =0;
	virtual bool TimePolicy(int t) const {return t <5;}
	bool  CheckTime() const { return TimePolicy(_timer.Elapse());}
};

class ChannelProtocol : public Protocol         //ͨЭ, ЭаһЭ
{
public:
	ChannelProtocol() {}
	ChannelProtocol(PROTOCOL_TYPE type, ProtocolStubManager *stubman):Protocol(type,stubman){}
	ChannelProtocol(PROTOCOL_TYPE type):Protocol(type) {}

	typedef std::set<PROTOCOL_TYPE> PSET;
	virtual const PSET& GetProtocolSet() const = 0;		//ͨЭЭб
	virtual Octets& GetChannelData() = 0;			//Э(Э)д麯ϣԭIOrpcgenݣѱ

	void SetupChannelData(const Protocol &p) {SetupChannelData(&p);}        //Э
	void SetupChannelData(const Protocol *p)
	{
		const PSET & Set = GetProtocolSet();
		ASSERT(Set.find(p->GetType()) != Set.end());

		Marshal::OctetsStream os;
		PManager::EncodeProtocol(p,os);
		GetChannelData() = os;
	}
	template<typename PDATA>
	void SetupChannelPData(const PDATA &pdata)		//ProtocolDataķʽЭ
	{
		Marshal::OctetsStream os;
		PManager::EncodeProtocolData(pdata, os);
		GetChannelData() = os;
	}
	bool CheckChannelData();				//ЭǷϷЭǷЭбУ,ݴʱfalse,һlog
	Protocol *DecodeChannelData(PManager *manager);		//ͨЭݣЭ󣬸ЭʹDestroyݸʽʱ᷵NULL,һlog
};
}

#endif

