/*
 * Decompiled with CFR 0.152.
 */
package expr;

import java.util.HashMap;
import java.util.Map;

public final class Token {
    public static final int END = 0;
    public static final int ERROR = 1;
    public static final int ID = 2;
    public static final int NUM = 3;
    public static final int FLOAT = 4;
    public static final int ASSIGN = 5;
    public static final int EQ = 6;
    public static final int LT = 7;
    public static final int LTE = 8;
    public static final int GT = 9;
    public static final int GTE = 10;
    public static final int PLUS = 11;
    public static final int MINUS = 12;
    public static final int TIMES = 13;
    public static final int OVER = 14;
    public static final int LPAREN = 15;
    public static final int RPAREN = 16;
    public static final int SEMI = 17;
    public static final int SELECT = 18;
    public static final int COLON = 19;
    public static final int MEMSL = 20;
    public static final int LSQRBRACKET = 21;
    public static final int RSQRBRACKET = 22;
    public static final int COMMA = 23;
    public static final int NEWLINE = 24;
    public static final int AND = 25;
    public static final int OR = 26;
    public static final int NOT = 27;
    public static final int MOD = 28;
    public static final int NE = 29;
    public static final int ARRAY = 30;
    public static final int LBLOCK = 31;
    public static final int RBLOCK = 32;
    public static final int ANNOUNCE = 33;
    public static final int IF = 34;
    public static final int THEN = 35;
    public static final int ELSE = 36;
    public static final int REPEAT = 37;
    public static final int UNTIL = 38;
    public static final int READ = 39;
    public static final int WRITE = 40;
    public static final int OPERATOR = 50;
    public static final int FUNCTION = 51;
    public static final int STATIC = 101;
    public static final int CONST = 102;
    public static final int EXTERN = 103;
    private static final Map reserved_keywords = new HashMap();

    public static int LookUp(String tokenString) {
        Integer token = (Integer)reserved_keywords.get(tokenString);
        if (token == null) {
            return 2;
        }
        return token;
    }

    public static void DisplayToken(int token, String tokenString) {
        switch (token) {
            case 0: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: {
                System.out.println(tokenString);
                break;
            }
            case 39: {
                System.out.println("read " + tokenString);
                break;
            }
            case 5: {
                System.out.println("Op: =");
                break;
            }
            case 30: {
                System.out.println("Array:");
                break;
            }
            case 7: {
                System.out.println("Op: <");
                break;
            }
            case 9: {
                System.out.println("Op: >");
                break;
            }
            case 8: {
                System.out.println("Op: <=");
                break;
            }
            case 10: {
                System.out.println("Op: >=");
                break;
            }
            case 6: {
                System.out.println("Op: ==");
                break;
            }
            case 29: {
                System.out.println("Op: !=");
                break;
            }
            case 25: {
                System.out.println("Op: &");
                break;
            }
            case 26: {
                System.out.println("Op: |");
                break;
            }
            case 27: {
                System.out.println("Op: !");
                break;
            }
            case 28: {
                System.out.println("Op: %");
                break;
            }
            case 15: {
                System.out.println("(");
                break;
            }
            case 16: {
                System.out.println(")");
                break;
            }
            case 17: {
                System.out.println(";");
                break;
            }
            case 11: {
                System.out.println("Op: +");
                break;
            }
            case 12: {
                System.out.println("Op: -");
                break;
            }
            case 13: {
                System.out.println("Op: *");
                break;
            }
            case 14: {
                System.out.println("Op: /");
                break;
            }
            case 18: {
                System.out.println("SELECT ?");
                break;
            }
            case 19: {
                System.out.println(":");
                break;
            }
            case 20: {
                System.out.println("Op: .");
                break;
            }
            case 21: {
                System.out.println("Op: [*]");
                break;
            }
            case 22: {
                System.out.println("index *]");
                break;
            }
            case 4: {
                System.out.println("FLOAT: " + tokenString);
                break;
            }
            case 3: {
                System.out.println("NUM: " + tokenString);
                break;
            }
            case 2: {
                System.out.println("ID: " + tokenString);
                break;
            }
            case 51: {
                System.out.println("FUNCTION: " + tokenString);
                break;
            }
            case 33: {
                System.out.println("Announce: " + tokenString);
                break;
            }
            case 1: {
                System.out.println("ERROR: " + tokenString);
                break;
            }
            default: {
                System.out.println("Unkown token" + token);
            }
        }
    }

    static {
        reserved_keywords.put("static", new Integer(101));
        reserved_keywords.put("const", new Integer(102));
        reserved_keywords.put("extern", new Integer(103));
    }
}

