/*
 * Decompiled with CFR 0.152.
 */
package expr;

import expr.OGNode;
import expr.TypeNode;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ObjectGraph {
    public static final Map reserved_type = new HashMap();
    public static final int MAX_RESERVED_TYPE = 30;
    private HashMap str2int = new HashMap();
    private TreeMap int2str = new TreeMap();
    private TreeMap typelist = new TreeMap();
    private int identifier_id = 30;
    private static TypeNode current_typenode;

    private boolean IsIdentifierExist(String identifier) {
        return this.str2int.containsKey(identifier);
    }

    private int AddNewIdentifier(String identifier) {
        if (this.IsIdentifierExist(identifier)) {
            return 0;
        }
        this.str2int.put(identifier, new Integer(this.identifier_id));
        this.int2str.put(new Integer(this.identifier_id), identifier);
        return this.identifier_id++;
    }

    public int FindMemberNode(int typenode_id, int member_name_id) {
        if (typenode_id == 0 || member_name_id == 0) {
            return 0;
        }
        if (this.typelist.containsKey(new Integer(typenode_id))) {
            TypeNode tn = (TypeNode)this.typelist.get(new Integer(typenode_id));
            for (int i = 0; i < tn.member_list.size(); ++i) {
                if (((OGNode)tn.member_list.get((int)i)).name != member_name_id) continue;
                return ((OGNode)tn.member_list.get((int)i)).type;
            }
            return 0;
        }
        return 0;
    }

    public int GetIdentifier(String identifier) {
        if (this.str2int.containsKey(identifier)) {
            return (Integer)this.str2int.get(identifier);
        }
        return 0;
    }

    public int GetTypeID(String identifier) {
        int id = this.GetIdentifier(identifier);
        if (id == 0) {
            return 0;
        }
        TypeNode t = (TypeNode)this.typelist.get(new Integer(id));
        if (t == null) {
            return 0;
        }
        return t.type;
    }

    public boolean AddTypeNode(String _type) {
        if (!this.IsIdentifierExist(_type)) {
            if (reserved_type.containsKey(_type)) {
                Integer _type_id = (Integer)reserved_type.get(_type);
                this.str2int.put(_type, _type_id);
                this.int2str.put(_type_id, _type);
                current_typenode = new TypeNode(_type_id);
            } else {
                current_typenode = new TypeNode(this.AddNewIdentifier(_type));
            }
            this.typelist.put(new Integer(ObjectGraph.current_typenode.type), current_typenode);
            return true;
        }
        int id = this.GetIdentifier(_type);
        if (this.typelist.containsKey(new Integer(id))) {
            System.out.println("ERROR: AddTypeNode::identity typenode exist.");
            return false;
        }
        current_typenode = new TypeNode(id);
        this.typelist.put(new Integer(id), current_typenode);
        return true;
    }

    public boolean AddMemberNode(String _type, String _name) {
        if (ObjectGraph.current_typenode.type == 0) {
            return false;
        }
        int type_id = this.IsIdentifierExist(_type) ? this.GetIdentifier(_type) : this.AddNewIdentifier(_type);
        int name_id = this.IsIdentifierExist(_name) ? this.GetIdentifier(_name) : this.AddNewIdentifier(_name);
        ObjectGraph.current_typenode.member_list.add(new OGNode(type_id, name_id));
        return true;
    }

    public void Display() {
        for (TypeNode typenode : this.typelist.values()) {
            System.out.println("type:(" + typenode.type + ")" + (String)this.int2str.get(new Integer(typenode.type)));
            for (int i = 0; i < typenode.member_list.size(); ++i) {
                OGNode ognode = (OGNode)typenode.member_list.get(i);
                System.out.println("\ttype=(" + ognode.type + ")" + (String)this.int2str.get(new Integer(ognode.type)) + "\tname=(" + ognode.name + ")" + (String)this.int2str.get(new Integer(ognode.name)));
            }
        }
    }

    static {
        reserved_type.put("bool", new Integer(1));
        reserved_type.put("char", new Integer(2));
        reserved_type.put("int", new Integer(3));
        reserved_type.put("long", new Integer(4));
        reserved_type.put("float", new Integer(5));
        reserved_type.put("double", new Integer(6));
    }
}

