/*
 * Decompiled with CFR 0.152.
 */
package expr;

import expr.OGException;
import expr.ObjectGraph;
import expr.Scanner;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class OGParser {
    private Scanner scanner;
    private BufferedReader buf;
    private int token;

    public OGParser(String fn) throws FileNotFoundException {
        this.buf = new BufferedReader(new FileReader(fn));
        this.scanner = new Scanner(this.buf);
    }

    public OGParser(InputStream is) {
        this.buf = new BufferedReader(new InputStreamReader(is));
        this.scanner = new Scanner(this.buf);
    }

    private void match(int expected_token) throws OGException {
        if (this.token != expected_token) {
            if (expected_token == 7 || expected_token == 9) {
                throw new OGException("^Brackets unmatched.\n");
            }
            if (expected_token == 5) {
                throw new OGException("^Miss assignment.\n");
            }
            if (expected_token == 17) {
                throw new OGException("^Miss semicolon.\n");
            }
            if (expected_token == 23) {
                throw new OGException("^Miss comma.\n");
            }
            if (this.token == 1) {
                throw new OGException("^Invalid token.\n");
            }
            throw new OGException("^Unexpected token.\n");
        }
        this.token = this.scanner.getToken();
    }

    private void newStmtSequence(ObjectGraph og) throws OGException {
        while (this.token != 0) {
            if (this.token == 2) {
                this.newStatement(og);
            }
            this.match(17);
        }
    }

    private void newStatement(ObjectGraph og) throws OGException {
        og.AddTypeNode(new String(this.scanner.getTokenName()));
        this.match(2);
        this.match(5);
        this.newMemberNode(og);
        while (this.token != 17) {
            this.match(23);
            this.newMemberNode(og);
        }
    }

    private void newMemberNode(ObjectGraph og) throws OGException {
        this.match(7);
        if (this.token == 9) {
            this.match(9);
            return;
        }
        String member_name = new String(this.scanner.getTokenName());
        this.match(2);
        this.match(23);
        og.AddMemberNode(new String(this.scanner.getTokenName()), member_name);
        this.match(2);
        this.match(9);
    }

    public void Parse(ObjectGraph og) throws OGException {
        this.token = this.scanner.getToken();
        try {
            this.newStmtSequence(og);
        }
        catch (OGException e) {
            System.out.println("Error: line " + this.scanner.getLineno());
            System.out.println("\t" + this.scanner.getSourceCode());
            System.out.print("\t");
            for (int i = this.scanner.getLinepos(); i != 0; --i) {
                System.out.print(" ");
            }
            System.out.println(e.getMessage());
            throw e;
        }
    }

    public static void main(String[] args) {
        try {
            OGParser ogparser = new OGParser(args[0]);
            ObjectGraph og = new ObjectGraph();
            ogparser.Parse(og);
            og.Display();
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + args[0] + " not found.");
        }
        catch (Exception e) {
            System.out.println("catch exception in main.");
            e.printStackTrace();
        }
    }
}

