/*
 * Decompiled with CFR 0.152.
 */
package expr;

import expr.ObjectGraph;
import expr.Scanner;
import expr.SyntaxErrorException;
import expr.SyntaxTree;
import expr.TreeNode;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class ExprParser {
    private Scanner scanner;
    private BufferedReader buf;
    private int token;
    private ObjectGraph og;
    public static final int FILE = 1;
    public static final int STRING = 2;

    public ExprParser(String str, int src_type) throws FileNotFoundException {
        if (src_type == 1) {
            this.buf = new BufferedReader(new FileReader(str));
            this.scanner = new Scanner(this.buf);
        } else if (src_type == 2) {
            this.scanner = new Scanner(new String(str));
        }
    }

    private void match(int expected_token) throws SyntaxErrorException {
        if (this.token == expected_token) {
            this.token = this.scanner.getToken();
            while (this.token == 101 || this.token == 103 || this.token == 102) {
                this.token = this.scanner.getToken();
            }
        } else {
            if (expected_token == 16 || expected_token == 15) {
                throw new SyntaxErrorException("^Brackets unmatched.", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
            if (expected_token == 5) {
                throw new SyntaxErrorException("^miss `='", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
            if (expected_token == 17) {
                throw new SyntaxErrorException("^miss `;'", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
            if (expected_token == 23) {
                throw new SyntaxErrorException("^miss `,'", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
            if (expected_token == 19) {
                throw new SyntaxErrorException("^miss `:'", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
            if (expected_token == 18) {
                throw new SyntaxErrorException("^miss `?'", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
            if (this.token == 1) {
                throw new SyntaxErrorException("^Invalid symbol.", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
            throw new SyntaxErrorException("^Unexpected symbol.", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
        }
    }

    private void throwOutOfMemory() throws SyntaxErrorException {
        throw new SyntaxErrorException("Out of memory.", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
    }

    private TreeNode stmt_sequence() throws SyntaxErrorException {
        TreeNode t;
        TreeNode p = t = this.statement();
        if (null == t) {
            this.throwOutOfMemory();
        }
        while (this.token != 0 && this.token != 36 && this.token != 38) {
            TreeNode q = this.statement();
            if (null == q) {
                this.throwOutOfMemory();
            }
            p.sibling = q;
            p = q;
        }
        return t;
    }

    private TreeNode statement() throws SyntaxErrorException {
        TreeNode t = null;
        switch (this.token) {
            case 34: {
                t = this.if_stmt();
                break;
            }
            case 37: {
                t = this.repeat_stmt();
                break;
            }
            case 39: {
                t = this.read_stmt();
                this.match(17);
                break;
            }
            case 40: {
                t = this.write_stmt();
                this.match(17);
                break;
            }
            case 2: {
                int type = this.og.GetTypeID(this.scanner.getTokenName());
                if (type != 0) {
                    t = this.announce_stmt(type);
                    this.match(17);
                    break;
                }
                t = this.exp();
                this.match(17);
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 15: {
                t = this.exp();
                this.match(17);
                break;
            }
            case 51: {
                t = this.exp();
                this.match(17);
                break;
            }
            default: {
                throw new SyntaxErrorException("^Unexpected symbol.", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
        }
        return t;
    }

    private TreeNode function() throws SyntaxErrorException {
        TreeNode t = SyntaxTree.CreateExprNode(6, this.scanner.getLineno());
        if (null == t) {
            this.throwOutOfMemory();
        }
        t.type = 51;
        this.match(51);
        this.match(15);
        t.child.add(this.exp());
        this.match(16);
        return t;
    }

    private TreeNode if_stmt() throws SyntaxErrorException {
        TreeNode t = SyntaxTree.CreateStmtNode(1, this.scanner.getLineno());
        if (null == t) {
            this.throwOutOfMemory();
        }
        this.match(34);
        t.child.add(this.exp());
        this.match(35);
        t.child.add(this.stmt_sequence());
        if (this.token == 36) {
            this.match(36);
            t.child.add(this.stmt_sequence());
        }
        this.match(0);
        return t;
    }

    private TreeNode repeat_stmt() throws SyntaxErrorException {
        TreeNode t = SyntaxTree.CreateStmtNode(4, this.scanner.getLineno());
        if (null == t) {
            this.throwOutOfMemory();
        }
        this.match(37);
        t.child.add(this.stmt_sequence());
        this.match(38);
        t.child.add(this.exp());
        return t;
    }

    private TreeNode read_stmt() throws SyntaxErrorException {
        TreeNode t = SyntaxTree.CreateStmtNode(2, this.scanner.getLineno());
        if (null == t) {
            this.throwOutOfMemory();
        }
        this.match(39);
        if (this.token == 2) {
            t.name = this.scanner.getTokenName();
            this.match(2);
        }
        return t;
    }

    private TreeNode write_stmt() throws SyntaxErrorException {
        TreeNode t = SyntaxTree.CreateStmtNode(3, this.scanner.getLineno());
        if (null == t) {
            this.throwOutOfMemory();
        }
        this.match(40);
        t.child.add(this.exp());
        return t;
    }

    private TreeNode announce_stmt(int type) throws SyntaxErrorException {
        TreeNode t = SyntaxTree.CreateStmtNode(5, this.scanner.getLineno());
        t.type = type;
        this.match(2);
        if (this.token == 2) {
            t.name = this.scanner.getTokenName();
            t.child.add(this.exp());
            return t;
        }
        throw new SyntaxErrorException("^Invalid announcement.", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
    }

    private TreeNode exp() throws SyntaxErrorException {
        TreeNode t = this.assign_exp();
        return t;
    }

    private TreeNode assign_exp() throws SyntaxErrorException {
        TreeNode t = this.select_exp();
        if (this.token == 5) {
            if (t.nodekind != 1) {
                throw new SyntaxErrorException("^Invalid assign statement.", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
            if (t.kind != 5 && (t.kind != 1 || t.op != 21)) {
                throw new SyntaxErrorException("^Invalid assign statement.", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
            TreeNode p = SyntaxTree.CreateExprNode(1, this.scanner.getLineno());
            if (null == p) {
                this.throwOutOfMemory();
            }
            p.child.add(t);
            p.name = t.name;
            p.op = this.token;
            this.match(5);
            p.child.add(this.exp());
            t = p;
        }
        return t;
    }

    private TreeNode select_exp() throws SyntaxErrorException {
        TreeNode t = this.logic_relation_exp();
        if (this.token == 18) {
            TreeNode p = SyntaxTree.CreateExprNode(1, this.scanner.getLineno());
            if (null == p) {
                this.throwOutOfMemory();
            }
            p.child.add(t);
            p.op = this.token;
            t = p;
            this.match(18);
            t.child.add(this.logic_relation_exp());
            this.match(19);
            t.child.add(this.logic_relation_exp());
        }
        return t;
    }

    private TreeNode logic_relation_exp() throws SyntaxErrorException {
        TreeNode t = this.logic_exp();
        if (this.token == 25 || this.token == 26) {
            TreeNode p = SyntaxTree.CreateExprNode(1, this.scanner.getLineno());
            if (null == p) {
                this.throwOutOfMemory();
            }
            p.child.add(t);
            p.op = this.token;
            t = p;
            this.match(this.token);
            t.child.add(this.logic_relation_exp());
        }
        return t;
    }

    private TreeNode logic_exp() throws SyntaxErrorException {
        TreeNode t = this.addminus_exp();
        if (this.token == 7 || this.token == 6 || this.token == 9 || this.token == 8 || this.token == 10 || this.token == 29) {
            TreeNode p = SyntaxTree.CreateExprNode(1, this.scanner.getLineno());
            if (null == p) {
                this.throwOutOfMemory();
            }
            p.child.add(t);
            p.op = this.token;
            t = p;
            this.match(this.token);
            t.child.add(this.addminus_exp());
        }
        return t;
    }

    private TreeNode addminus_exp() throws SyntaxErrorException {
        TreeNode t = this.multi_div_exp();
        while (this.token == 11 || this.token == 12) {
            TreeNode p = SyntaxTree.CreateExprNode(1, this.scanner.getLineno());
            if (null == p) {
                this.throwOutOfMemory();
            }
            p.child.add(t);
            p.op = this.token;
            t = p;
            this.match(this.token);
            t.child.add(this.multi_div_exp());
        }
        return t;
    }

    private TreeNode multi_div_exp() throws SyntaxErrorException {
        TreeNode t = this.factor();
        while (this.token == 13 || this.token == 14 || this.token == 28) {
            TreeNode p = SyntaxTree.CreateExprNode(1, this.scanner.getLineno());
            if (null == p) {
                this.throwOutOfMemory();
            }
            p.child.add(t);
            p.op = this.token;
            t = p;
            this.match(this.token);
            p.child.add(this.factor());
        }
        return t;
    }

    private TreeNode factor() throws SyntaxErrorException {
        TreeNode t = null;
        switch (this.token) {
            case 3: {
                t = SyntaxTree.CreateExprNode(2, this.scanner.getLineno());
                if (null == t) {
                    this.throwOutOfMemory();
                }
                t.val = Integer.valueOf(this.scanner.getTokenName());
                this.match(3);
                break;
            }
            case 4: {
                t = SyntaxTree.CreateExprNode(3, this.scanner.getLineno());
                if (null == t) {
                    this.throwOutOfMemory();
                }
                t.fval = Float.valueOf(this.scanner.getTokenName()).floatValue();
                this.match(4);
                break;
            }
            case 51: {
                t = this.function();
                break;
            }
            case 2: {
                TreeNode t1;
                TreeNode p;
                t = SyntaxTree.CreateExprNode(5, this.scanner.getLineno());
                if (null == t) {
                    this.throwOutOfMemory();
                }
                if (this.token == 2) {
                    t.name = new String(this.scanner.getTokenName());
                }
                this.match(2);
                if (this.token == 20) {
                    TreeNode t12;
                    p = SyntaxTree.CreateExprNode(1, this.scanner.getLineno());
                    if (null == p) {
                        this.throwOutOfMemory();
                    }
                    p.child.add(t);
                    p.op = this.token;
                    t = p;
                    this.match(20);
                    TreeNode tmp = t12 = this.factor();
                    while (tmp.child.size() != 0) {
                        tmp = (TreeNode)tmp.child.get(0);
                    }
                    tmp.child.add(t);
                    t = t12;
                }
                if (this.token != 21) break;
                p = SyntaxTree.CreateExprNode(1, this.scanner.getLineno());
                if (null == p) {
                    this.throwOutOfMemory();
                }
                p.child.add(t);
                p.op = this.token;
                t = p;
                this.match(21);
                t.child.add(this.exp());
                this.match(22);
                if (this.token != 20) break;
                TreeNode p1 = SyntaxTree.CreateExprNode(1, this.scanner.getLineno());
                if (null == p1) {
                    this.throwOutOfMemory();
                }
                p1.child.add(t);
                p1.op = this.token;
                t = p1;
                this.match(20);
                TreeNode tmp = t1 = this.factor();
                while (tmp.child.size() != 0) {
                    tmp = (TreeNode)tmp.child.get(0);
                }
                tmp.child.add(t);
                t = t1;
                break;
            }
            case 15: {
                this.match(15);
                t = this.exp();
                this.match(16);
                break;
            }
            case 12: {
                t = SyntaxTree.CreateExprNode(2, this.scanner.getLineno());
                if (null != t) break;
                this.throwOutOfMemory();
                break;
            }
            case 31: {
                boolean negative = false;
                this.match(31);
                t = SyntaxTree.CreateExprNode(4, this.scanner.getLineno());
                if (null == t) {
                    this.throwOutOfMemory();
                }
                t.struct_type = 1;
                TreeNode tail = t;
                while (this.token != 32) {
                    TreeNode p;
                    if (this.token == 12) {
                        this.match(12);
                        negative = true;
                    }
                    if (this.token == 3) {
                        p = SyntaxTree.CreateExprNode(2, this.scanner.getLineno());
                        if (null == p) {
                            this.throwOutOfMemory();
                        }
                        tail.child.add(p);
                        tail = p;
                        this.match(3);
                    } else {
                        p = SyntaxTree.CreateExprNode(3, this.scanner.getLineno());
                        if (null == p) {
                            this.throwOutOfMemory();
                        }
                        tail.child.add(p);
                        tail = p;
                        this.match(4);
                    }
                    if (this.token == 23) {
                        this.match(23);
                    }
                    negative = false;
                }
                this.match(32);
                break;
            }
            default: {
                throw new SyntaxErrorException("^Unexpected symbol.", this.scanner.getLineno(), this.scanner.getLinepos(), this.scanner.getSourceCode());
            }
        }
        return t;
    }

    public void Parse(SyntaxTree _st, ObjectGraph _og) throws SyntaxErrorException {
        this.token = this.scanner.getToken();
        while (this.token == 101 || this.token == 103 || this.token == 102) {
            this.token = this.scanner.getToken();
        }
        this.og = _og;
        try {
            _st.SetRoot(this.stmt_sequence());
        }
        catch (SyntaxErrorException e) {
            System.out.println("Error: line " + e.getLineno());
            System.out.println("\t" + e.getSourceCode());
            System.out.print("\t");
            for (int i = e.getLinepos(); i != 0; --i) {
                System.out.print(" ");
            }
            System.out.println(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }
}

