/*
 * Decompiled with CFR 0.152.
 */
package Cpp;

import Cpp.CppBlock;
import Cpp.CppClass;
import Cpp.CppComment;
import Cpp.CppConstructor;
import Cpp.CppCppFile;
import Cpp.CppDestructor;
import Cpp.CppField;
import Cpp.CppHeaderFile;
import Cpp.CppMemberInit;
import Cpp.CppMemberInitList;
import Cpp.CppMethod;
import Cpp.CppParameterList;
import Cpp.ExportCsv;
import Cpp.SkillRoot;
import Cpp.SkillState;
import Cpp.SkillStub;
import cn.world2.game.skilleditor.DB.DAO.JDBC.HitStatusDAOImp;
import cn.world2.game.skilleditor.DB.DAO.JDBC.SkillDAOImp;
import cn.world2.game.skilleditor.DB.DAO.JDBC.WeaponDAOImp;
import cn.world2.game.skilleditor.biz.RoleManager;
import cn.world2.game.skilleditor.biz.SkillManager;
import cn.world2.game.skilleditor.vo.HitStatus;
import cn.world2.game.skilleditor.vo.Role;
import cn.world2.game.skilleditor.vo.Skill;
import cn.world2.game.skilleditor.vo.Weapon;
import expr.CodeGen;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Generator {
    static PrintStream strtable;
    static PrintStream gbktable;
    static int retcode;

    public static PrintStream GetStream() {
        return strtable;
    }

    public static PrintStream GbkStream() {
        return gbktable;
    }

    public static void genSkills(boolean dynamic) throws Exception {
        ArrayList<Skill> allskills = new ArrayList<Skill>();
        strtable = new PrintStream((OutputStream)new FileOutputStream("skills/skillstr.txt", false), false, "UTF-16LE");
        gbktable = new PrintStream((OutputStream)new FileOutputStream("skills/skillgbk.txt", false), false, "GBK");
        byte[] header = new byte[]{-1, -2};
        strtable.write(header, 0, 2);
        strtable.print("#_index\r\n#_begin\r\n\r\n");
        gbktable.print("#_index\r\n#_begin\r\n\r\n");
        RoleManager rm = new RoleManager();
        SkillDAOImp sm = new SkillDAOImp();
        WeaponDAOImp wm = new WeaponDAOImp();
        List roles = rm.getAllRolesWithSkills();
        List<Weapon> weapons = wm.getAvailableWeapon();
        for (Role role : roles) {
            List roleskills = role.getSkills();
            for (Skill sk : roleskills) {
                String sid = sk.getId();
                Skill skill = sm.getSkillById(sid);
                skill.setRole(role);
                allskills.add(skill);
            }
        }
        int n = 1;
        int index = 0;
        ListIterator its = allskills.listIterator();
        while (its.hasNext()) {
            Skill skill;
            int counter;
            CppCppFile cfstubs = new CppCppFile("GNET");
            cfstubs.add("#include \"skill.h\"");
            HitStatusDAOImp hsd = new HitStatusDAOImp();
            LinkedList<HitStatus> allhitstatus = hsd.retrieveAllHitStatus();
            its = allskills.listIterator(index);
            for (counter = 0; counter < 256 && its.hasNext(); ++counter) {
                skill = (Skill)its.next();
                if (!Generator.genSkill(skill, allskills, weapons, allhitstatus, dynamic)) continue;
                cfstubs.add("#include \"skill" + skill.getId() + ".h\"");
                if (dynamic) {
                    cfstubs.add(new CppField("Skill" + skill.getId() + "Stub*", "__stub_Skill" + skill.getId() + "Stub = new Skill" + skill.getId() + "Stub()", false));
                    continue;
                }
                cfstubs.add(new CppField("Skill" + skill.getId() + "Stub", "__stub_Skill" + skill.getId() + "Stub", false));
            }
            cfstubs.add(new CppComment("#ifdef _SKILL_SERVER"));
            its = allskills.listIterator(index);
            for (counter = 0; counter < 256 && its.hasNext(); ++counter) {
                skill = (Skill)its.next();
                if (dynamic) {
                    cfstubs.add(new CppField("Skill" + skill.getId() + "*", "\t__stub_Skill" + skill.getId() + " = new Skill" + skill.getId() + "()", false));
                    continue;
                }
                cfstubs.add(new CppField("Skill" + skill.getId(), "\t__stub_Skill" + skill.getId(), false));
            }
            cfstubs.add(new CppComment("#endif"));
            cfstubs.write("skills/stubs" + n + ".cpp");
            ++n;
            index += 256;
        }
        strtable.close();
        gbktable.close();
    }

    public static boolean genSkill(Skill skill, List skills, List weapons, List allhitstatus, boolean dynamic) {
        System.out.println("generate Skill(roleid=" + skill.getRole().getId() + ", skillid=" + skill.getId() + ", skillname=" + skill.getName());
        SkillRoot as = null;
        String type = skill.getPassiveStatus();
        if (null == type) {
            type = new String();
        }
        type.trim();
        as = new SkillRoot(skill);
        SkillStub ss = new SkillStub(skill, skills, weapons, allhitstatus, dynamic);
        if (ss.getErrno() != 0) {
            retcode = ss.getErrno();
        }
        CppHeaderFile cf = new CppHeaderFile("skill" + skill.getId(), "GNET");
        cf.add(as);
        cf.add(ss);
        cf.write("skills/skill" + skill.getId() + ".h");
        return true;
    }

    public static void genSample() {
        CppClass cc = new CppClass("NineBoxingStub", "SkillStub");
        cc.add(SkillState.newState(1, "State1", "2000", "true", "false", "false", "", "rand()<(100-5*skill->GetLevel())", "true", "true"));
        cc.add(SkillState.newState(2, "State2", "1000", "true", "false", "false", "skill->GetPlayer()->SetMP(skill->GetPlayer()->GetMP() - 25 - skill->GetLevel() )", "false", "false", "false"));
        cc.add(new CppConstructor(cc).add(new CppParameterList()).add(new CppMemberInitList().add(new CppMemberInit("SkillStub", "NineBoxing::SKILL_ID"))).add(new CppBlock()));
        cc.add(new CppMethod("int", "GetCoolingTime", false, true, 0).add(new CppParameterList()).add(new CppBlock().add("return 30;")));
        cc.add(new CppDestructor(cc).add(new CppBlock()));
        cc.write(System.out);
    }

    public static void genSkillName() {
        RoleManager rm = new RoleManager();
        SkillManager sm = new SkillManager();
        WeaponDAOImp wm = new WeaponDAOImp();
        byte[] header = new byte[]{-1, -2};
        PrintStream ps = null;
        try {
            ps = new PrintStream((OutputStream)new FileOutputStream("skills/skill.txt", false), false, "gbk");
            ps.write(header, 0, 2);
            ps.print("#_index\r\n");
            ps.print("#_begin\r\n");
            List roles = rm.getAllRolesWithSkills();
            List<Weapon> weapons = wm.getAvailableWeapon();
            for (Role role : roles) {
                List roleskills = role.getSkills();
                for (Skill sk : roleskills) {
                    String sid = sk.getId();
                    Skill skill = sm.getBasicSkill(sid);
                    ps.print(sid + " \"");
                    ps.print(skill.getName());
                    ps.print("\"\r\n");
                }
            }
            ps.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void exportCsv() {
        ArrayList<Skill> allskills = new ArrayList<Skill>();
        RoleManager rm = new RoleManager();
        SkillDAOImp sm = new SkillDAOImp();
        WeaponDAOImp wm = new WeaponDAOImp();
        List roles = rm.getAllRolesWithSkills();
        List<Weapon> weapons = wm.getAvailableWeapon();
        for (Role role : roles) {
            List roleskills = role.getSkills();
            for (Skill sk : roleskills) {
                String sid = sk.getId();
                Skill skill = sm.getSkillById(sid);
                skill.setRole(role);
                allskills.add(skill);
            }
        }
        HitStatusDAOImp hsd = new HitStatusDAOImp();
        LinkedList<HitStatus> allhitstatus = hsd.retrieveAllHitStatus();
        ExportCsv.writeheader(System.err);
        for (Skill skill : allskills) {
            ExportCsv csv = new ExportCsv(skill, allskills, weapons, allhitstatus);
            csv.write(System.err);
        }
    }

    public static void main(String[] args) {
        System.setProperty("file.encoding", "GBK");
        if (args.length < 1) {
            System.err.println("Usage: java -jar gen.jar <OG file> [dynamic|name|export]");
            return;
        }
        new CodeGen(args[0]);
        boolean dynamic = false;
        if (args.length > 1) {
            if (args[1].equals("dynamic")) {
                dynamic = true;
            } else {
                if (args[1].equals("name")) {
                    Generator.genSkillName();
                    return;
                }
                if (args[1].equals("export")) {
                    Generator.exportCsv();
                    return;
                }
            }
        }
        try {
            Generator.genSkills(dynamic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (retcode != 0) {
            System.exit(retcode);
        }
    }

    static {
        retcode = 0;
    }
}

