/*
 * Decompiled with CFR 0.152.
 */
package Cpp;

import cn.world2.game.skilleditor.vo.HitStatus;
import cn.world2.game.skilleditor.vo.HitStatusParam;
import cn.world2.game.skilleditor.vo.Skill;
import cn.world2.game.skilleditor.vo.SkillOtherVO;
import cn.world2.game.skilleditor.vo.data.AttackWay;
import cn.world2.game.skilleditor.vo.data.ProcedureVO;
import cn.world2.game.skilleditor.vo.data.SkillLevelVO;
import java.io.PrintStream;
import java.util.List;

public class ExportCsv {
    private Skill skill;
    private List skills;
    private List weapons;
    private List allhitstatus;

    private String ESCExpr(String s) {
        if (null == s) {
            s = "";
        }
        s.trim();
        if (s.length() > 0 && s.charAt(s.length() - 1) != ';') {
            s = s + ";";
        }
        return s;
    }

    HitStatus GetHitStatusStatic(String id) {
        if (null == id) {
            return null;
        }
        for (HitStatus hss : this.allhitstatus) {
            if (!id.equals(hss.getId())) continue;
            return hss;
        }
        return null;
    }

    String GetStateAttacks(List list) {
        String result = "";
        if (null == list) {
            return "";
        }
        for (HitStatusParam hsp : list) {
            if (hsp.getId().equals("-1")) continue;
            HitStatus hss = this.GetHitStatusStatic(hsp.getId());
            if (null == hss) {
                System.out.println("\tError GetHitStatusStatic: id=" + hsp.getId());
                continue;
            }
            String exp = "";
            if (hss.isNeed_probability()) {
                exp = exp + "victim.probability=1.0*" + this.ESCExpr(hsp.getProbability());
            }
            if (hss.isNeed_time()) {
                exp = exp + "victim.time=" + this.ESCExpr(hsp.getTime());
            }
            if (hss.isNeed_proportion()) {
                exp = exp + "victim.ratio=" + this.ESCExpr(hsp.getProportion());
            }
            if (hss.isNeed_increasement()) {
                exp = exp + "victim.showicon=" + this.ESCExpr(hsp.getIncreasement());
            }
            if (hss.isNeed_total()) {
                exp = exp + "victim.amount=" + this.ESCExpr(hsp.getTotal());
            }
            if (hss.isNeed_value()) {
                exp = exp + "victim.value=" + this.ESCExpr(hsp.getValue());
            }
            if (null != hss.getExecute() && hss.getExecute().length() > 0) {
                exp = exp + "victim." + hss.getExecute() + "=1;";
            }
            if (exp.length() <= 0) continue;
            result = result + exp;
        }
        return result;
    }

    public ExportCsv(Skill skill, List skills, List weapons, List allhitstatus) {
        this.skill = skill;
        this.skills = skills;
        this.weapons = weapons;
        this.allhitstatus = allhitstatus;
    }

    public static void writeheader(PrintStream ps) {
        ps.print("\u89d2\u8272ID,");
        ps.print("\u6280\u80fd\u540d\u79f0,");
        ps.print("\u56fe\u6807,");
        ps.print("\u6280\u80fd\u663e\u793a\u987a\u5e8f,");
        ps.print("\u6280\u80fd\u8bf4\u660e,");
        ps.print("\u524d\u63d0\u6280\u80fd,");
        ps.print("\u4fee\u771f\u7ea7\u522b,");
        ps.print("\u6280\u80fd\u7c7b\u578b,");
        ps.print("\u6700\u5927\u7ea7\u522b,");
        ps.print("\u4e3b\u6280\u80fd\u5c5e\u6027,");
        ps.print("\u662f\u5426\u9700\u8981\u76ee\u6807,");
        ps.print("\u9646\u5730\u662f\u5426\u6709\u6548,");
        ps.print("\u7a7a\u4e2d\u662f\u5426\u6709\u6548,");
        ps.print("\u6c34\u4e2d\u662f\u5426\u6709\u6548,");
        ps.print("\u9a91\u4e58\u662f\u5426\u6709\u6548,");
        ps.print("\u662f\u5426\u77ac\u53d1\u6280\u80fd,");
        ps.print("\u4f7f\u7528\u540e\u81ea\u52a8\u653b\u51fb,");
        ps.print("\u76ee\u6807\u4e3a\u5c38\u4f53,");
        ps.print("\u53d8\u8eab\u72b6\u6001\u9650\u5236,");
        ps.print("\u6b66\u5668\u9650\u5236,");
        ps.print("\u4e0d\u80fd\u540c\u65f6\u8d77\u4f5c\u7528\u7684\u6280\u80fd,");
        int count = 0;
        while (count++ < 3) {
            ps.print("\u8fc7\u7a0b\u540d,\u65f6\u95f4,\u9000\u51fa\u6761\u4ef6,\u5faa\u73af\u6761\u4ef6,\u65c1\u8def\u6761\u4ef6,\u7ed3\u679c\u8ba1\u7b97,\u4e2d\u65ad\u6982\u7387,\u53ef\u53d6\u6d88,\u84c4\u529b,");
        }
        ps.print("\u6548\u679c\u6587\u4ef6\u540d,");
        ps.print("\u51fb\u4e2d\u53d7\u4f24\u52a8\u4f5c\u540d,");
        ps.print("\u4f24\u5bb3\u5ef6\u65f6,");
        ps.print("\u7269\u7406\u653b\u51fb\u51c6\u786e\u5ea6\u4fee\u6b63\u500d\u6570,");
        ps.print("\u653b\u51fb\u8303\u56f4,");
        ps.print("\u6700\u5927\u6709\u6548\u8ddd\u79bb,");
        ps.print("\u5706\u67f1\u957f\u5ea6,");
        ps.print("\u5706\u67f1\u534a\u5f84,");
        ps.print("\u7403\u534a\u5f84,");
        ps.print("\u6247\u5f62\u534a\u5f84,");
        ps.print("\u6247\u5f62\u534a\u5f20\u89d2,");
        ps.print("\u6d88\u8017MP,");
        ps.print("\u541f\u5531\u8ddd\u79bb,");
        ps.print("\u6267\u884c\u65f6\u95f4,");
        ps.print("\u51b7\u5374\u65f6\u95f4,");
        ps.print("\u5bf9\u602a\u7269\u4ec7\u6068\u5ea6\u7684\u589e\u52a0,");
        ps.print("\u51fb\u4e2d\u7ed3\u679c\u72b6\u6001,");
        ps.print("\u88ab\u52a8\u6280\u80fd\u6548\u679c,");
        ps.print("\u5b66\u4e60\u6761\u4ef61,");
        ps.print("\u5b66\u4e60\u6761\u4ef62,");
        ps.print("\u5b66\u4e60\u6761\u4ef63,");
        ps.print("\u5b66\u4e60\u6761\u4ef64,");
        ps.print("\u5b66\u4e60\u6761\u4ef65,");
        ps.print("\u5b66\u4e60\u6761\u4ef66,");
        ps.print("\u5b66\u4e60\u6761\u4ef67,");
        ps.print("\u5b66\u4e60\u6761\u4ef68,");
        ps.print("\u5b66\u4e60\u6761\u4ef69,");
        ps.print("\u5b66\u4e60\u6761\u4ef610,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b971,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b972,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b973,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b974,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b975,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b976,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b977,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b978,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b979,");
        ps.print("\u5b66\u4e60\u7ed3\u679c\u8ba1\u7b9710,");
        ps.print("\u7ea7\u522b\u8981\u6c42,");
        ps.print("\u82b1\u8d39\u5143\u795e,");
        ps.print("\u5b66\u4e60\u9700\u8981\u7269\u54c1,");
        ps.print("\u5b66\u4e60\u82b1\u8d39\u91d1\u94b1,");
        ps.print("\u5347\u7ea7\u9700\u8981\u719f\u7ec3\u5ea6,");
        ps.print("\n");
    }

    public void write(PrintStream ps) {
        SkillLevelVO levelinfo;
        SkillOtherVO other = this.skill.getOtherinfo();
        AttackWay range = other.getAttackway();
        if (null == range) {
            range = new AttackWay();
        }
        if (null == (levelinfo = this.skill.getLevelinfo())) {
            levelinfo = new SkillLevelVO();
        }
        String stateattacks = this.ESCExpr(this.GetStateAttacks(this.skill.getHitstatus()));
        ps.print(this.skill.getRole().getId() + ",");
        ps.print(this.skill.getName() + ",");
        ps.print(this.skill.getIcon() + ",");
        ps.print(other.getDisplayorder() + ",");
        ps.print(this.skill.getSkilldesc() + ",");
        ps.print(this.skill.getPreconditonSkill() + ",");
        ps.print(this.skill.getReviselevel() + ",");
        ps.print(this.skill.getPassiveStatus() + ",");
        ps.print(this.skill.getMaxLevel() + ",");
        ps.print(other.getMainskillproperty() + ",");
        ps.print(this.skill.getNeedgoal() + ",");
        ps.print(other.getIsonland() + ",");
        ps.print(other.getIsinsky() + ",");
        ps.print(other.getIsinwater() + ",");
        ps.print(other.getRidable() + ",");
        ps.print(other.getIntonateActionName() + ",");
        ps.print(other.getFutihou() + ",");
        ps.print(other.getContinuoushit() + ",");
        ps.print(other.getBianshenhou() + ",");
        String strArmlimitation = new String();
        String[] arms = this.skill.getArmlimitation();
        for (int i = 0; null != arms && i < arms.length; ++i) {
            strArmlimitation = strArmlimitation + arms[i] + ";";
        }
        ps.print(strArmlimitation + ",");
        ps.print(other.getCannotusetogether() + ",");
        int count = 0;
        List procedures = this.skill.getProcedures();
        if (null != procedures) {
            boolean stateid = false;
            for (ProcedureVO p : procedures) {
                ps.print(p.getName() + ",");
                ps.print(p.getContinuetime() + ",");
                ps.print(p.getQuitCondition() + ",");
                ps.print(p.getLoopCondition() + ",");
                ps.print(p.getBypassCondition() + ",");
                ps.print(p.getComputeResult() + ",");
                ps.print(p.getAsynchronousTerminate() + ",");
                ps.print(p.getKequxiao() + ",");
                ps.print(p.getXuli() + ",");
                ++count;
            }
        }
        while (count++ < 3) {
            ps.print(",,,,,,,,,");
        }
        ps.print(other.getEffectFileName() + ",");
        ps.print(other.getHitEnjureActionName() + ",");
        ps.print(other.getFenmingtime() + ",");
        ps.print(other.getExeactionname() + ",");
        ps.print(range.getApproach() + ",");
        ps.print(range.getAttackdistance00() + ",");
        ps.print(range.getAttackdistance01() + ",");
        ps.print(range.getRadious00() + ",");
        ps.print(range.getRadious01() + ",");
        ps.print(range.getRadious02() + ",");
        ps.print(range.getAngle() + ",");
        ps.print(this.skill.getCondition() + ",");
        ps.print(this.skill.getDistance() + ",");
        ps.print(this.skill.getExecutetime() + ",");
        ps.print(this.skill.getCooltime() + ",");
        ps.print(this.skill.getHatedegree() + ",");
        ps.print(stateattacks + ",");
        ps.print(null != this.skill.getInitskilluse() && this.skill.getInitskilluse().length() > 0 ? this.skill.getInitskilluse() : this.skill.getChangeweaponskilluse() + ",");
        ps.print(levelinfo.getLevel1Learning() + ",");
        ps.print(levelinfo.getLevel2Learning() + ",");
        ps.print(levelinfo.getLevel3Learning() + ",");
        ps.print(levelinfo.getLevel4Learning() + ",");
        ps.print(levelinfo.getLevel5Learning() + ",");
        ps.print(levelinfo.getLevel6Learning() + ",");
        ps.print(levelinfo.getLevel7Learning() + ",");
        ps.print(levelinfo.getLevel8Learning() + ",");
        ps.print(levelinfo.getLevel9Learning() + ",");
        ps.print(levelinfo.getLevel10Learning() + ",");
        ps.print(levelinfo.getLevel1Cost() + ",");
        ps.print(levelinfo.getLevel2Cost() + ",");
        ps.print(levelinfo.getLevel3Cost() + ",");
        ps.print(levelinfo.getLevel4Cost() + ",");
        ps.print(levelinfo.getLevel5Cost() + ",");
        ps.print(levelinfo.getLevel6Cost() + ",");
        ps.print(levelinfo.getLevel7Cost() + ",");
        ps.print(levelinfo.getLevel8Cost() + ",");
        ps.print(levelinfo.getLevel9Cost() + ",");
        ps.print(levelinfo.getLevel10Cost() + ",");
        ps.print("\"" + levelinfo.getLevel_requirement() + "\",");
        ps.print("\"" + levelinfo.getSkill_point_requirement() + "\",");
        ps.print("\"" + other.getFly_effect_proportion() + "\",");
        ps.print("\"" + other.getFly_effect_parameter() + "\",");
        ps.print("\"" + other.getFly_effect_time() + "\",");
        ps.print("\n");
    }
}

